<?php
class API {

    private $user_agent = 'ASG-9W75DS';
    private $signature = '208ccc34a8cf2e7cdf788f901a606b42';
    private $base_url = "https://api.asg-agregator.team";

    public function __construct() {
    }

    private function send_request($payload, $url) {
    $postfields = http_build_query($payload);
    $headers = ['Content-Type: application/x-www-form-urlencoded'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    if ($response === false) {
        echo "cURL error: " . curl_error($ch);
    }
    curl_close($ch);
    return json_decode($response, true);
}


    private function base_payload($extra = []) {
        return array_merge([
            'user_agent' => $this->user_agent,
            'signature' => $this->signature
        ], $extra);
    }

    public function info_agent() {
        return $this->send_request($this->base_payload(), $this->base_url . "?cmd=info_agent");
    }

    public function info_provider() {
        return $this->send_request($this->base_payload(), $this->base_url . "?cmd=info_list_provider");
    }

    public function info_game($provider) {
        return $this->send_request($this->base_payload(['provider' => $provider]), $this->base_url . "?cmd=info_list_game");
    }

    public function info_member($user_member) {
        return $this->send_request($this->base_payload(['user_member' => $user_member]), $this->base_url . "?cmd=info_member");
    }

    public function create_member($user_member) {
        return $this->send_request($this->base_payload([
            'user_member' => $user_member
        ]), $this->base_url . "?cmd=create_member");
    }

    public function deposit_member($user_member, $deposit) {
        return $this->send_request($this->base_payload([
            'user_member' => $user_member,
            'amount' => $deposit
        ]), $this->base_url . "?cmd=deposit_member");
    }

    public function withdraw_member($user_member, $withdraw) {
        return $this->send_request($this->base_payload([
            'user_member' => $user_member,
            'amount' => $withdraw
        ]), $this->base_url . "?cmd=withdraw_member");
    }

    public function launch_game($user_member, $game_code) {
        return $this->send_request($this->base_payload([
            'user_member' => $user_member,
            'game_code' => $game_code
        ]), $this->base_url . "?cmd=launch_game");
    }
    
    public function info_bet_history($date_start,$date_end) {
        return $this->send_request($this->base_payload([
            'date_start' => $date_start,
            'date_end' => $date_end
        ]), $this->base_url . "?cmd=info_bet_history");
    }
    
    public function info_bet_member($user_member,$date_start,$date_end) {
        return $this->send_request($this->base_payload([
            'user_member' => $user_member,
            'date_start' => $date_start,
            'date_end' => $date_end
        ]), $this->base_url . "?cmd=info_bet_member");
    }
}


$X = new API();

?>
