<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\Transaction;
use App\Models\Bonus;

class SeamlesWsController extends Controller
{
    public function create($extplayer)
    {
        $api = DB::table('api_providers')->find(1);

        $params = http_build_query([
            'secureLogin' => $api->apikey,
            'externalPlayerId' => $extplayer
        ]);

        $url = 'api/account/create';

        return $this->curl_postc_2($url, $params);
    }

    public function getBalance($extplayer)
    {
        $api = DB::table('api_providers')->find(1);

        $params = http_build_query([
            'secureLogin' => $api->apikey,
            'externalPlayerId' => $extplayer
        ]);

        $url = 'api/balance/current';

        $response = $this->curl_postc_2($url, $params);
        $result = json_decode($response);

        $user = User::where('extplayer', $extplayer)->first();
        $user->balance = $result->balance;
        $user->save();

        return $result->balance;
    }

    public function getBalance2()
    {
        $api = DB::table('api_providers')->find(1);

        $params = http_build_query([
            'secureLogin' => $api->apikey,
            'externalPlayerId' => auth()->user()->extplayer
        ]);

        $url = 'api/balance/current';

        $response = $this->curl_postc_2($url, $params);
        $result = json_decode($response);

        $user = User::where('extplayer', auth()->user()->extplayer)->first();
        $user->balance = $result->balance;
        $user->save();


        return response()->json([
            'success' => true,
            'balance' => number_format(auth()->user()->balance, 2, ",", ".")
        ]);
    }

    public function deposit($extplayer, $amount)
    {
        $api = DB::table('api_providers')->find(1);

        $params = http_build_query([
            'secureLogin' => $api->apikey,
            'externalPlayerId' => $extplayer,
            'amount' => $amount
        ]);

        $url = 'api/balance/transfer';

        return $this->curl_postc_2($url, $params);
    }

    public function withdraw($extplayer, $amount)
    {
        $api = DB::table('api_providers')->find(1);

        $params = http_build_query([
            'secureLogin' => $api->apikey,
            'externalPlayerId' => $extplayer,
            'amount' => $amount
        ]);

        $url = 'api/balance/withdraw';

        return $this->curl_postc_2($url, $params);
    }

    public function launchGame(Request $request)
    {
        $api = DB::table('api_providers')->find(1);

        if ($request->gameCode == '') {
            $params = http_build_query([
                'secureLogin' => $api->apikey,
                'externalPlayerId' => auth()->user()->extplayer,
                'provider_code' => $request->providerCode,
                'platform' => 'WEB',
                'language' => 4,
                'lobbyURL' => url('/'),
            ]);
        } else {
            $params = http_build_query([
                'secureLogin' => $api->apikey,
                'externalPlayerId' => auth()->user()->extplayer,
                'provider_code' => $request->providerCode,
                'game_code' => $request->gameCode,
                'platform' => 'WEB',
                'language' => 4,
                'lobbyURL' => url('/'),
            ]);
        }

        $url = 'api/games/GameLaunch';

        $result = json_decode($this->curl_postc_2($url, $params));
        if ($result->error == 0) {
            return redirect($result->gameURL);
        } elseif ($result->error == 17) {
            $create = json_decode($this->create(auth()->user()->extplayer));
            if ($create->error == 0) {
                $user = User::where('extplayer', auth()->user()->extplayer)->first();
                $user->extplayer = $create->playerId;
                $user->save();
                $this->deposit($create->playerId, auth()->user()->balance);
                return redirect()->back()->with('error', 'Please try again');
                $message = 'Please try again';
                return view('frontend.errorplay', compact('message'));
            } else {
                $message = $result->description;
                return view('frontend.errorplay', compact('message'));
            }
        } else {
            $message = $result->description;
            return view('frontend.errorplay', compact('message'));
        }
    }

    public function getBalanceAgent()
    {
        $api = DB::table('api_providers')->find(1);

        $params = http_build_query([
            'secureLogin' => $api->apikey
        ]);

        $url = 'api/agent/balance/current';

        $response = $this->curl_postc_2($url, $params);
        $result = json_decode($response);
        return $result->balance;
    }

    function curl_postc_2($url, $payloads)
    {
        $api = DB::table('api_providers')->find(1);
        $urls = $api->url . $url;
        $params = $payloads . '&hash=' . $this->generateHash($payloads);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $urls,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $params,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    function generateHash($payload)
    {
        $api = DB::table('api_providers')->find(1);
        $hash = md5($payload . '&secretKey=' . $api->secretkey);
        return $hash;
    }
}
