<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Models\Saldo;
use App\Models\Refferal;
use App\Models\Bank;
use App\Http\Controllers\Api\AsgApi;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'username' => ['required', 'string', 'max:255'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        $username = preg_replace("/[^a-zA-Z0-9]+/", "", $data['username']);
        $email = $username.'@gmail.com';
        $user = User::create([
            'extplayer' => strtolower($username.random_string(5)),
            'username' => strtolower($username),
            'email' => $email,
            'password' => Hash::make($data['password']),
            'nama_lengkap' => $data['accName'],
            'no_hp' => $data['phone'],
            'level' => 'user',
            'balance' => 0,
            'refferal' => $data['referral'],
            'status' => 1,
            'status_game' => 1,
            'nama_bank' => 'belum',
            'nomor_rekening' => 'belum',
            'nama_pemilik' => $data['accName'],
        ]);

        $reffs = new Refferal();
        $reffs->user_id = $user->id;
        $reffs->reff_code = getReff();
        $reffs->upline = $data['referral'];
        $reffs->save();

        $end = new AsgApi();
        $end->createMember($user->extplayer);
        return $user;
    }
}
