<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Bank;

class BankController extends Controller
{
    public function index(Request $request)
    {
        if (auth()->guard('admin')->user()->level == 'master') {
            $banks = Bank::where('level', 'admin')->get();
            return view('backend.bank.bank', compact('banks'));
        } else {
            abort(404);
        }
    }

    public function edit($id, Request $request)
    {

        if (auth()->guard('admin')->user()->level == 'master') {
            $bank = Bank::find($id);
            $banks = Bank::where('level', 'admin')->get();
            return view('backend.bank.bank', compact('bank', 'banks'));
        } else {
            abort(404);
        }
    }

    public function create(Request $request)
    {
        if (auth()->guard('admin')->user()->level == 'master') {

            if ($request->hasFile('file')) {
                $url = $request->file('file')->storePublicly(
                    'ImageFile',
                    's3'
                );
                $image = $url;
            }

            $bank = new Bank();
            $bank->icon = $image;
            $bank->nama_bank = $request->nama_bank;
            $bank->nomor_rekening = $request->nomor_rekening;
            $bank->nama_pemilik = $request->nama_pemilik;
            $bank->id_user = auth()->guard('admin')->user()->id;
            $bank->level = 'admin';
            $bank->save();

            return back()->with('success', 'Bank Successfully added');
        } else {
            abort(404);
        }
    }

    public function update($id, Request $request)
    {
        if (auth()->guard('admin')->user()->level == 'master') {

            $bankss = Bank::find($id);
            if ($request->hasFile('file')) {
                $url = $request->file('file')->storePublicly(
                    'ImageFile',
                    's3'
                );
                $image = $url;
            } else {
                $image = $bankss->icon;
            }

            $bank = Bank::find($id);
            $bank->icon = $image;
            $bank->nama_bank = $request->nama_bank;
            $bank->nomor_rekening = $request->nomor_rekening;
            $bank->nama_pemilik = $request->nama_pemilik;
            $bank->id_user = auth()->guard('admin')->user()->id;
            $bank->level = 'admin';
            $bank->save();

            return back()->with('success', 'Bank Successfully update');
        } else {
            abort(404);
        }
    }

    public function delete($id, Request $request)
    {

        if (auth()->guard('admin')->user()->level == 'master') {
            $bank = Bank::find($id);
            $bank->delete();

            return back()->with('success', 'Bank Successfully deleted');
        } else {
            abort(404);
        }
    }
}
