<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $userall = User::whereYear('created_at', now()->year)->count();
        $useralldp = User::where('deposit', 1)->whereYear('created_at', now()->year)->count();
        $userallxdp = User::where('deposit', 0)->whereYear('created_at', now()->year)->count();
        $userallwd = User::where('withdraw', 1)->whereYear('created_at', now()->year)->count();
        $dpsuccall = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereYear('created_at', now()->year)->sum('total');
        $dprejall = Transaction::where('transaksi', 'Top Up')->where('status', 'Ditolak')->whereYear('created_at', now()->year)->count();
        $wdsuccall = Transaction::where('transaksi', 'Withdraw')->where('status', 'Sukses')->whereYear('created_at', now()->year)->sum('total');
        $bonusall = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereYear('created_at', now()->year)->sum('bonus_amount');
        $profit = $dpsuccall - $wdsuccall - $bonusall;

        $useram = User::whereMonth('created_at', now()->month)->count();
        $useramdp = User::where('deposit', 1)->whereMonth('created_at', now()->month)->count();
        $useramxdp = User::where('deposit', 0)->whereMonth('created_at', now()->month)->count();
        $useramlwd = User::where('withdraw', 1)->whereMonth('created_at', now()->month)->count();
        $dpsuccm = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereMonth('created_at', now()->month)->sum('total');
        $dprejm = Transaction::where('transaksi', 'Top Up')->where('status', 'Ditolak')->whereMonth('created_at', now()->month)->count();
        $wdsuccm = Transaction::where('transaksi', 'Withdraw')->where('status', 'Sukses')->whereMonth('created_at', now()->month)->sum('total');
        $bonusm = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereMonth('created_at', now()->month)->sum('bonus_amount');

        $userays = User::whereDate('created_at', now())->count();
        $useraysdp = User::where('deposit', 1)->whereDate('created_at', now())->count();
        $useraysxdp = User::where('deposit', 0)->whereDate('created_at', now())->count();
        $userayslwd = User::where('withdraw', 1)->whereDate('created_at', now())->count();
        $dpsuccys = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereDate('created_at', now())->sum('total');
        $dprejys = Transaction::where('transaksi', 'Top Up')->where('status', 'Ditolak')->whereDate('created_at', now())->count();
        $wdsuccys = Transaction::where('transaksi', 'Withdraw')->where('status', 'Sukses')->whereDate('created_at', now())->sum('total');
        $bonusys = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereDate('created_at', now())->sum('bonus_amount');

        return view('backend.dashboard', compact('userall','useralldp','userallxdp','userallwd','dpsuccall','dprejall','wdsuccall','bonusall','profit','useram','useramdp',
        'useramxdp','useramlwd','dpsuccm','dprejm','wdsuccm','bonusm','userays','useraysdp','useraysxdp','userayslwd','dpsuccys','dprejys','wdsuccys','bonusys'));
    }

    public function reports(Request $request)
    {
        if ($request->filled('from_date') && $request->filled('to_date')) {
            $trans = DB::table('reports')->whereBetween('created_at', [$request->from_date, $request->to_date]);
        } else {
            $trans = DB::table('reports')->orderby('created_at', 'desc');
        }

        return DataTables::of($trans)
            ->addIndexColumn()
            ->addColumn('created_at', function ($row) {
                $cbtrn = $row->created_at;
                return $cbtrn;
            })
            ->addColumn('members', function ($row) {
                $total_dp = number_format($row->members);
                return $total_dp;
            })
            ->addColumn('deposit', function ($row) {
                $nominal_depo = number_format($row->deposit);
                return $nominal_depo;
            })
            ->addColumn('withdraw', function ($row) {
                $total_wd = number_format($row->withdraw);
                return $total_wd;
            })
            ->addColumn('deposit_success', function ($row) {
                $nominal_wd = 'Rp.' . number_format($row->deposit_success);
                return $nominal_wd;
            })
            ->addColumn('withdraw_success', function ($row) {
                $nominal_bonus = 'Rp.' . number_format($row->withdraw_success);
                return $nominal_bonus;
            })
            ->addColumn('bonus', function ($row) {
                $nominal_bonus = 'Rp.' . number_format($row->bonus);
                return $nominal_bonus;
            })
            ->addColumn('profit', function ($row) {
                $total_profit = 'Rp.' . number_format($row->profit);
                return $total_profit;
            })
            ->rawColumns(['created_at', 'members', 'deposit', 'withdraw', 'deposit_success', 'withdraw_success', 'bonus', 'profit'])
            ->make(true);
    }

    public function balance()
    {
        $api = DB::table('api_actives')->find(1);
        $apis = DB::table('api_providers')->find($api->provider_id);

        if ($api->provider_id == 1) {
            $endpoint = $apis->url;
            $postArray = [
                'method' => $apis->apikey,
                'agent_code' => $apis->apikey,
                'agent_token' => $apis->secretkey
            ];
        } else {
            $endpoint = $apis->url;
            $postArray = [
                'method' => 'money_info',
                'agent_code' => $apis->apikey,
                'agent_token' => $apis->secretkey
            ];
        }

        $jsonData = json_encode($postArray);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response);

        $balance = number_format($result->agent->balance, 2);
        return response()->json(['balance' => $balance]);
    }

    public function cron()
    {
        $check = DB::table('reports')->whereDate('created_at', now())->first();
        $members = User::whereDate('created_at', now())->count();
        $deposit = User::where('deposit', 1)->whereDate('created_at', now())->count();
        $no_deposit = User::where('deposit', 0)->whereDate('created_at', now())->count();
        $withdraw = User::where('withdraw', 1)->whereDate('created_at', now())->count();
        $deposit_success = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereDate('created_at', now())->sum('total');
        $depo_reject = Transaction::where('transaksi', 'Top Up')->where('status', 'Ditolak')->whereDate('created_at', now())->count();
        $withdraw_success = Transaction::where('transaksi', 'Withdraw')->where('status', 'Sukses')->whereDate('created_at', now())->sum('total');
        $wd_reject = Transaction::where('transaksi', 'Withdraw')->where('status', 'Ditolak')->whereDate('created_at', now())->sum('total');
        $bonus = Transaction::where('transaksi', 'Top Up')->where('status', 'Sukses')->whereDate('created_at', now())->sum('bonus_amount');
        $profit = $deposit_success - $withdraw_success - $bonus;

        if (!$check) {
            DB::table('reports')->insert([
                'members' => $members,
                'deposit' => $deposit,
                'no_deposit' => $no_deposit,
                'withdraw' => $withdraw,
                'deposit_success' => $deposit_success,
                'withdraw_success' => $withdraw_success,
                'bonus' => $bonus,
                'depo_reject' => $depo_reject,
                'wd_reject' => $wd_reject,
                'profit' => $profit,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s")
            ]);
        } else {
            DB::table('reports')->whereDate('created_at', now())->update([
                'members' => $members,
                'deposit' => $deposit,
                'no_deposit' => $no_deposit,
                'withdraw' => $withdraw,
                'deposit_success' => $deposit_success,
                'withdraw_success' => $withdraw_success,
                'bonus' => $bonus,
                'depo_reject' => $depo_reject,
                'wd_reject' => $wd_reject,
                'profit' => $profit,
                'updated_at' => date("Y-m-d H:i:s")
            ]);
        }

        return response()->json(['status' => 'Success']);
    }
}
