<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use App\Models\Bonus;
use App\Models\Bank;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Api\AsgApi;
use Yajra\DataTables\Facades\DataTables;

class DepositController extends Controller
{
    public function index(Request $request)
    {

        $transaction = Transaction::where('transaksi', 'Top Up')->orderBy('created_at', 'desc')->where('status', 'Pending')->get();
        return view('backend.deposit.pending', compact('transaction'));
    }

    public function list(Request $request)
    {
        $transaction = Transaction::where('transaksi', 'Top Up')->orderBy('created_at', 'desc');
        if ($request->ajax()) {
            return DataTables::of($transaction)
                ->addIndexColumn()
                ->addColumn('status', function ($row) {
                    if ($row->status == 'Pending') {
                        $statusbtn = '<span class="badge bg-label-warning rounded-pill">Pending</span>';
                    } elseif ($row->status == 'Ditolak') {
                        $statusbtn = '<span class="badge bg-label-danger rounded-pill">Rejected</span>';
                    } else {
                        $statusbtn = '<span class="badge bg-label-success rounded-pill">Active</span>';
                    }
                    return $statusbtn;
                })
                ->addColumn('invoice', function ($row) {
                    $invoice = '<a href="' . $row->gambar . '" target="_blank"
                                            class="btn btn-info btn-sm">Invoice</a>';
                    return $invoice;
                })
                ->addColumn('bank_user', function ($row) {
                    if (auth()->guard('admin')->user()->level == 'master') {
                        $admin_btn = $row->dari_bank;
                    } else {
                        $admin_btn = censor($row->dari_bank, 4);
                    }
                    return $admin_btn;
                })
                ->addColumn('created_at', function ($row) {
                    $cbtrn = $row->created_at;
                    return $cbtrn;
                })
                ->addColumn('bonus', function ($row) {
                    $invoice = '<button type="button" class="btn btn-xs btn-primary" onclick="getbonusDetail(' . $row->id . ');">
                                    <span class="mdi mdi-eye"></span>
                                </button>';
                    return $invoice;
                })
                ->addColumn('total', function ($row) {
                    $amounts = 'Rp.' . number_format($row->total);
                    return $amounts;
                })
                ->rawColumns(['status', 'created_at', 'total', 'invoice', 'bank_user', 'bonus'])
                ->make(true);
        }

        return view('backend.deposit.list');
    }

    public function bonus_detail($id)
    {
        $transaction = Transaction::find($id);
        $bonus = Bonus::find($transaction->bonus);

        $bonust =  $transaction->total * $bonus->bonus / 100;

        if ($bonust > $bonus->max) {
            $totals = number_format($transaction->total + $bonus->max, 2);
        } else {
            $totals = number_format($transaction->total + $bonust, 2);
        }

        return response()->json([
            'status' => 'success',
            'percentage' => $bonus->bonus . '%',
            'amount' => 'Rp ' . $totals,
            'max' => 'Rp ' . number_format($bonus->max, 2),
            'turn_over' => 'X' . $bonus->turnover
        ]);
    }

    public function approve($id, Request $request) 
{
    $transaction = Transaction::find($id);
    $bonus = Bonus::find($transaction->bonus);
    $user = User::find($transaction->id_user);
    $bank = Bank::where('nama_bank', $transaction->metode)->where('level', 'admin')->first();

    if (!$transaction || !$user || !$bank) {
        return back()->with('error', 'Data tidak ditemukan.');
    }

    if (!empty($bonus)) {
        $bonust = $transaction->total * $bonus->bonus / 100;
        $totals = ($bonust > $bonus->max) ? $bonus->max : ($transaction->total + $bonust);
    } else {
        $totals = $transaction->total;
    }
    $explayer=$user->extplayer;
    $endas = new AsgApi();
    $endas->depositMember($explayer, $totals);
    // Langsung update status transaksi tanpa kirim ke API
    $transaction->transaction_by = auth()->guard('admin')->user()->username;
    $transaction->status = 'Sukses';
    $transaction->save();

    $bank->amount_trx += $transaction->total;
    $bank->save();


    // Optional: Update saldo user secara langsung (tanpa API)
    $user->balance += $totals;
    $user->save();

    return back()->with('success', 'Deposit berhasil disetujui.');
}



    public function reject($id, Request $request)
    {
        $transaction = Transaction::find($id);

        $transaction->status = 'Ditolak';
        $transaction->transaction_by = auth()->guard('admin')->user()->username;
        $transaction->save();

        return back()->with('success', 'Deposit Sucesssfully approved');
    }
}
