<?php
namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Result; // Pasaran
use App\Models\Taruhan;
use App\Models\Pasaran;
use App\Models\User;
use App\Http\Controllers\Api\AsgApi;

class LotteryController extends Controller
{
    // Daftar semua pasaran
    public function index()
    {
        $pasarans = Result::all();
        return view('backend.lottery.index', compact('pasarans'));
    }
   public function editResult($id)
{
    $pasaran = Result::findOrFail($id);

    // Ambil semua taruhan sesuai pasaran (market = title) dan periode
    $taruhans = Taruhan::where('market', $pasaran->title)
                       ->where('status', 1)
                       ->orderBy('date', 'desc')
                       ->get();

    $taruhan_count = $taruhans->count();

    return view('backend.lottery.update_result', compact('pasaran', 'taruhans', 'taruhan_count'));
}




    // Form update pasaran
    public function edit($id)
    {
        $pasaran = Result::findOrFail($id);
        return view('backend.lottery.update', compact('pasaran'));
    }
    

    // Update pasaran
public function update(Request $request, $id)
{
    $request->validate([
        'keluaran' => 'required|string|max:255',
        'tanggal'  => 'required|string|max:255',
        'periode'  => 'required|integer',
    ]);

    // Ambil result pasaran
    $result = Result::findOrFail($id);

    // Update result pasaran termasuk periode
    $result->keluaran = trim($request->keluaran);
    $result->tanggal  = trim($request->tanggal);
    $result->periode  = (int) $request->periode;
    $result->status   = 1;
    $result->save();

    // Insert ke tabel pasarans
    $pasaran = new Pasaran();
    $pasaran->title   = $result->title;            // nama pasaran
    $pasaran->date    = trim($request->tanggal);   // tanggal
    $pasaran->periode = (int) $request->periode;   // periode
    $pasaran->result  = trim($request->keluaran);  // hasil keluaran
    $pasaran->save();

    return redirect()->route('admin.lottery.manage')
                     ->with('success','Result berhasil diupdate & pasaran ditambahkan.');
}



    // Toggle open/close bet
    public function toggleBet($id)
{
    $pasaran = Result::findOrFail($id);
    
    // Jika status 1 (menunggu), ubah jadi 2 (sukses), jika bukan 1 ubah jadi 1 (menunggu)
    $pasaran->status = $pasaran->status == 1 ? 2 : 1;
    
    $pasaran->save();

    return redirect()->route('admin.lottery.manage')->with('success','Status pasaran diperbarui');
}

    // History semua taruhan
    public function history()
    {
        $taruhans = Taruhan::orderBy('created_at','desc')->get();
        return view('backend.lottery.history', compact('taruhans'));
    }

    // Settings untuk batasan line & hadiah
    public function settings()
    {
        $pasarans = Result::all();
        return view('backend.lottery.settings', compact('pasarans'));
    }

    public function settingsupdate(Request $request)
{
    if($request->has('pasaran_id')){
        foreach($request->pasaran_id as $id){
            $pasaran = Result::find($id);
            if($pasaran){
                $pasaran->batas_4d        = $request->batas_4d[$id] ?? $pasaran->batas_4d;
                $pasaran->batas_3d        = $request->batas_3d[$id] ?? $pasaran->batas_3d;
                $pasaran->batas_2d        = $request->batas_2d[$id] ?? $pasaran->batas_2d;
                $pasaran->hadiah_betfull  = $request->hadiah_betfull[$id] ?? $pasaran->hadiah_betfull;
                $pasaran->hadiah_diskon   = $request->hadiah_diskon[$id] ?? $pasaran->hadiah_diskon;

                // Hadiah tambahan
                $pasaran->colok_bebas     = $request->colok_bebas[$id] ?? $pasaran->colok_bebas;
                $pasaran->colok_macau     = $request->colok_macau[$id] ?? $pasaran->colok_macau;
                $pasaran->colok_naga      = $request->colok_naga[$id] ?? $pasaran->colok_naga;
                $pasaran->colok_jitu      = $request->colok_jitu[$id] ?? $pasaran->colok_jitu;
                $pasaran->shio            = $request->shio[$id] ?? $pasaran->shio;
                $pasaran->dasar           = $request->dasar[$id] ?? $pasaran->dasar;
                $pasaran->tepi            = $request->tepi[$id] ?? $pasaran->tepi;
                $pasaran->tengah          = $request->tengah[$id] ?? $pasaran->tengah;
                $pasaran->{'50-50'}       = $request->fifty_fifty[$id] ?? $pasaran->{'50-50'};
                $pasaran->kombinasi       = $request->kombinasi[$id] ?? $pasaran->kombinasi;
                $pasaran->player_banker   = $request->player_banker[$id] ?? $pasaran->player_banker;
                $pasaran->kembang_kempis  = $request->kembang_kempis[$id] ?? $pasaran->kembang_kempis;

                // Tambahan min_bet dan max_bet
                $pasaran->min_bet         = $request->min_bet[$id] ?? $pasaran->min_bet;
                $pasaran->max_bet         = $request->max_bet[$id] ?? $pasaran->max_bet;

                $pasaran->save();
            }
        }
    }

    return back()->with('success','Settings pasaran berhasil diperbarui');
}


    // Form tambah pasaran
public function create()
{
    return view('backend.lottery.tambah'); // Blade tambah.blade.php
}

// Simpan pasaran baru
public function store(Request $request)
{
    $request->validate([
        'title' => 'required|string|max:255',
        'logo' => 'required|string|max:255',
        'slug' => 'required|string|max:255|unique:results,slug',
        'buka' => 'nullable|string|max:255',
        'tutup' => 'nullable|string|max:255',
        'periode' => 'required|integer',
        'keluaran' => 'nullable|string|max:255',
        'status' => 'nullable|integer|in:1,2', // 1=Open, 2=Close
        'type' => 'nullable|integer',
        'batas_4d' => 'nullable|integer',
        'batas_3d' => 'nullable|integer',
        'batas_2d' => 'nullable|integer',
        'hadiah_betfull' => 'nullable|integer',
        'hadiah_diskon' => 'nullable|integer',
    ]);

    Result::create([
        'title' => $request->title,
        'logo' => $request->logo,
        'slug' => $request->slug,
        'buka' => $request->buka ?? '00:00',
        'tutup' => $request->tutup ?? '00:00',
        'periode' => $request->periode,
        'keluaran' => $request->keluaran ?? null,
        'status' => $request->status ?? 1, // default Open
        'type' => $request->type ?? 1,
        'batas_4d' => $request->batas_4d ?? 0,
        'batas_3d' => $request->batas_3d ?? 0,
        'batas_2d' => $request->batas_2d ?? 0,
        'hadiah_betfull' => $request->hadiah_betfull ?? 0,
        'hadiah_diskon' => $request->hadiah_diskon ?? 0,
    ]);

    return redirect()->route('admin.lottery.manage')->with('success','Pasaran berhasil ditambahkan');
}


public function updateResult(Request $request, $id)
{
    $request->validate([
        'keluaran' => 'required|string|max:255',
        'tanggal'  => 'required|string|max:255',
        'periode'  => 'required|integer',
    ]);

    $result = Result::findOrFail($id);

    $taruhans = Taruhan::where('market', $result->title)
                        ->where('date', trim($request->tanggal))
                        ->get();

    if ($taruhans->isEmpty()) {
        return back()->with('error', 'Belum ada taruhan untuk pasaran & tanggal ini.');
    }

    // Update result pasaran
    $result->update([
        'keluaran' => trim($request->keluaran),
        'tanggal'  => trim($request->tanggal),
        'periode'  => (int) $request->periode,
        'status'   => 1,
    ]);
    
    // Simpan ke tabel Pasaran (baru)
    Pasaran::create([
        'title'   => $result->title,
        'date'    => trim($request->tanggal),
        'periode' => (int) $request->periode,
        'result'  => trim($request->keluaran),
    ]);
    
    $keluaran = trim((string) $request->keluaran);
    $endas = new AsgApi();
    
    foreach ($taruhans as $t) {
        $pasang = trim($t->pasang);

        $pasang = trim($t->pasang);

// Default kalah
$t->status = 0;

// Pastikan pasang bukan kosong dan benar-benar angka
if ($pasang !== '' && ctype_digit($pasang)) {
    $panjangPasang = strlen($pasang);

    if ($panjangPasang === 1) {
        // Colok bebas: angka muncul di keluaran
        if (strpos($keluaran, $pasang) !== false) {
            $t->status = 2;
        }
    } elseif ($panjangPasang <= strlen($keluaran)) {
        // Cocokkan di akhir keluaran
        if (substr($keluaran, -$panjangPasang) === $pasang) {
            $t->status = 2;
        }
    }
}

// Jika menang, deposit ke member
if ($t->status === 2) {
    $user = User::where('username', $t->username)->first();
    if ($user) $endas->depositMember($user->extplayer, $t->win);
}

$t->save();

    }

    return redirect('/bo/lottery/manage')
                     ->with('success', 'Result berhasil diupdate, semua taruhan dicek & saldo member diupdate.');
}




}