<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Bank;
use Illuminate\Support\Facades\Hash;
use App\Models\Transaction;
use App\Models\Refferal;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

use App\Http\Controllers\Api\AsgApi;

use Yajra\DataTables\Facades\DataTables;

class MemberController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $user = User::with('Refferal');
            return DataTables::of($user)
                ->addIndexColumn()
                ->addColumn('status', function ($row) {
                    if ($row->status == 1) {
                        $statusbtn = '<span class="badge bg-label-success rounded-pill">Active</span>';
                    } else {
                        $statusbtn = '<span class="badge bg-label-danger rounded-pill">Suspend</span>';
                    }

                    return $statusbtn;
                })
                ->addColumn('action', function ($row) {
                    $action = '<a href="'.route('admin.members.list.details',$row->extplayer).'"
                    class="btn rounded-pill btn-sm btn-icon btn-primary btn-fab demo waves-effect waves-light"><i
                        class="tf-icons mdi mdi-eye-outline"></i></a>';
                    return $action;
                })
                ->addColumn('status_game', function ($row) {
                    if ($row->status_game == 0) {
                        $action = '<a href="' . url('bo') . '/members/' . $row->extplayer . '/games/1"
                    class="btn rounded-pill btn-sm btn-icon btn-danger btn-fab demo waves-effect waves-light"><i
                        class="mdi mdi-controller"></i></a>';
                    } else {
                        $action = '<a href="' . url('bo') . '/members/' . $row->extplayer . '/games/0"
                    class="btn rounded-pill btn-sm btn-icon btn-success btn-fab demo waves-effect waves-light"><i
                        class="mdi mdi-controller-off"></i></a>';
                    }
                    return $action;
                })
                ->addColumn('status', function ($row) {
                    if ($row->status == 0) {
                        $action = '<a href="' . url('bo') . '/members/' . $row->extplayer . '/status/1"
                    class="btn rounded-pill btn-sm btn-icon btn-danger btn-fab demo waves-effect waves-light"><i
                        class="mdi mdi-check-all"></i></a>';
                    } else {
                        $action = '<a href="' . url('bo') . '/members/' . $row->extplayer . '/status/0"
                    class="btn rounded-pill btn-sm btn-icon btn-success btn-fab demo waves-effect waves-light"><i
                        class="mdi mdi-cancel"></i></a>';
                    }
                    return $action;
                })
                ->addColumn('created_at', function ($row) {
                    $cbtrn = $row->created_at;
                    return $cbtrn;
                })
                ->addColumn('balance', function ($row) {
                    $amounts = 'Rp.' . number_format($row->balance);
                    return $amounts;
                })
                ->addColumn('refferal', function ($row) {
                    $refferal = $row->Refferal->reff_code;
                    return $refferal;
                })
                ->addColumn('bank_name', function ($row) {
                    $bank_name = $row->nama_bank;
                    return $bank_name;
                })
                ->addColumn('nomor_rekening', function ($row) {
                    if (auth()->guard('admin')->user()->level == 'master') {
                        $nomor_rekening = $row->nomor_rekening;
                    } else {
                        $nomor_rekening = censor($row->nomor_rekening, 4);
                    }
                    return $nomor_rekening;
                })
                ->addColumn('no_hp', function ($row) {
                    if (auth()->guard('admin')->user()->level == 'master') {
                        $nomor_rekening = $row->no_hp;
                    } else {
                        $nomor_rekening = censor($row->no_hp, 4);
                    }
                    return $nomor_rekening;
                })
                ->rawColumns(['status', 'action', 'created_at', 'balance', 'refferal', 'bank_name', 'nomor_rekening', 'status_game', 'status', 'no_hp'])
                ->make(true);
        }

        return view('backend.member.list');
    }

    public function balance()
    {
        $user = User::all();
        return view('backend.member.balance', compact('user'));
    }

    public function details($extplayer, Request $request)
    {
        $user = User::where('extplayer', $extplayer)->first();
        $reffs = Refferal::where('user_id', $user->id)->first();
        $reff = Refferal::where('upline', $reffs->reff_code)->with('User')->get();
        $reffc = Refferal::where('upline', $reffs->reff_code)->count();
        $transaction = Transaction::where('id_user', $user->id)->get();
        $ball = DB::table('trans_balls')->where('user_id', $user->id)->orderBy('created_at', 'desc')->get();
        $bonus_active = DB::table('bonus_active')->where('user_id', $user->id)->get();

        return view('backend.member.details', compact('user', 'reffs', 'reff', 'reffc', 'transaction', 'ball', 'bonus_active'));
    }

    public function update_statusb(Request $request)
    {
        DB::table('bonus_active')->where('id', $request->id)->update([
            'status' => 1,
            'updated_at' => date('Y-m-d H:i:s')
        ]);

        return back()->with('success', 'Bonus Successfully update');
    }

    public function update_statusc(Request $request)
    {
        DB::table('bonus_active')->where('id', $request->id)->update([
            'status' => 2,
            'updated_at' => date('Y-m-d H:i:s')
        ]);

        return back()->with('success', 'Bonus Successfully update');
    }

    public function balanceup(Request $request)
    {
        $user = User::where('extplayer', $request->extplayer)->first();

        $end = new AsgApi();

        if ($request->action == 1) {
            $user->balance = $user->balance + $request->amount;
            $end->depositMember($user->extplayer, $request->amount);
        } else {
            if ($user->balance < $request->amount) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Insufficient Balance'
                ]);
            }

            $end->withdrawMember($user->extplayer, $request->amount);

            $user->balance = $user->balance - $request->amount;
        }

        DB::table('trans_balls')->insert([
            'user_id' => $user->id,
            'username' => $user->username,
            'amount' => $request->amount,
            'type' => $request->action,
            'operator' => auth()->guard('admin')->user()->id,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ]);

        $user->save();

        return back()->with('success', 'Balance ' . $user->username . ' Successfully update');
    }

    public function update($id, Request $request)
    {
        $user = User::find($id);
        $user->nama_lengkap = $request->fullname;
        if ($request->newpassword) {
            $user->password = Hash::make($request->newpassword);
            $user->cpassword = $request->newpassword;
        }
        $user->save();

        return back()->with('success', 'User ' . $user->username . ' Successfully update');
    }

    public function games($id, $games, Request $request)
    {
        $user = User::where('extplayer', $id)->first();
        $user->status_game = $games;
        $user->save();
        return back()->with('success', 'User Game Successfully update');
    }

    public function status($id, $status, Request $request)
    {
        $user = User::where('extplayer', $id)->first();
        $user->status = $status;
        $user->save();
        return back()->with('success', 'User Status Successfully update');
    }

    public function checkto(Request $request)
    {
        if (!$request->accesskey) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid Key'
            ]);
        } elseif ($request->accesskey != env('APP_SECKEY')) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid Key'
            ]);
        }

        $api = DB::table('api_providers')->first();

        $data = json_decode(Http::post('https://pointerbaru.pro/api/v3/GetTo', [
            'apikey' => '3RkCbpU',
            'signature' => 'mCZcbm6RsfBve7sxm56ImoeiKIrRdNxB',
            'username' => $request->extplayer
        ]));

        return response()->json([
            'status' => 'success',
            'username' => $request->extplayer,
            'bet' => number_format($data->bet),
            'valid_bet' => number_format($data->valid_bet),
            'payout_amount' => number_format($data->payout_amount),
            'win_lose' => number_format($data->win_lose),
            'jackpot_amount' => number_format($data->jackpot_amount)
        ]);
    }

    public function banks($id, Request $request)
    {

        $user = User::find($id);
        $user->nama_bank = $request->bankname;
        $user->nomor_rekening = $request->accno;
        $user->nama_pemilik = $request->accname;
        $user->save();

        return back()->with('success', 'Bank ' . $user->username . ' Successfully update');
    }
}
