<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Bonus;
use App\Models\Floating;
use App\Models\Popup;
use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;

class PromotionController extends Controller
{
    public function index(Request $request)
    {
        $promotion = Bonus::where('type', 1)->get();
        return view('backend.promotion.promotion', compact('promotion'));
    }

    public function deposit(Request $request)
    {
        $promotion = Bonus::where('type', 2)->get();
        return view('backend.promotion.deposit', compact('promotion'));
    }

    public function editd($id, Request $request)
    {
        $edb = Bonus::find($id);
        $promotion = Bonus::where('type', 2)->get();
        return view('backend.promotion.deposit', compact('promotion', 'edb'));
    }

    public function edit($id, Request $request)
    {
        $edb = Bonus::find($id);
        $promotion = Bonus::where('type', 1)->get();
        return view('backend.promotion.promotion', compact('promotion', 'edb'));
    }

    public function create(Request $request)
    {
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $gambar = $url;
        } else {
            $gambar = NULL;
        }

        $promotion = new Bonus();
        $promotion->slug = Str::slug($request->judul);
        $promotion->gambar = $gambar;
        $promotion->judul = $request->judul;
        $promotion->text = $request->deskripsi;
        $promotion->minimal_deposit = $request->minimal_depo;
        $promotion->max = $request->max;
        $promotion->bonus = $request->bonus;
        $promotion->turnover = $request->to;
        $promotion->status = $request->status;
        $promotion->type = $request->type;
        $promotion->save();
        return back()->with('success','Promotion Successfully added');
    }

    public function update($id, Request $request)
    {
        $promotion = Bonus::find($id);
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $gambar = $url;
        } else {
            $gambar = $promotion->gambar;
        }

        $promotion->slug = Str::slug($request->judul);
        $promotion->gambar = $gambar;
        $promotion->judul = $request->judul;
        $promotion->text = $request->deskripsi;
        $promotion->minimal_deposit = $request->minimal_depo;
        $promotion->max = $request->max;
        $promotion->bonus = $request->bonus;
        $promotion->turnover = $request->to;
        $promotion->status = $request->status;
        $promotion->save();

        return back()->with('success','Promotion Successfully update');
    }

    public function delete($id, Request $request)
    {
        $bank = Bonus::find($id);
        $bank->delete();

        return back()->with('success','Promotion Successfully deleted');
    }

    public function banner(Request $request)
    {
        $banner = Banner::all();
        return view('backend.promotion.banner', compact('banner'));
    }

    public function bcreate(Request $request)
    {
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $gambar = $url;
        }

        $banner = new Banner();
        $banner->gambar = $gambar;
        $banner->status = 'active';
        $banner->save();
        return back()->with('success','Banner Successfully added');
    }

    public function bdelete($id, Request $request)
    {
        $bank = Banner::find($id);
        $bank->delete();
        return back()->with('success','Banner Successfully deleted');
    }

    public function popup(Request $request)
    {

        $popup = Popup::first();
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $gambar = $url;
        } else {
            $gambar = $popup->gambar;
        }
        $popup->gambar = $gambar;
        $popup->status = $request->status;
        $popup->save();
        return back()->with('success','Popup Successfully updated');
    }

    public function float(Request $request)
    {
        $floating = Floating::all();
        $popup = Popup::first();
        return view('backend.floating.floating', compact('floating', 'popup'));
    }


    public function floatedit($id, Request $request)
    {
        $floating = Floating::all();
        $floats = Floating::find($id);
        $popup = Popup::first();
        return view('backend.floating.floating', compact('floating', 'floats', 'popup'));
    }

    public function floatcreate(Request $request)
    {
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $image = $url;
        }

        $floating = new Floating();
        $floating->image = $image;
        $floating->url = $request->url;
        $floating->save();

        return back()->with('success','Floating Successfully Created');
    }

    public function floatupdate($id, Request $request)
    {

        $floating = Floating::find($id);
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $image = $url;
        } else {
            $image = $floating->image;
        }
        $floating->image = $image;
        $floating->url = $request->url;
        $floating->save();
        return back()->with('success','Floating Successfully updated');

    }

    public function floatdelete($id, Request $request)
    {
        $bank = Floating::find($id);
        $bank->delete();

        return back()->with('success','Floating Successfully deleted');

    }
}
