<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ApiActive;
use App\Models\ApiProvider;
use App\Http\Controllers\Api\SeamlesWsController;


class ProviderController extends Controller
{

    public function index(Request $request)
    {
        $apiss = ApiProvider::all();
        $api = ApiActive::first();
        $ip = '123.456.789';
        return view('backend.api', compact('apiss', 'api','ip'));
    }


    public function call(Request $request)
    {
        $api = new SeamlesWsController();
        $playing = $api->call_players();
        $api = ApiActive::first();

        return view('backend.call', compact('playing'));
    }

    public function call_players(Request $request)
    {
        $api = new SeamlesWsController();
        $playing = $api->call_players();

        return $playing;
    }

    public function call_list(Request $request)
    {
        $api = new SeamlesWsController();
        $playing = $api->call_list($request->providerCode,$request->gameCode);

        return $playing;
    }

    public function call_apply(Request $request)
    {
        $api = new SeamlesWsController();
        $playing = $api->call_apply($request->providerCode,$request->gameCode,$request->userCode,$request->callRtp,$request->callType);

        return $playing;
    }

    public function rtp(Request $request)
    {
        $api = new SeamlesWsController();
        $playing = $api->control_rtp($request->providerCode,$request->userCode,$request->rtp);

        return $playing;
    }

    public function edit($id, Request $request)
    {
        $apiss = ApiProvider::find($id);
        $apiss->apikey = $request->apikey;
        $apiss->secretkey = $request->secretkey;
        $apiss->url = $request->endpoint;
        $apiss->save();

        return back()->with('success', 'API Successfully update');
    }

    public function use($id, Request $request)
    {
        if (!$request->accesskey) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid Key'
            ]);
        } elseif ($request->accesskey != env('APP_SECKEY')) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid Key'
            ]);
        }
        $apiss = ApiProvider::find($id);

        $api = ApiActive::first();
        $api->provider_id = $apiss->id;
        $api->title = $apiss->provider;
        $api->save();

        return response()->json([
            'status' => 'success',
            'message' => 'API Successfully update'
        ]);
    }
}
