<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Settings;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use App\Models\Contact;
use Yajra\DataTables\Facades\DataTables;

class SettingController extends Controller
{
    public function index(Request $request)
    {
        $web = Settings::first();
        $meta = DB::table('meta_tags')->get();
        return view('backend.settings.seo', compact('web','meta'));
    }

    public function create_meta(Request $request)
    {
        DB::table('meta_tags')->insert([
            'tag' => $request->tag,
            'title' => $request->title,
            'url' => $request->url
        ]);

        return back()->with('success', 'Meta Successfully created');
    }

    public function meta_delete($id)
    {
        DB::table('meta_tags')->where('id', $id)->delete();
        return back()->with('success', 'Meta Successfully deleted');
    }

    public function logo(Request $request)
    {
        $web = Settings::first();
        return view('backend.settings.logo', compact('web'));
    }

    public function general(Request $request)
    {
        $web = Settings::first();
        $contact = Contact::first();
        return view('backend.settings.general', compact('web', 'contact'));
    }

    public function contact(Request $request)
    {
        $contact = DB::table('tb_turnover')->get();
        return view('backend.settings.contact', compact('contact'));
    }

    public function contact_edit($id)
    {
        $contacts = DB::table('tb_turnover')->where('id', $id)->first();
        $contact = DB::table('tb_turnover')->get();
        return view('backend.settings.contact', compact('contacts', 'contact'));
    }


    public function create_contact(Request $request)
    {
        DB::table('tb_turnover')->insert([
            'icon' => $request->icon,
            'title' => $request->title,
            'url' => $request->url
        ]);

        return redirect()->route('admin.settings.contact')->with('success', 'Contact Successfully created');
    }

    public function update_contact($id,Request $request)
    {
        DB::table('tb_turnover')->where('id',$id)->update([
            'icon' => $request->icon,
            'title' => $request->title,
            'url' => $request->url
        ]);

        return redirect()->route('admin.settings.contact')->with('success', 'Contact Successfully updated');
    }

    public function contact_delete($id)
    {
        DB::table('tb_turnover')->where('id', $id)->delete();
        return redirect()->route('admin.settings.contact')->with('success', 'Contact Successfully deleted');
    }

    public function general_update(Request $request)
    {
        $web = Settings::first();
        $contact = Contact::first();
        $web->min_depo = $request->min_depo;
        $web->min_wd = $request->min_wd;
        $web->judul = $request->judul;
        $web->warna = $request->warna;
        $web->warna_mobile = $request->warna_mobile;
        $web->jackpot = $request->jackpot;
        $contact->id_livechat = $request->livechat;
        $contact->script_livechat = $request->script_livechat;
        $contact->no_whatsapp = $request->wa;
        $contact->save();
        $web->save();

        return back()->with('success', 'Website Successfully updated');
    }

    public function logo_update(Request $request)
    {
        $web = Settings::first();
        if ($request->hasFile('logo')) {
            $url = $request->file('logo')->storePublicly(
                'ImageFile',
                's3'
            );

            $logo = $url;
        } else {
            $logo = $web->logo;
        }

        if ($request->hasFile('icon_web')) {
            $url = $request->file('icon_web')->storePublicly(
                'ImageFile',
                's3'
            );

            $icon_web = $url;
        } else {
            $icon_web = $web->icon_web;
        }

        if ($request->hasFile('banner')) {
            $url = $request->file('banner')->storePublicly(
                'ImageFile',
                's3'
            );

            $banner = $url;
        } else {
            $banner = $web->banner;
        }

        $web->logo = $logo;
        $web->banner = $banner;
        $web->icon_web = $icon_web;
        $web->save();

        return back()->with('success', 'Website Successfully updated');
    }

    public function seo_update(Request $request)
    {
        $web = Settings::first();
        $web->title = $request->title;
        $web->deskripsi = $request->deskripsi;
        $web->keyword = $request->keyword;
        $web->articles = $request->articles;
        $web->save();

        return back()->with('success', 'Website Successfully updated');
    }
}
