<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Result;
use App\Models\Pasaran;
use App\Models\Taruhan;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\Settings;
use App\Http\Controllers\Api\SeamlesWsController;
use Yajra\DataTables\Facades\DataTables;

class TaruhanController extends Controller
{
    public function index(Request $request)
    {
        $pasaran = Result::all();
        return view('backend.taruhan.pasaran', compact('pasaran'));
    }

    public function pasaranedit($id, Request $request)
    {
        $data = Result::find($id);
        $pasaran = Result::all();
        return view('backend.taruhan.pasaran', compact('pasaran', 'data'));
    }

    public function pasaranupdate($id, Request $request)
    {
        $data = Result::find($id);
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $logo = config('filesystems.disks.s3.url') . $url;
        } else {
            $logo = $data->logo;
        }

        $data->title = $request->title;
        $data->logo = $logo;
        $data->buka = $request->buka;
        $data->tutup = $request->tutup;
        $data->save();
        return back()->with('success', 'Market Successfully updated');
    }

    public function pasarancreate(Request $request)
    {
        $data = new Result();
        if ($request->hasFile('file')) {
            $url = $request->file('file')->storePublicly(
                'ImageFile',
                's3'
            );

            $data->logo = config('filesystems.disks.s3.url') . $url;
        }

        $data->slug = Str::slug($request->title);
        $data->title = $request->title;
        $data->buka = $request->buka;
        $data->tutup = $request->tutup;
        $data->type = 2;
        $data->save();

        return back()->with('success', 'Market Successfully created');
    }

    public function pasarandelete($id, Request $request)
    {
        $data = Result::find($id);
        $data->delete();
        return back()->with('success', 'Market Successfully deleted');
    }

    public function result(Request $request)
    {
        $pasaran = Result::all();
        $result = Pasaran::orderby('created_at', 'desc')->get();
        return view('backend.taruhan.result', compact('pasaran', 'result'));
    }

    public function active(Request $request)
    {
        if ($request->market == null) {
            $taruhan = Taruhan::where('status', 1)->whereDate('created_at', '=', today())->orderby('created_at', 'desc');
        } else {
            $taruhan = Taruhan::where('status', 1)->where('market', '=', $request->market)->whereDate('created_at', '=', today())->orderby('created_at', 'desc');
        }
        if ($request->ajax()) {
            return DataTables::of($taruhan)
                ->addIndexColumn()
                ->addColumn('status', function ($row) {
                    if ($row->status == 1) {
                        $statusbtn = '<span class="badge bg-label-warning rounded-pill">Running</span>';
                    } elseif ($row->status == 2) {
                        $statusbtn = ' <span class="badge bg-label-success rounded-pill">Win</span>';
                    } else {
                        $statusbtn = '<span class="badge bg-label-danger rounded-pill">Lose</span>';
                    }
                    return $statusbtn;
                })
                ->addColumn('created_at', function ($row) {
                    $cbtrn = $row->created_at;
                    return $cbtrn;
                })
                ->addColumn('amount', function ($row) {
                    $bonus = number_format($row->amount, 2);
                    return $bonus;
                })
                ->addColumn('amount_bet', function ($row) {
                    $bonus = number_format($row->amount_bet, 2);
                    return $bonus;
                })
                ->addColumn('win', function ($row) {
                    $bonus = number_format($row->win, 2);
                    return $bonus;
                })
                ->rawColumns(['status', 'created_at','amount_bet', 'amount', 'win'])
                ->make(true);
        }
        $pasaran = Result::all();
        return view('backend.taruhan.active', compact('pasaran'));
    }

    public function history(Request $request)
    {
        $taruhan = Taruhan::where('status','!=', 1)->orderby('created_at', 'desc');

        if ($request->ajax()) {
            return DataTables::of($taruhan)
                ->addIndexColumn()
                ->addColumn('status', function ($row) {
                    if ($row->status == 1) {
                        $statusbtn = '<span class="badge bg-label-warning rounded-pill">Running</span>';
                    } elseif ($row->status == 2) {
                        $statusbtn = ' <span class="badge bg-label-success rounded-pill">Win</span>';
                    } else {
                        $statusbtn = '<span class="badge bg-label-danger rounded-pill">Lose</span>';
                    }
                    return $statusbtn;
                })
                ->addColumn('created_at', function ($row) {
                    $cbtrn = $row->created_at;
                    return $cbtrn;
                })
                ->addColumn('amount', function ($row) {
                    $bonus = number_format($row->amount, 2);
                    return $bonus;
                })
                ->addColumn('amount_bet', function ($row) {
                    $bonus = number_format($row->amount_bet, 2);
                    return $bonus;
                })
                ->addColumn('win', function ($row) {
                    $bonus = number_format($row->win, 2);
                    return $bonus;
                })
                ->rawColumns(['status', 'created_at','amount_bet', 'amount', 'win'])
                ->make(true);
        }
        $pasaran = Result::all();
        return view('backend.taruhan.history', compact('pasaran'));
    }

    public function settings(Request $request)
    {
        $settings = Settings::first();
        return view('backend.taruhan.settings', compact('settings'));
    }

    public function settingsupdate(Request $request)
    {
        $web = Settings::first();
        $web->diskon4d = $request->diskon4d;
        $web->diskon3d = $request->diskon3d;
        $web->diskon2d = $request->diskon2d;
        $web->prize4d = $request->prize4d;
        $web->prize3d = $request->prize3d;
        $web->prize2d = $request->prize2d;
        $web->save();

        return back()->with('success', 'Lottery settings Successfully updated');
    }

    public function create(Request $request)
    {
        $pasaran = new Pasaran();
        $pasaran->title = $request->title;
        $pasaran->date = $request->date;
        $pasaran->periode = $request->periode;
        $pasaran->result = $request->result;
        $pasaran->save();

        $result = Result::where('title', $request->title)->first();
        $result->keluaran = $request->result;
        $result->tanggal = $request->date;
        $result->periode = $request->periode;
        $result->save();

        return back()->with('success', 'Result Sucesssfully created');
    }

    public function approve(Request $request)
    {
        $taruhans = Taruhan::where('pasang','=', $request->result)->where('market', $request->title)->where('status', 1)->whereDate('created_at', '=', today())->get();

        foreach ($taruhans as $taruhan) {
            $data = Taruhan::find($taruhan->id);
            $data->status = 2;
            $data->save();
            $user = User::find($data->user_id);
            $end = new SeamlesWsController();
            $end->deposit($user->extplayer, $data->win);

            $user->balance = $user->balance + $data->win;
            $user->save();
        }

        return back()->with('success', 'Betting Successfully Wining');
    }

    public function reject(Request $request)
    {
        $taruhans = Taruhan::where('pasang','=', $request->result)->where('market', $request->title)->where('status', 1)->whereDate('created_at', '=', today())->get();

        foreach ($taruhans as $taruhan) {
            $data = Taruhan::find($taruhan->id);
            $data->status = 3;
            $data->save();
        }

        return back()->with('success', 'Betting Successfully Lose');
    }
}
