<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use App\Models\Bonus;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\Api\AsgApi;

class WithdrawController extends Controller
{

    public function index(Request $request)
    {
        $transaction = Transaction::where('transaksi','Withdraw')->where('status','Pending')->orderBy('created_at','desc')->get();
        return view('backend.withdraw.pending', compact('transaction'));
    }

    public function list(Request $request)
    {
        $transaction = Transaction::where('transaksi','Withdraw')->orderBy('created_at','desc');
        if ($request->ajax()) {
            return DataTables::of($transaction)
                ->addIndexColumn()
                ->addColumn('status', function ($row) {
                    if ($row->status == 'Pending') {
                        $statusbtn = '<span class="badge bg-label-warning rounded-pill">Pending</span>';
                    } elseif ($row->status == 'Ditolak') {
                        $statusbtn = '<span class="badge bg-label-danger rounded-pill">Rejected</span>';
                    } else {
                        $statusbtn = '<span class="badge bg-label-success rounded-pill">Active</span>';
                    }
                    return $statusbtn;
                })
                ->addColumn('bank_user', function ($row) {
                    if (auth()->guard('admin')->user()->level == 'master') {
                        $admin_btn = $row->dari_bank;
                    } else {
                        $admin_btn = censor($row->dari_bank,4);
                    }
                    return $admin_btn;
                })
                ->addColumn('created_at', function ($row) {
                    $cbtrn = $row->created_at;
                    return $cbtrn;
                })
                ->addColumn('total', function ($row) {
                    $amounts = 'Rp.' . number_format($row->total);
                    return $amounts;
                })
                ->rawColumns(['status','created_at', 'total','bank_user'])
                ->make(true);
        }

        return view('backend.withdraw.list');
    }

    public function approve($id, Request $request)
    {
        $transaction = Transaction::find($id);
        $transaction->transaction_by = auth()->guard('admin')->user()->username;
        $transaction->status = 'Sukses';
        $transaction->save();

        return back()->with('success', 'Withdraw Sucesssfully approved');

    }
    public function reject($id, Request $request)
{
    $transaction = Transaction::find($id);
    $user = User::find($transaction->id_user);

    if (!$transaction || !$user) {
        return back()->with('error', 'Data tidak ditemukan.');
    }

    $explayer = $user->extplayer;
    $endas = new AsgApi();
    // Panggil API tapi abaikan hasilnya
    $endas->depositMember($explayer, $transaction->total);
    $user->balance = $transaction->total;
    $user->save();
    // Langsung update status tanpa cek hasil API
    $transaction->status = 'Ditolak';
    $transaction->transaction_by = auth()->guard('admin')->user()->username;
    $transaction->save();

    // Jika mau update balance user secara manual (optional)
    // $user->balance -= $transaction->total; 
    // $user->save();

    return back()->with('success', 'Withdraw berhasil ditolak.');
}

}
