<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Provider;
use App\Models\Result;
use App\Http\Controllers\Api\SeamlesWsController;

class GameController extends Controller
{
    public function slot(Request $request)
    {
        $pageTitle = 'Slot';
        $provider = Provider::where('type', 'slot')->where('provider_code', 1)->get();
        return view('frontend.games.slot', compact('provider', 'pageTitle'));
    }

    public function arcade()
    {
        $pageTitle = 'Arcade';
        $provider = Provider::where('type', 'arcade')->where('provider_code', 8)->get();
        return view('frontend.games.sports', compact('provider', 'pageTitle'));
    }

    public function sports()
    {
        $pageTitle = 'Sports';
        $provider = Provider::where('type', 'sportsbook')->where('provider_code', 3)->get();
        $games = DB::table('game_lists')->where('GameType', 3)->get();
        return view('frontend.games.sports', compact('provider', 'pageTitle', 'games'));
    }

    public function lottery()
    {
        $pageTitle = 'Lottery';
        $provider = Provider::where('type', 'lottery')->where('provider_code', 9)->get();
        return view('frontend.games.lotterys', compact('provider', 'pageTitle'));
    }

    public function lotterys()
    {
        $pageTitle = 'Lottery';
        $data = Result::all();
        return view('frontend.games.lots', compact('data', 'pageTitle'));
    }

    public function live()
    {
        $pageTitle = 'Live Game';
        $provider = Provider::where('type', 'cockfighting')->where('provider_code', 9)->get();
        $games = DB::table('game_lists')->where('GameType', 9)->get();
        return view('frontend.games.sports', compact('provider', 'pageTitle', 'games'));
    }

    public function casino($slug, $provider_code)
{
    // 1. Get the provider with validation
    $provider = Provider::where('slug', $slug)
                ->where('provider_code', $provider_code)
                ->firstOrFail();

    // 2. Check provider status
    if ($provider->status != 1) {
        return view('frontend.games.maintenance', [
            'provider_name' => $provider->provider_name
        ]);
    }

    // 3. Get games matching both provider code AND game type
    $games = DB::table('game_lists')
                ->where('provider', $provider->ProviderCode)
                ->where('game_type', $provider->GameType) // Match game types
                ->where('status', 1)
                ->orderBy('sequence', 'asc')
                ->get();

    // 4. Return view with data
    return view('frontend.games.list', [
        'provider' => $provider,
        'games' => $games
    ]);
}
public function gamesByType($type, $slug)
{
    // 1. Get the provider by slug
    $provider = Provider::where('slug', $slug)
                ->firstOrFail();

    // 2. Check provider status
    if ($provider->status != 1) {
        return view('frontend.games.maintenance', [
            'provider_name' => $provider->provider_name
        ]);
    }

    // 3. Get games matching both type and provider
    $games = DB::table('game_lists')
                ->where('game_type', $type)          // Filter by game type
                ->where('provider', $provider->ProviderCode)  // Filter by provider
                ->where('status', 1)                 // Only active games
                ->orderBy('sequence', 'asc')
                ->get();

    // 4. Return view with data
    return view('frontend.games.type_list', [
        'provider' => $provider,
        'games' => $games,
        'game_type' => $type
    ]);
}
    public function game($slug)
{
    $provider = Provider::where('slug', $slug)->where('provider_code', 1)->first();
    if ($provider->status != 1) {
        $provider_name = $provider->provider;
        return view('frontend.games.maintenance', compact('provider_name'));
    }
    $priorityGames = ['Gates of Olympus Xmas 1000', 'Gates Of Olympus 1000', 'Starlight Princess 1000', 'Mahjong Wins 3 - Black Scatter', 'Gates of Olympus Super Scatter', 'Wild Bandito','Mahjong Ways 2', 'Mahjong Ways']; 

    $games = DB::table('game_lists')
        ->where('provider', $provider->ProviderCode)
        ->where('game_type', $provider->GameType)
        ->where('status', 1)
        ->orderByRaw("FIELD(game_name, '".implode("','", $priorityGames)."') DESC")
        ->orderBy('sequence', 'asc')
        ->get();
    return view('frontend.games.list', compact('provider', 'games'));
}
    public function fishing($slug)
{
    $provider = Provider::where('slug', $slug)->where('provider_code', 4)->first();
    if ($provider->status != 1) {
        $provider_name = $provider->provider;
        return view('frontend.games.maintenance', compact('provider_name'));
    }
    $games = DB::table('game_lists')
        ->where('provider', $provider->ProviderCode)
        ->where('game_type', $provider->GameType)
        ->where('status', 1)
        ->orderBy('sequence', 'asc')
        ->get();
    return view('frontend.games.list', compact('provider', 'games'));
}

    public function arcades($slug)
    {
        $provider = Provider::where('slug', $slug)->where('provider_code', 8)->first();
        $games = DB::table('game_lists')->where('Provider', $provider->provider)->where('GameType', 8)->get();
        return view('frontend.games.list', compact('provider', 'games'));
    }

    public function launch_game(Request $request)
    {
        if (auth()->user()->status_game == 0) {
            return back()->with('error','Mohon maaf akun anda terkunci untuk mengakses permainan, Silahkan hubungi CS untuk informasi lebih lanjut!');
        }

        $api = DB::table('api_providers')->first();
        $extplayer = auth()->user()->extplayer;
        $url = url('/');
        $endpoint = "{$api->url}LaunchGame?apikey={$api->apikey}&signature={$api->secretkey}&username={$extplayer}&providerCode={$request->providerCode}&gameCode={$request->gameCode}&gameType={$request->gameType}&LobbyURL={$url}&game_provider=4";

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
        ));


        $response = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($response);

        if ($result->ErrorCode == 0) {
            return redirect($result->Url);
        } else {
            if ($request->gameType == 1) {
                $games = DB::table('game_lists')->where('ProviderCode', $request->providerCode)->where('GameType', $request->gameType)->first();
                $provider_name = $games->Provider;
            } else {
                $provider = Provider::where('ProviderCode', $request->providerCode)->where('provider_code', $request->gameType)->first();
                $provider_name = $provider->provider;
            }

            return view('frontend.games.maintenance',compact('provider_name'));
        }
    }
   
}
