<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Models\Pasaran;
use App\Models\Result;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

use App\Models\User;
use App\Models\Transaction;
use App\Models\Refferal;
use App\Models\Bank;
use App\Http\Controllers\Api\AsgApi;
use Illuminate\Support\Str;


class HomeController extends Controller
{
    public function index()
    {
        $banner = DB::table('tb_banner')->where('status', 'active')->get();
        $popup = DB::table('tb_popup')->where('status', 'active')->first();
        $popular = DB::table('game_lists')->where('game_type', 'SL')->where('provider', 'PR')->where('status',1)->orderBy('sequence','asc')->limit(12)->get();
        $bank = DB::table('tb_bank')->where('level', 'admin')->get();
        $promotion = DB::table('tb_bonus')->where('status', 'active')->where('type', '!=', 2)->get();
        return view('frontend.index', compact('banner', 'popup', 'bank', 'promotion', 'popular'));
    }


public function registers(Request $request)
{
    $username = preg_replace("/[^a-zA-Z0-9]+/", "", $request->username);
    $end = new AsgApi();

    if (User::where('username', $username)->exists()) {
        return redirect()->back()->with('error', 'Username telah terdaftar');
    }

    if (User::where('no_hp', $request->phone)->exists()) {
        return redirect()->back()->with('error', 'Nomor Telepon telah terdaftar');
    }

    $apiUsername = strtolower($username . Str::random(2));

    $apiResponse = $end->createMember($apiUsername);

    // Karena $apiResponse sudah array, tidak perlu json_decode()
    if (empty($apiResponse) || !isset($apiResponse['data']['username'])) {
        return redirect()->back()->with('error', 'Gagal membuat member di API');
    }

    $user = User::create([
        'extplayer'     => $apiResponse['data']['username'],
        'username'      => strtolower($username),
        'email'         => strtolower($username) . '@gmail.com',
        'password'      => Hash::make($request->password),
        'cpassword'     => null,
        'nama_lengkap'  => $request->accName,
        'no_hp'         => $request->phone,
        'level'         => 'user',
        'balance'       => '0',
        'refferal'      => $request->referral ?? null,
        'status'        => '1',
        'status_game'   => '1',
        'nama_bank'     => 'notset',
        'nomor_rekening'=> 'notset',
        'nama_pemilik'  => $request->accName,
    ]);

    // Simpan referral
    $reffs = new Refferal();
    $reffs->user_id = $user->id;
    $reffs->reff_code = getReff();
    $reffs->upline = $request->referral;
    $reffs->save();

    Auth::login($user);

    return redirect('/');
}




    public function login()
    {
        return view('frontend.auth.login');
    }

    public function register()
    {
        return view('frontend.auth.register');
    }

    public function refferal()
    {
        return view('frontend.refferal');
    }


    public function checkCaptcha(Request $request)
    {
        if (!captcha_check($request->captcha)) {
            return response()->json([
                'success' => false,
                'code' => -1,
                'data' => [
                    'message' => 'Kode captcha tidak valid'
                ]
            ]);
        }

        return response()->json([
            'success' => true,
            'code' => 1
        ]);
    }

    public function v2_acc_login(Request $request)
    {
        $check_us = User::where('username',$request->username)->first();
        if (empty($check_us)) {
            return response()->json([
                'success' => false,
                'code' => -1,
                'data' => [
                    'message' => 'Username atau kata sandi salah'
                ]
            ]);
        }

        $generatedHash = hash_equals(hash('sha256', hash('sha256', $check_us->cpassword) . $request->token),$request->password);

        if ($generatedHash) {
            if (!Hash::check($check_us->cpassword,$check_us->password)) {
                return response()->json([
                    'success' => false,
                    'code' => -1,
                    'data' => [
                        'message' => 'Username atau kata sandi salah'
                    ]
                ]);
            } else {
                Auth::login($check_us);
                return response()->json([
                    'success' => false,
                    'code' => 1,
                    'data' => [
                        'message' => 'Anda telah berhasil masuk. Login terakhir Anda tanggal : '. now()
                    ]
                ]);
            }
        } else {
            return response()->json([
                'success' => false,
                'code' => -1,
                'data' => [
                    'message' => 'Username atau kata sandi salah'
                ]
            ]);
        }
    }

    public function testapi(Request $request)
    {
        $end = new AsgApi();
        return $end->createMember('boskiks');
    }

    public function popular()
    {
        $popular = DB::table('game_lists')->where('game_type', 'SL')->where('provider', 'PR')->where('status',1)->orderBy('sequence','asc')->limit(12)->get();
        return view('frontend.popular', compact('games'));
    }

    public function news()
    {
        return view('frontend.page.news');
    }

    public function help()
    {
        return view('frontend.page.help');
    }

    public function contact()
    {
        $contact = DB::table('tb_turnover')->get();

        return view('frontend.page.contact',compact('contact'));
    }

    public function getresult()
    {
        $data = json_decode(Http::post('https://mccarthyfamilyfdn.org/index.json'));
        return "success";
    }

    public function check(Request $request)
    {
        $user = DB::table('users')->where('username', $request->username)->first();
        if (!$user) {
            return response()->json([
                'error' => 'Nama Pengguna Bisa digunakan.',
                'success' => false
            ], 200);
        } elseif (!empty($user)) {
            return response()->json([
                'error' => 'Nama Pengguna Sudah Terdaftar',
                'success' => true
            ], 200);
        }
    }

    public function phone(Request $request)
    {
        $user = DB::table('users')->where('no_hp', $request->phone)->first();
        if (!$user) {
            return response()->json([
                'error' => 'Nomor Telepon Bisa digunakan.',
                'success' => false
            ], 200);
        } elseif (!empty($user)) {
            return response()->json([
                'error' => 'Nomor Telepon Sudah Terdaftar',
                'success' => true
            ], 200);
        }
    }

    public function norek(Request $request)
    {
        $bank = DB::table('tb_bank')->where('id', $request->id)->first();
        return response()->json([
            'success' => false,
            'data' => $bank->nomor_rekening
        ], 200);
    }

    public function promotion()
    {
        $promotion = DB::table('tb_bonus')->where('status', 'active')->where('type', '=', 1)->get();
        return view('frontend.promotion.promotion', compact('promotion'));
    }

    public function promotiondetail($slug)
    {
        $promotion = DB::table('tb_bonus')->where('status', 'active')->where('type', '=', 1)->get();
        $now = DB::table('tb_bonus')->where('slug', $slug)->where('type', '=', 1)->first();
        return view('frontend.promotion.detail', compact('promotion', 'now'));
    }
    

public function launchGame(Request $request)
{
    $user = auth()->user();
    if (!$user) {
        return redirect()->route('login.form')->with('error', 'Silakan login terlebih dahulu');
    }

    $gameCode = $request->query('gamecode'); // ambil dari query param ?gamecode=1

    if (!$gameCode) {
        return redirect()->back()->with('error', 'Kode game tidak ditemukan');
    }

    $asgApi = new AsgApi();

    $response = $asgApi->launchGame($user->extplayer, $gameCode);

    // dd($response); // debug response kalau perlu

    if (isset($response['status']) && $response['status'] == 200 && isset($response['data']['gameUrl'])) {
        return redirect($response['data']['gameUrl']);
    } elseif (isset($response['error']) && $response['error'] == 17) {
        $create = $asgApi->create($user->extplayer);
        if (isset($create['error']) && $create['error'] == 0) {
            $user->extplayer = $create['playerId'];
            $user->save();

            return redirect()->back()->with('error', 'Player baru dibuat, silakan coba lagi');
        } else {
            $message = $create['description'] ?? 'Gagal membuat player baru';
            return view('frontend.errorplay', compact('message'));
        }
    } else {
        $message = $response['description'] ?? 'Gagal membuka game';
        return view('frontend.errorplay', compact('message'));
    }
}

public function launchGames(Request $request)
{
    $user = auth()->user();
    if (!$user) {
        return redirect()->route('login.form')->with('error', 'Silakan login terlebih dahulu');
    }

    $providerCode = $request->query('gamecode'); // ambil dari query param ?gamecode=pragmatic

    // Ambil game_code berdasarkan provider_code dari tabel game_lists
    $gameData =  DB::table('game_lists')->where('provider_code', $providerCode)->first();

    if (!$gameData || !$gameData->game_code) {
        return redirect()->back()->with('error', 'Game tidak ditemukan di database');
    }

    $gameCodes = $gameData->game_code;

    $asgApi = new AsgApi();
    $response = $asgApi->launchGame($user->extplayer, $gameCodes);

    if (isset($response['status']) && $response['status'] == 200 && isset($response['data']['gameUrl'])) {
        return redirect($response['data']['gameUrl']);
    } elseif (isset($response['error']) && $response['error'] == 17) {
        $create = $asgApi->create($user->extplayer);
        if (isset($create['error']) && $create['error'] == 0) {
            $user->extplayer = $create['playerId'];
            $user->save();
            return redirect()->back()->with('error', 'Player baru dibuat, silakan coba lagi');
        } else {
            $message = $create['description'] ?? 'Gagal membuat player baru';
            return view('frontend.errorplay', compact('message'));
        }
    } else {
        $message = $response['description'] ?? 'Gagal membuka game';
        return view('frontend.errorplay', compact('message'));
    }
}


public function getBalance2(Request $request)
{
    $api = new AsgApi();
    $user = auth()->user();
    $extplayer = $user->extplayer;

    $response = $api->infoMember($extplayer);
    $user->balance = $response['data']['balance'];
    $user->save();
    // $response sudah array, langsung cek isinya
    if (isset($response['status']) && $response['status'] == 200 && isset($response['data']['balance'])) {
        return response()->json([
            'success' => true,
            'balance' => $response['data']['balance'],
        ]);
    } else {
        return response()->json([
            'success' => false,
            'message' => $response['message'] ?? 'Failed to retrieve balance'
        ]);
    }
}




}