<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Transaction;
use App\Models\User;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\Api\AsgApi;
use PhpParser\Node\Expr\New_;
use App\Events\DepositCreated;

class TransactionController extends Controller
{
    public function transaction()
    {
        $bank = DB::table('tb_bank')->where('level', 'admin')->get();
        $bu = DB::table('tb_bank')->where('id_user', auth()->user()->id)->first();
        $bonus = DB::table('tb_bonus')->where('status', 'active')->where('type', 2)->get();

        $hdepo = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Top Up')->orderBy('id', 'desc')->limit(7)->get();
        $hwd = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Withdraw')->orderBy('id', 'desc')->limit(7)->get();

        $last = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Top Up')->where('status', 'Pending')->first();

        return view('frontend.transaction.transaction', compact('bank', 'bu', 'bonus', 'hdepo', 'hwd', 'last'));
    }


    public function withdraws()
    {
        $bank = DB::table('tb_bank')->where('level', 'admin')->get();
        $bu = DB::table('tb_bank')->where('id_user', auth()->user()->id)->first();
        $bonus = DB::table('tb_bonus')->where('status', 'active')->where('type', 2)->get();

        $hdepo = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Top Up')->orderBy('id', 'desc')->limit(7)->get();
        $hwd = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Withdraw')->orderBy('id', 'desc')->limit(7)->get();

        return view('frontend.transaction.withdraw', compact('bank', 'bu', 'bonus', 'hdepo', 'hwd'));
    }

    public function history()
    {
        $bank = DB::table('tb_bank')->where('level', 'admin')->get();
        $bu = DB::table('tb_bank')->where('id_user', auth()->user()->id)->first();
        $bonus = DB::table('tb_bonus')->where('status', 'active')->where('type', 2)->get();

        $hdepo = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Top Up')->orderBy('id', 'desc')->limit(7)->get();
        $hwd = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Withdraw')->orderBy('id', 'desc')->limit(7)->get();

        return view('frontend.transaction.history', compact('bank', 'bu', 'bonus', 'hdepo', 'hwd'));
    }

    public function transaction_history()
    {
        $history = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->orderBy('id', 'desc')->get();
        return view('frontend.transaction.history2', compact('history'));
    }

    public function account()
    {
        $bu = DB::table('tb_bank')->where('id_user', auth()->user()->id)->first();
        return view('frontend.transaction.bank', compact('bu'));
    }


    public function setAccount(Request $request)
    {
        $check = User::where('nama_bank', $request->BankName)->where('nomor_rekening', $request->AccountNo)->first();
        if (!empty($check)) {
            return redirect()->back()->with('error', 'Nomor rekening telah terdaftar di akun lain.');
        } else {
            $user = User::find(auth()->user()->id);
            $user->nama_lengkap = $request->AccountName;
            $user->nama_bank = $request->BankName;
            $user->nomor_rekening = $request->AccountNo;
            $user->nama_pemilik = $request->AccountName;
            $user->save();
            return redirect()->back()->with('success', 'Berhasil!');
        }
    }

    public function posttrx(Request $request)
    {
        if ($request->bonus != 'tanpabonus') {
            $check_bonus = DB::table('bonus_active')->where('user_id', auth()->user()->id)->where('status', 0)->first();
            if (!empty($check_bonus)) {
                return redirect()->back()->with('error', 'Anda masih memiliki bonus active');
            }
        }

        $amount = str_replace(",", "", $request->RealAmount);

        $check = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Top Up')->where('status', 'Pending')->first();
        if (!empty($check)) {
            return redirect()->back()->with('error', 'Anda memiliki transaksi pending sebelumnya, harap di selesaikan telebih dahulu.');
        } elseif ($amount < general()->min_depo) {
            return redirect()->back()->with('error', 'Minimal deposit sebesar : Rp. ' . number_format(general()->min_depo, 2));
        } else {
            $metode = DB::table('tb_bank')->where('id', $request->TransferTo)->first();
            $trans = new Transaction();

            if ($request->hasFile('gambar')) {
                $url = $request->file('gambar')->storePublicly(
                    'ImageFile',
                    's3'
                );
                $trans->gambar = config('filesystems.disks.s3.url') . $url;
            }

            $bonus = DB::table('tb_bonus')->where('id', $request->bonus)->first();

            if ($request->bonus != 'tanpabonus') {
                $bonust = $amount * $bonus->bonus / 100;

                if ($bonust > $bonus->max) {
                    $bonus_amount = $bonus->max;
                } else {
                    $bonus_amount = $bonust;
                }
            }

            $trans->trx_id = getTrx();
            $trans->transaksi = 'Top Up';
            $trans->total = $amount;
            $trans->dari_bank = $request->dari_bank;
            $trans->metode = $metode->nama_bank;
            $trans->bonus = $request->bonus;
            if ($request->bonus == 'tanpabonus') {
                $trans->bonus_amount = 0;
            } elseif ($request->bonus != 'tanpabonus') {
                $trans->bonus_amount = $bonus_amount;
            }

            $trans->keterangan = $request->Note;
            $trans->status = 'Pending';
            $trans->id_user = auth()->user()->id;
            $trans->username = auth()->user()->username;
            $trans->save();

            $user = User::find(auth()->user()->id);
            $user->deposit = 1;
            $user->save();

            $pusher = [
                'trans_id' => $trans->id,
                'username' => $user->username,
                'type' => 'Deposit',
                'amount' => number_format($amount, 2)
            ];

            if ($request->bonus != 'tanpabonus') {
                DB::table('bonus_active')->insert([
                    'user_id' => auth()->user()->id,
                    'username' => auth()->user()->username,
                    'trx_id' => $trans->id,
                    'bonus_id' => $bonus->id,
                    'bonus_title' => $bonus->judul,
                    'bonus_amount' => $bonus_amount,
                    'turn_over' => $amount + $bonus_amount * $bonus->turnover,
                    'status' => 0,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s')
                ]);
            }

            event(new DepositCreated($pusher));

            return redirect()->back()->with('success', 'Permintaan deposit anda telah berhasil dikirim.');
        }
    }

    public function qrisCallback(Request $request)
{
    // Validasi input
    $request->validate([
        'terminal_id' => 'required|string',
        'trx_id'      => 'required|string',
        'amount'      => 'required|numeric',
        'status'      => 'required|string',
        'created_at'  => 'required|string'
    ]);

    $username   = $request->terminal_id;
    $trxid      = $request->trx_id;
    $amount     = (int) $request->amount;
    $status     = $request->status;
    $created_at = now();

    // Cek user
    $user = User::where('username', $username)->first();
    if (!$user) {
        return response()->json(['success' => false, 'message' => 'User not found'], 404);
    }

    $kd_transaksi = 'QRIS' . $trxid;
    $note         = 'Topup QRIS Otomatis';

    // Proses hanya jika status sukses
    if ($status === 'success') {
        DB::beginTransaction();
        try {
            // Buat transaksi
            $trans = new Transaction();
            $trans->trx_id       = $kd_transaksi;
            $trans->transaksi    = 'Top Up';
            $trans->total        = $amount;
            $trans->dari_bank    = 'QRIS';
            $trans->metode       = 'QRIS';
            $trans->bonus        = 'tanpabonus';
            $trans->bonus_amount = 0;
            $trans->keterangan   = $note;
            $trans->status       = 'Sukses'; 
            $trans->id_user      = $user->id;
            $trans->username     = $user->username;
            $trans->created_at   = $created_at;
            $trans->updated_at   = $created_at;
            $trans->save();

            $asgApi = new AsgApi();
            $response = $asgApi->depositMember($user->extplayer, $amount);

            if ($response['success'] ?? false) {
                $trans->status = 'Success';
                $trans->save();

                $user->balance += $amount;
                $user->save();
            } else {
                $trans->keterangan .= ' | Deposit ASG gagal: ' . ($response['message'] ?? 'Unknown error');
                $trans->save();
            }

            DB::commit();
            return response()->json(['success' => true, 'message' => 'Processed by system']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    } else {
        return response()->json(['success' => false, 'message' => 'Invalid payment status']);
    }
}


    
    public function withdraw(Request $request)
    {

        $amount = str_replace(",", "", $request->RealAmount);

        $check_bonus = DB::table('bonus_active')->where('user_id', auth()->user()->id)->where('status', 0)->first();
        if (!empty($check_bonus)) {
            if (auth()->user()->balance < $check_bonus->turn_over) {
                return redirect()->back()->with('error', 'Anda memiliki bonus active, harap selesaikan TO telebih dahulu.');
            } else {
                DB::table('bonus_active')->where('id', $check_bonus->id)->update([
                    'status' => 1,
                    'updated_at' => date('Y-m-d H:i:s')
                ]);
            }
        }

        $check = DB::table('tb_transaksi')->where('id_user', auth()->user()->id)->where('transaksi', 'Withdraw')->where('status', 'Pending')->first();
        if (!empty($check)) {
            return redirect()->back()->with('error', 'Anda memiliki transaksi pending sebelumnya, harap di selesaikan telebih dahulu.');
        } elseif ($amount < general()->min_wd) {
            return redirect()->back()->with('error', 'Minimal withdraw sebesar : Rp. ' . number_format(general()->min_wd, 2));
        } elseif ($amount > auth()->user()->balance) {
            return redirect()->back()->with('error', 'Saldo Anda Tidak Mencukupi.');
        } else {

            $trans = new Transaction();
            $trans->trx_id = getTrx();
            $trans->transaksi = 'Withdraw';
            $trans->total = $amount;
            $trans->dari_bank = $request->bank;
            $trans->keterangan = $request->keterangan;
            $trans->status = 'Pending';
            $trans->id_user = auth()->user()->id;
            $trans->username = auth()->user()->username;
            $trans->save();

            $pusher = [
                'trans_id' => $trans->id,
                'username' => auth()->user()->username,
                'type' => 'Withdraw',
                'amount' => number_format($amount, 2)
            ];

            event(new DepositCreated($pusher));

            $end = new AsgApi();
            $end->withdrawMember(auth()->user()->extplayer, $amount);

            $user = User::find(auth()->user()->id);
            $user->balance = $user->balance - $amount;
            $user->save();

            return redirect()->back()->with('success', 'Permintaan withdraw anda telah berhasil dikirim.');
        }
    }
}
