<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

use App\Models\User;

class UserController extends Controller
{
    public function profile()
    {
        $bank = DB::table('tb_bank')->where('id_user', auth()->user()->id)->where('level' ,'user')->first();
        $reff = DB::table('tb_refferal')->where('user_id', auth()->user()->id)->first();
        return view('frontend.profile',compact('reff','bank'));
    }

    public function password()
    {
        $bank = DB::table('tb_bank')->where('id_user', auth()->user()->id)->where('level' ,'user')->first();
        $reff = DB::table('tb_refferal')->where('user_id', auth()->user()->id)->first();
        return view('frontend.password',compact('reff','bank'));
    }

    public function update(Request $request)
    {
        if(Hash::check($request->oldpassword,auth()->user()->password)) {
            $user = User::find(auth()->user()->id);
            $user->password = Hash::make($request->newpassword);
            $user->save();
            return response()->json([
                'success' => true,
                'code' => 200,
                'data' => [
                    'message' => 'Kata sandi berhasil diubah'
                ]
            ]);
        } else {
            return response()->json([
                'success' => false,
                'code' => 12145,
                'data' => [
                    'message' => 'Kata sandi lama salah'
                ]
            ]);
        }
    }
}
