<?php

namespace App\Http\Controllers\Game;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Result;
use App\Models\Pasaran;
use App\Models\Taruhan;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Http\Controllers\Api\AsgApi;

class TogelController extends Controller
{
    public function index()
    {
        $live = Result::where('type',1)->get();
        $data = Result::where('type',2)->get();
        return view('gameloby.index',compact('live','data'));
    }

    public function invoice()
    {
        $transaksi = Taruhan::where('user_id',auth()->user()->id)->get();
        return view('gameloby.invoice',compact('transaksi'));
    }

    public function mimpi()
    {
        return view('gameloby.mimpi');
    }

    public function howto()
    {
        return view('gameloby.howto');
    }

    public function result($slug)
    {
        $slugs = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$slugs->title)->orderBy('created_at', 'desc')->get();
        return view('gameloby.result',compact('data','slugs'));
    }

    public function games($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.index',compact('data','slug','result'));
    }

    public function play($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.digit',compact('data','slug','result'));
    }

    public function twod($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.2d',compact('data','slug','result'));
    }

    public function trod($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.3d',compact('data','slug','result'));
    }

    public function bbfs($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.bbfs',compact('data','slug','result'));
    }
    public function shio($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.shio',compact('data','slug','result'));
    }
    public function dasar($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.dasar',compact('data','slug','result'));
    }
    public function monostereo($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.mono-stereo',compact('data','slug','result'));
    }
    public function tepitengah($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.tepi-tengah',compact('data','slug','result'));
    }
    public function kembangkempis($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.kembang-kempis',compact('data','slug','result'));
    }
    public function limapuluh($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.50-50',compact('data','slug','result'));
    }
    public function kombinasi($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.kombinasi',compact('data','slug','result'));
    }
    public function playerbanker($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.player-banker',compact('data','slug','result'));
    }
    public function tarung($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.tarung',compact('data','slug','result'));
    }

    public function k2d($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.quick',compact('data','slug','result'));
    }

    public function ds($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.dset',compact('data','slug','result'));
    }

    public function cbs($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.bebas',compact('data','slug','result'));
    }

    public function cmc($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.macau',compact('data','slug','result'));
    }

    public function cng($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.naga',compact('data','slug','result'));
    }

    public function cjt($slug)
    {
        $result = Result::where('slug',$slug)->first();
        $data = Pasaran::where('title',$result->title)->orderBy('created_at','desc')->get();
        return view('gameloby.games.jitu',compact('data','slug','result'));
    }

   public function taruhan(Request $request)
{
    $user = auth()->user();
    $balance = $user->balance;

    // =====================
    // Taruhan Colok Bebas (1 digit)
    // =====================
    if($request->type === 'Colok Bebas'){
        $angka = $request->bet; // angka 0-9
        $amount = (float) $request->betAmount;

        if($amount > $balance){
            return response()->json([
                'status' => 40,
                'title' => 'error',
                'message' => 'Saldo Anda Tidak Mencukupi'
            ]);
        }

        // jika frontend mengirim array per baris, pakai loop
        $angkaList = is_array($angka) ? $angka : [$angka];
        $amountwin = $amount*10;
        foreach($angkaList as $combo){
            $taruhan = new Taruhan();
            $taruhan->tid = strtoupper(Str::random(7));
            $taruhan->user_id = $user->id;
            $taruhan->username = $user->username;
            $taruhan->market = $request->market;
            $taruhan->amount = $amount;
            $taruhan->amount_bet = $amount;
            $taruhan->pasang = $combo; // pasang = 1 digit
            $taruhan->date = date('d-m-Y');
            $taruhan->win = $amountwin; 
            $taruhan->type = $request->type;
            $taruhan->jenis_taruhan = 'Colok Bebas';
            $taruhan->discount_option = '0%';
            $taruhan->status = 1;
            $taruhan->save();

            $end = new AsgApi();
            $end->withdrawMember($user->extplayer, $amount);
        }

        return response()->json([
            'status' => 200,
            'title' => 'success',
            'message' => 'Taruhan Colok Bebas berhasil disimpan'
        ]);
    }
    // =====================
// Taruhan Colok Macau (2 digit unik)
// =====================
if($request->type === 'Colok Macau'){
    $angka = $request->bet; // bisa array atau satu string
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // jika frontend mengirim array per row, pakai loop
    $angkaList = is_array($angka) ? $angka : [$angka];

    foreach($angkaList as $combo){
        // validasi 2 digit unik
        if(strlen($combo) != 2 || $combo[0] === $combo[1]){
            return response()->json([
                'status' => 41,
                'title' => 'error',
                'message' => "Angka $combo harus 2 digit dan tidak boleh sama"
            ]);
        }
        $amountwin = $amount*70;
        $taruhan = new Taruhan();
        $taruhan->tid = strtoupper(Str::random(7));
        $taruhan->user_id = $user->id;
        $taruhan->username = $user->username;
        $taruhan->market = $request->market;
        $taruhan->amount = $amount;
        $taruhan->amount_bet = $amount;
        $taruhan->pasang = $combo; // simpan 2 digit
        $taruhan->date = date('d-m-Y');
        $taruhan->win = $amountwin; 
        $taruhan->type = $request->type;
        $taruhan->jenis_taruhan = 'Colok Macau';
        $taruhan->discount_option = '0%';
        $taruhan->status = 1;
        $taruhan->save();

        $end = new AsgApi();
        $end->withdrawMember($user->extplayer, $amount);
    }

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Colok Macau berhasil disimpan'
    ]);
}
// =====================
// Taruhan Colok Macau (2 digit unik)
// =====================
if($request->type === 'Colok Naga'){
    $angka = $request->bet; // bisa array atau satu string
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // jika frontend mengirim array per row, pakai loop
    $angkaList = is_array($angka) ? $angka : [$angka];

    foreach($angkaList as $combo){
        // validasi 2 digit unik
        if(strlen($combo) != 3 || $combo[0] === $combo[1]){
            return response()->json([
                'status' => 41,
                'title' => 'error',
                'message' => "Angka $combo harus 3 digit dan tidak boleh sama"
            ]);
        }
        $amountwin = $amount*400;
        $taruhan = new Taruhan();
        $taruhan->tid = strtoupper(Str::random(7));
        $taruhan->user_id = $user->id;
        $taruhan->username = $user->username;
        $taruhan->market = $request->market;
        $taruhan->amount = $amount;
        $taruhan->amount_bet = $amount;
        $taruhan->pasang = $combo; // simpan 3 digit
        $taruhan->date = date('d-m-Y');
        $taruhan->win = $amountwin; 
        $taruhan->type = $request->type;
        $taruhan->jenis_taruhan = 'Colok Naga';
        $taruhan->discount_option = '0%';
        $taruhan->status = 1;
        $taruhan->save();

        $end = new AsgApi();
        $end->withdrawMember($user->extplayer, $amount);
    }

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Colok Macau berhasil disimpan'
    ]);
}
// =====================
// Taruhan Colok Jitu (1 digit)
// =====================
if($request->type === 'Colok Jitu') {
    $user = auth()->user();
    $balance = $user->balance;

    $angka = $request->bet; // 1 digit
    $posisi = $request->posisi; // As, Kop, Kepala, Ekor
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // Hitung win → 1 digit biasanya kelipatan 10
    $win = $amount * 10;

    $taruhan = new Taruhan();
    $taruhan->tid = strtoupper(Str::random(7));
    $taruhan->user_id = $user->id;
    $taruhan->username = $user->username;
    $taruhan->market = $request->market;
    $taruhan->amount = $amount;
    $taruhan->amount_bet = $amount;
    $taruhan->pasang = $angka;
    $taruhan->posisi = $posisi; // simpan posisi
    $taruhan->date = date('d-m-Y');
    $taruhan->win = $win;
    $taruhan->type = $request->type;
    $taruhan->jenis_taruhan = 'Colok Jitu';
    $taruhan->discount_option = '0%';
    $taruhan->status = 1;
    $taruhan->save();

    $end = new AsgApi();
    $end->withdrawMember($user->extplayer, $amount);

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Colok Jitu berhasil disimpan'
    ]);
}
// =====================
// Taruhan Player Banker
// =====================
if($request->type === 'Player Banker') {
    $user = auth()->user();
    $balance = $user->balance;

    $angka = $request->bet; 
    $posisi = $request->posisi ?? null; 
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // Hitung win → 1 digit biasanya kelipatan 10
    $win = $amount * 10;

    $taruhan = new Taruhan();
    $taruhan->tid = strtoupper(Str::random(7));
    $taruhan->user_id = $user->id;
    $taruhan->username = $user->username;
    $taruhan->market = $request->market;
    $taruhan->amount = $amount;
    $taruhan->amount_bet = $amount;
    $taruhan->pasang = $angka;
    $taruhan->posisi = $posisi; // simpan posisi
    $taruhan->date = date('d-m-Y');
    $taruhan->win = $win;
    $taruhan->type = $request->type;
    $taruhan->jenis_taruhan = $angka;
    $taruhan->discount_option = '0%';
    $taruhan->status = 1;
    $taruhan->save();

    $end = new AsgApi();
    $end->withdrawMember($user->extplayer, $amount);

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Colok Jitu berhasil disimpan'
    ]);
}
// =====================
// Taruhan Shio
// =====================
if($request->type === 'Shio') {
    $user = auth()->user();
    $balance = $user->balance;
    $shio = $request->bet; // nama shio, misal 'Ayam'
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // Daftar angka tiap shio
    $shioNumbers = [
        'Tikus' => [1,13,25,37,49],
        'Sapi' => [2,14,26,38,50],
        'Harimau' => [3,15,27,39,51],
        'Kelinci' => [4,16,28,40,52],
        'Naga' => [5,17,29,41,53],
        'Ular' => [6,18,30,42,54],
        'Kuda' => [7,19,31,43,55],
        'Kambing' => [8,20,32,44,56],
        'Monyet' => [9,21,33,45,57],
        'Ayam' => [10,22,34,46,58],
        'Anjing' => [11,23,35,47,59],
        'Babi' => [12,24,36,48,60],
    ];

    // Ambil semua angka shio yang dipilih
    $angkaList = $shioNumbers[$shio] ?? [];

    $totalTaruhan = count($angkaList) * $amount;
    if($totalTaruhan > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi untuk semua angka shio'
        ]);
    }

    foreach($angkaList as $angka){
        $taruhan = new Taruhan();
        $taruhan->tid = strtoupper(Str::random(7));
        $taruhan->user_id = $user->id;
        $taruhan->username = $user->username;
        $taruhan->market = $request->market;
        $taruhan->amount = $amount;
        $taruhan->amount_bet = $amount;
        $taruhan->pasang = $angka; // angka dari shio
        $taruhan->posisi = $request->posisi ?? null; // posisi user pilih
        $taruhan->date = date('d-m-Y');
        $taruhan->win = $amount * 70; // perkalian Shio 2D
        $taruhan->type = $request->type;
        $taruhan->jenis_taruhan = $shio;
        $taruhan->discount_option = '0%';
        $taruhan->status = 1;
        $taruhan->save();

        // Tarik saldo user
        $end = new AsgApi();
        $end->withdrawMember($user->extplayer, $amount);
    }

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Shio berhasil disimpan'
    ]);
}
// =====================
// Taruhan Dasar (Besar/Kecil/Ganjil/Genap)
// =====================
if($request->type === 'Dasar'){
    $user = auth()->user();
    $balance = $user->balance;
    $betType = $request->bet; // Besar, Kecil, Ganjil, Genap
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // Hitung kemenangan: misal ada kei 25% untuk Besar dan Ganjil
    $winMultiplier = in_array($betType, ['Besar','Ganjil']) ? 1.25 : 1;

    $taruhan = new Taruhan();
    $taruhan->tid = strtoupper(Str::random(7));
    $taruhan->user_id = $user->id;
    $taruhan->username = $user->username;
    $taruhan->market = $request->market;
    $taruhan->amount = $amount;
    $taruhan->amount_bet = $amount;
    $taruhan->pasang = $betType;
    $taruhan->date = date('d-m-Y');
    $taruhan->win = $amount * $winMultiplier; // otomatis kalkulasi win
    $taruhan->type = $request->type;
    $taruhan->jenis_taruhan = 'Dasar';
    $taruhan->discount_option = '0%';
    $taruhan->status = 1;
    $taruhan->save();

    $end = new AsgApi();
    $end->withdrawMember($user->extplayer, $amount);

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Dasar berhasil disimpan'
    ]);
}
// =====================
// Taruhan Tepi/Tengah
// =====================
if($request->type === 'Tepi Tengah'){
    $user = auth()->user();
    $balance = $user->balance;
    $betType = $request->bet; // Tepi atau Tengah
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // Tambahkan 2% kei
    $win = $amount * 1.02;

    $taruhan = new Taruhan();
    $taruhan->tid = strtoupper(Str::random(7));
    $taruhan->user_id = $user->id;
    $taruhan->username = $user->username;
    $taruhan->market = $request->market;
    $taruhan->amount = $amount;
    $taruhan->amount_bet = $amount;
    $taruhan->pasang = $betType;
    $taruhan->date = date('d-m-Y');
    $taruhan->win = $win;
    $taruhan->type = $request->type;
    $taruhan->jenis_taruhan = 'Tepi Tengah';
    $taruhan->discount_option = '0%';
    $taruhan->status = 1;
    $taruhan->save();

    $end = new AsgApi();
    $end->withdrawMember($user->extplayer, $amount);

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Tepi/Tengah berhasil disimpan'
    ]);
}
if($request->type === 'Mono Stereo'){
    $user = auth()->user();
    $balance = $user->balance;

    $betTypeList = is_array($request->bet) ? $request->bet : [$request->bet];         // Mono / Stereo bisa array
    $positionList = is_array($request->posisi) ? $request->posisi : [$request->posisi]; // Depan / Tengah / Belakang
    $amount = (float) $request->betAmount;

    $totalTaruhan = count($betTypeList) * $amount;
    if($totalTaruhan > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi untuk semua taruhan Mono/Stereo'
        ]);
    }

    foreach($betTypeList as $index => $betType){
        $position = $positionList[$index] ?? $positionList[0]; // jika jumlah posisi lebih sedikit, gunakan yang pertama

        // Tambahkan 3% kei
        $win = $amount * 1.03;

        $taruhan = new Taruhan();
        $taruhan->tid = strtoupper(Str::random(7));
        $taruhan->user_id = $user->id;
        $taruhan->username = $user->username;
        $taruhan->market = $request->market;
        $taruhan->amount = $amount;
        $taruhan->amount_bet = $amount;
        $taruhan->pasang = $betType;   // Mono / Stereo
        $taruhan->posisi = $position;  // Depan / Tengah / Belakang
        $taruhan->date = date('d-m-Y');
        $taruhan->win = $win;
        $taruhan->type = $request->type;
        $taruhan->jenis_taruhan = $position;
        $taruhan->discount_option = '0%';
        $taruhan->status = 1;
        $taruhan->save();

        // Tarik saldo user
        $end = new AsgApi();
        $end->withdrawMember($user->extplayer, $amount);
    }

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Mono Stereo berhasil disimpan'
    ]);
}
// =====================
// Taruhan Kembang Kempis
// =====================
if($request->type === 'Kembang Kempis') {
    $user = auth()->user();
    $balance = $user->balance;

    $betTypeList = is_array($request->bet) ? $request->bet : [$request->bet];          // Kembang / Kempis / Kembar
    $positionList = is_array($request->position) ? $request->position : [$request->position]; // Depan / Tengah / Belakang
    $amount = (float) $request->betAmount;

    // Kei per type (persentase)
    $keiMap = [
        'Kembang' => 0,
        'Kempis' => 0,
        'Kembar' => 43,
    ];

    // Hitung total taruhan
    $totalTaruhan = 0;
    foreach($betTypeList as $index => $betType) {
        $keiPercent = $keiMap[$betType] ?? 0;
        $totalTaruhan += $amount + ($amount * $keiPercent / 100);
    }

    if($totalTaruhan > $balance) {
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi untuk semua taruhan Kembang Kempis'
        ]);
    }

    // Simpan tiap taruhan
    foreach($betTypeList as $index => $betType) {
        $position = $positionList[$index] ?? $positionList[0];
        $keiPercent = $keiMap[$betType] ?? 0;
        $kei = $amount * $keiPercent / 100;
        $bayar = $amount + $kei;

        $taruhan = new Taruhan();
        $taruhan->tid = strtoupper(Str::random(7));
        $taruhan->user_id = $user->id;
        $taruhan->username = $user->username;
        $taruhan->market = $request->market ?? 'Kembang Kempis';
        $taruhan->amount = $bayar;       // termasuk kei
        $taruhan->amount_bet = $amount;  // nominal asli
        $taruhan->pasang = $betType;     // Kembang/Kempis/Kembar
        $taruhan->posisi = $position;    // Depan/Tengah/Belakang
        $taruhan->date = date('d-m-Y');
        $taruhan->win = $bayar;          // misal multiplier = 1
        $taruhan->type = 'Kembang Kempis';
        $taruhan->jenis_taruhan = $betType;
        $taruhan->discount_option = '0%';
        $taruhan->status = 1;
        $taruhan->save();

        // Tarik saldo user
        $end = new AsgApi();
        $end->withdrawMember($user->extplayer, $bayar);
    }

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan Kembang Kempis berhasil disimpan'
    ]);
}

if($request->type === 'Kombinasi') {
    $user = auth()->user();
    $balance = $user->balance;

    // Ambil semua input row
    $rows = [];
    if($request->has('bet1') && $request->has('bet2') && $request->has('betAmount')){
        // Jika data dikirim sebagai array
        if(is_array($request->bet1)){
            foreach($request->bet1 as $index => $b1){
                $rows[] = [
                    'bet1' => $b1,
                    'bet2' => $request->bet2[$index] ?? null,
                    'betAmount' => floatval($request->betAmount[$index] ?? 0),
                ];
            }
        } else {
            // single row
            $rows[] = [
                'bet1' => $request->bet1,
                'bet2' => $request->bet2,
                'betAmount' => floatval($request->betAmount),
            ];
        }
    }

    if(empty($rows)){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Tidak ada taruhan yang dimasukkan'
        ]);
    }

    // Hitung total semua taruhan
    $totalTaruhan = 0;
    foreach($rows as $row){
        $totalTaruhan += $row['betAmount'];
    }

    if($totalTaruhan > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda tidak cukup untuk semua taruhan Kombinasi'
        ]);
    }

    try {
        DB::transaction(function() use($rows, $user) {
            $api = new AsgApi();
            foreach($rows as $row){
                $taruhan = new Taruhan();
                $taruhan->tid = strtoupper(Str::random(7));
                $taruhan->user_id = $user->id;
                $taruhan->username = $user->username;
                $taruhan->market = $row['bet1'].' & '.$row['bet2'];
                $taruhan->amount = $row['betAmount'];
                $taruhan->amount_bet = $row['betAmount'];
                $taruhan->pasang = $row['bet1'];
                $taruhan->posisi = $row['bet2'];
                $taruhan->date = date('d-m-Y');
                $taruhan->win = $row['betAmount']; // multiplier 1
                $taruhan->type = 'Kombinasi';
                $taruhan->jenis_taruhan = $row['bet1'].'-'.$row['bet2'];
                $taruhan->discount_option = '0%';
                $taruhan->status = 1;
                $taruhan->save();

                // Tarik saldo user
                $res = $api->withdrawMember($user->extplayer, $row['betAmount']);
                if(!$res){
                    throw new \Exception("Withdraw gagal untuk ".$row['bet1']." & ".$row['bet2']);
                }
            }
        });

        return response()->json([
            'status' => 200,
            'title' => 'success',
            'message' => 'Taruhan Kombinasi berhasil disimpan'
        ]);

    } catch(\Exception $e){
        return response()->json([
            'status' => 50,
            'title' => 'error',
            'message' => 'Terjadi kesalahan: '.$e->getMessage()
        ]);
    }
}

if($request->type==='50 50'){
    $user=auth()->user();
    $balance=$user->balance;
    $bets=$request->bets ?? [];
    $keiPercent=3;

    if(empty($bets)){
        return response()->json(['status'=>40,'title'=>'error','message'=>'Silahkan masukkan taruhan']);
    }

    $totalTaruhan=0;
    foreach($bets as $bet){
        $totalTaruhan += $bet['betAmount'] + ($bet['betAmount']*$keiPercent/100);
    }

    if($totalTaruhan > $balance){
        return response()->json(['status'=>40,'title'=>'error','message'=>'Saldo Anda Tidak Mencukupi']);
    }

    try{
        DB::transaction(function() use($bets,$user,$keiPercent){
            $end=new AsgApi();
            foreach($bets as $bet){
                $amount=$bet['betAmount'];
                $kei=$amount*$keiPercent/100;
                $bayar=$amount+$kei;

                $taruhan=new Taruhan();
                $taruhan->tid=strtoupper(Str::random(7));
                $taruhan->user_id=$user->id;
                $taruhan->username=$user->username;
                $taruhan->market=$bet['market'] ?? '50 50';
                $taruhan->amount=$bayar;
                $taruhan->amount_bet=$amount;
                $taruhan->pasang=$bet['bet'];
                $taruhan->posisi=$bet['position'];
                $taruhan->date=date('d-m-Y');
                $taruhan->win=$bayar;
                $taruhan->type='50 50';
                $taruhan->jenis_taruhan=$bet['bet'];
                $taruhan->discount_option='0%';
                $taruhan->status=1;
                $taruhan->save();

                $res=$end->withdrawMember($user->extplayer,$bayar);
                if(!$res) throw new \Exception("Withdraw gagal {$bet['bet']} - {$bet['position']}");
            }
        });
        return response()->json(['status'=>200,'title'=>'success','message'=>'Taruhan 50 50 berhasil disimpan']);
    } catch(\Exception $e){
        return response()->json(['status'=>50,'title'=>'error','message'=>'Terjadi kesalahan: '.$e->getMessage()]);
    }
}

    // =====================
// Taruhan BBFS
// =====================
if($request->type === 'Bbfs'){
    $angka = $request->bet;
    $amount = (float) $request->betAmount;

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    // Hitung win berdasarkan panjang digit
    $length = strlen($angka);
    if($length === 4){
        $win = $amount * 3000;
    } elseif($length === 3){
        $win = $amount * 400;
    } elseif($length === 2){
        $win = $amount * 70;
    } else {
        $win = 0; // fallback jika tidak sesuai
    }

    $taruhan = new Taruhan();
    $taruhan->tid = strtoupper(Str::random(7));
    $taruhan->user_id = $user->id;
    $taruhan->username = $user->username;
    $taruhan->market = $request->market;
    $taruhan->amount = $amount;
    $taruhan->amount_bet = $amount;
    $taruhan->pasang = $angka;
    $taruhan->date = date('d-m-Y');
    $taruhan->win = $win;
    $taruhan->type = $request->type;
    $taruhan->jenis_taruhan = 'Bbfs';
    $taruhan->discount_option = '0%';
    $taruhan->status = 1;
    $taruhan->save();

    $end = new AsgApi();
    $end->withdrawMember($user->extplayer, $amount);

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan BBFS berhasil disimpan'
    ]);
}


    // =====================
    // Taruhan Quick 2D
    // =====================
    if($request->type === 'Quick 2D'){
        $angka = $request->pasang; 
        $amount = (float) $request->betAmount;

        if($amount > $balance){
            return response()->json([
                'status' => 40,
                'title' => 'error',
                'message' => 'Saldo Anda Tidak Mencukupi'
            ]);
        }

        $angkaList = is_array($angka) ? $angka : [$angka];
        $amountwin =$amount*70;

        foreach($angkaList as $combo){
            $taruhan = new Taruhan();
            $taruhan->tid = strtoupper(Str::random(7));
            $taruhan->user_id = $user->id;
            $taruhan->username = $user->username;
            $taruhan->market = $request->market;
            $taruhan->amount = $amount;
            $taruhan->amount_bet = $amount;
            $taruhan->pasang = $combo;
            $taruhan->date = date('d-m-Y');
            $taruhan->win = $amountwin;
            $taruhan->type = $request->type;
            $taruhan->jenis_taruhan = 'Quick 2D';
            $taruhan->discount_option = '0%';
            $taruhan->status = 1;
            $taruhan->save();

            $end = new AsgApi();
            $end->withdrawMember($user->extplayer, $amount);
        }

        return response()->json([
            'status' => 200,
            'title' => 'success',
            'message' => 'Taruhan Quick 2D berhasil disimpan'
        ]);
    }
    if($request->type === 'Angka Tarung'){
    $bet = $request->bet;
    $amount = max($bet['4d'], $bet['3d'], $bet['2d_depan'], $bet['2d_tengah'], $bet['2d_belakang']);

    if($amount > $balance){
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    $taruhan = new Taruhan();
    $taruhan->tid = strtoupper(Str::random(7));
    $taruhan->user_id = $user->id;
    $taruhan->username = $user->username;
    $taruhan->market = $request->market;
    $taruhan->amount = $amount;
    $taruhan->amount_bet = $amount;
    $taruhan->pasang = $bet['nomor'];
    $taruhan->date = date('d-m-Y');
    $taruhan->win = $amount * 70; // contoh perhitungan win
    $taruhan->type = $request->type;
    $taruhan->jenis_taruhan = 'Angka Tarung';
    $taruhan->discount_option = '0%';
    $taruhan->status = 1;
    $taruhan->save();

    // Withdraw saldo user
    $end = new AsgApi();
    $end->withdrawMember($user->extplayer, $amount);

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan berhasil disimpan'
    ]);
}

    // =====================
    // Taruhan biasa (4D/3D/2D)
    // =====================
    $angka = $request->pasang;
    $d4 = (int) $request->d4;
    $d3 = (int) $request->d3;
    $d2 = (int) $request->d2;

    $totalBayar = $d4 + $d3 + $d2;
    if ($totalBayar > $balance) {
        return response()->json([
            'status' => 40,
            'title' => 'error',
            'message' => 'Saldo Anda Tidak Mencukupi'
        ]);
    }

    $betsSplit = [];
    if ($d4 > 0) {
        $betsSplit[] = ['jenis' => '4D','pasang' => substr($angka, -4),'nominal' => $d4,'disc'=>66,'kelipatan'=>3000];
    }
    if ($d3 > 0) {
        $betsSplit[] = ['jenis' => '3D','pasang' => substr($angka, -3),'nominal' => $d3,'disc'=>59,'kelipatan'=>400];
    }
    if ($d2 > 0) {
        $betsSplit[] = ['jenis' => '2D','pasang' => substr($angka, -2),'nominal' => $d2,'disc'=>29,'kelipatan'=>70];
    }

    foreach ($betsSplit as $split) {
        $disc = $split['nominal'] * $split['disc'] / 100;
        $amount = $split['nominal'] - $disc;
        $win = $split['nominal'] * $split['kelipatan'];

        $jenisTaruhan = $split['jenis'];
        if (($split['jenis'] == '2D' || $split['jenis'] == '3D') && $request->has('posisi') && !empty($request->posisi)) {
            $jenisTaruhan = $request->posisi;
        }

        $taruhan = new Taruhan();
        $taruhan->tid = strtoupper(Str::random(7));
        $taruhan->user_id = $user->id;
        $taruhan->username = $user->username;
        $taruhan->market = $request->market;
        $taruhan->amount = $amount;
        $taruhan->amount_bet = $split['nominal'];
        $taruhan->pasang = $split['pasang'];
        $taruhan->date = date('d-m-Y');
        $taruhan->win = $win;
        $taruhan->type = $request->type;
        $taruhan->jenis_taruhan = $jenisTaruhan;
        $taruhan->discount_option = $request->discount ?? '0%';
        $taruhan->status = 1;
        $taruhan->save();

        $end = new AsgApi();
        $end->withdrawMember($user->extplayer, $amount);
    }

    return response()->json([
        'status' => 200,
        'title' => 'success',
        'message' => 'Taruhan berhasil disimpan'
    ]);
}








    public function cronsjobs()
    {
        $response = json_decode(Http::get('https://w5.shotjitu.com/tabel/home2.json'));

        foreach ($response as $data) {
            $result = new Result();
            $result->slug = Str::slug($data->pasaran);
            $result->pasaran = $data->pasaran;
            $result->hari = $data->hari;
            $result->tanggal = $data->tanggal;
            $result->keluaran = $data->keluaran;
            $result->buka = $data->buka;
            $result->save();
        }

        return response()->json([
            'success' => true,
            'message' => 'success'
        ]);
    }
}
