<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Api\AsgApi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class TestApiController extends Controller
{
    public function syncGameList()
    {
        try {
            $api = new AsgApi();
            
            $result = $api->infoGame('JA');

            if (!isset($result['status']) || $result['status'] != 200) {
                return response()->json(['error' => 'API response error'], 500);
            }

            $games = $result['data'] ?? [];

            $now = Carbon::now();

            foreach ($games as $game) {
                DB::table('game_lists')->updateOrInsert(
                     [
            'game_code' => $game['game_code'],
            'provider' => $game['game_provider'],
        ],
                    [
                        'provider' => $game['game_provider'] ?? 'PR',
                        'provider_code' => $game['game_vendor'] ?? '',
                        'game_name' => $game['game_name'] ?? '',
                        'game_code' => $game['game_code'] ?? '',
                        'game_image' => $game['game_image'] ?? '',
                        'product_id' => '0',            // default string '0' atau sesuai tipe kolom
                        'product_code' => '',           // string kosong jika tidak ada data
                        'support_currency' => '',       // string kosong jika tidak ada data
                        'game_type' => $game['game_type'] ?? '',
                        'status' => intval($game['game_status'] ?? 1),
                        'sequence' => 1,
                        'createdAt' => $now,
                        'updatedAt' => $now,
                    ]
                );
            }

            return response()->json([
                'status' => 200,
                'message' => 'Game list synced successfully',
                'total_games' => count($games),
            ]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
