@extends('backend.layouts.main')
@section('panel')
<h4 class="fw-bold py-3 mb-3">
    Deposit Pending
</h4>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-datatable table-responsive">
                <table id="default-datatable" class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Trx ID</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Username</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Amount</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Invoice</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bank Users</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bank Admin</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bonus</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Note</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Date</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Status</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($transaction as $trx)
                        <tr>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ $loop->iteration }}</td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ $trx->trx_id }}</td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ $trx->username }}</td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ number_format($trx->total, 2) }}</td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                <a href="{{ $trx->gambar }}" target="_blank" class="btn btn-info btn-sm">Invoice</a>
                            </td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                @if(auth()->guard('admin')->user()->level == 'admin')
                                {{ censor($trx->dari_bank,4) }}
                                @else
                                {{ $trx->dari_bank }}
                                @endif
                            </td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ $trx->metode }}</td>
                            <td class="text-center">
                                <button type="button" class="btn btn-xs btn-primary"
                                    onclick="getbonusDetail('{{ $trx->id }}');">
                                    <span class="mdi mdi-eye"></span>
                                </button>
                            </td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ $trx->keterangan }}</td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                {{ date('Y-m-d H:i:s', strtotime($trx->created_at)) }}</td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                @if ($trx->status == 'Pending')
                                <span class="badge bg-label-warning rounded-pill">Pending</span>
                                @elseif($trx->status == 'Ditolak')
                                <span class="badge bg-label-danger rounded-pill">Rejected</span>
                                @else
                                <span class="badge bg-label-success rounded-pill">Active</span>
                                @endif
                            </td>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                <a href="{{ route('admin.deposits.approve',$trx->id) }}" class="btn btn-success btn-sm"
                                    onclick="return confirm('Are you sure want to Confirm this Transaction?');">Approve</a>
                                <a href="{{ route('admin.deposits.reject',$trx->id) }}" class="btn btn-danger btn-sm"
                                    onclick="return confirm('Are you sure want to Reject this Transaction?');">Reject</a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Bonus Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table-sm">
                    <thead class="table-dark">
                        <tr>
                            <th class="text-center">Percentage</th>
                            <th class="text-center">Amount</th>
                            <th class="text-center">Max</th>
                            <th class="text-center">Turn Over</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-center" id="percent"></td>
                            <td class="text-center" id="amount"></td>
                            <td class="text-center" id="max"></td>
                            <td class="text-center" id="to"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    function getbonusDetail(id) {
            $.ajax({
            type: "GET",
            url: "/deposits/bonus-detail/"+ id,
            success: function (response) {
                if (response.status == 'success') {
                    $('#staticBackdrop').modal('show');
                    document.getElementById('percent').textContent = response.percentage;
                    document.getElementById('amount').textContent = response.amount;
                    document.getElementById('max').textContent = response.max;
                    document.getElementById('to').textContent = response.turn_over;
                }
            }
        });
        }
</script>
@endpush
