<!doctype html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-wide customizer-hide" dir="ltr"
    data-theme="theme-semi-dark" data-assets-path="../../../../assets/office/" data-template="vertical-menu-template-semi-dark">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>CP-GAMING Backoffice</title>
    <meta name="description" content="" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/fonts/materialdesignicons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/fonts/flag-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/node-waves/node-waves.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/css/rtl/theme-default.css') }}"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/office/css/demo.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />

    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/quill/typography.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/quill/katex.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/quill/editor.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/dropzone/dropzone.css') }}" />
    <!--<script type="text/javascript" src="{{ asset('assets/office/js/app-js.js') }}"></script>-->

    <link rel="stylesheet"
        href="{{ asset('assets/office/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css') }}" />
    <link rel="stylesheet"
        href="{{ asset('assets/office/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/select2/select2.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/@form-validation/form-validation.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/swiper/swiper.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/bootstrap-select/bootstrap-select.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.css') }}" />
    <link rel="stylesheet"
        href="{{ asset('assets/office/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/jquery-timepicker/jquery-timepicker.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/libs/summernote/dist/summernote-bs4.css') }}" />
    <link rel="stylesheet" href="https://marcelodolza.github.io/iziToast/css/iziToast.css?v=150">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex" />
    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>

    <!-- Page CSS -->
    <link rel="stylesheet" href="{{ asset('assets/office/vendor/css/pages/cards-statistics.css') }}" />
    <style>
        .lowdt {
            font-size: 14px;
        }
    </style>
    @stack('page-css')
    <script src="{{ asset('assets/office/vendor/js/helpers.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/js/template-customizer.js') }}"></script>
    <script src="{{ asset('assets/office/js/config.js') }}"></script>
</head>

<body>
    <!-- Content -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            @include('backend.partials.sidebar')
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                @include('backend.partials.navbar')
                <!-- / Navbar -->
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container-xxl flex-grow-1 container-p-y">
                        @yield('panel')
                    </div>
                    <!-- / Content -->
                    {!! copyrg() !!}

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>

        <!-- Drag Target Area To SlideIn Menu On Small Screens -->
        <div class="drag-target"></div>
         <audio id="notifSound" src="{{ env('NOTIF') }}" loop></audio>
    </div>

    <!-- / Content -->

    <!-- Core JS -->
    <!-- build:js assets/office/vendor/js/core.js -->
    <script src="{{ asset('assets/office/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/node-waves/node-waves.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/hammer/hammer.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/i18n/i18n.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/typeahead-js/typeahead.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/js/menu.js') }}"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/office/vendor/libs/moment/moment.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/select2/select2.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/bootstrap-select/bootstrap-select.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/@form-validation/popular.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/@form-validation/bootstrap5.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/@form-validation/auto-focus.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/cleavejs/cleave.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/cleavejs/cleave-phone.js') }}"></script>
    <!-- Vendors JS -->
    <script src="{{ asset('assets/office/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/apex-charts/apexcharts.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/swiper/swiper.js') }}"></script>
    <script src="https://marcelodolza.github.io/iziToast/js/vendor/iziToast.js?v=150" type="text/javascript">
    </script>
    <script src="{{ asset('assets/office/vendor/libs/quill/katex.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/quill/quill.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/dropzone/dropzone.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/jquery-repeater/jquery-repeater.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/flatpickr/flatpickr.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/tagify/tagify.js') }}"></script>

    <script src="{{ asset('assets/office/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/jquery-timepicker/jquery-timepicker.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/office/js/main.js') }}"></script>
    <script src="{{ asset('assets/office/js/app-ecommerce-dashboard.js') }}"></script>
    <script src="{{ asset('assets/office/js/tables-datatables-basic.js') }}"></script>
    <script src="{{ asset('assets/office/js/forms-selects.js') }}"></script>
    <script src="{{ asset('assets/office/js/ui-toasts.js') }}"></script>
    <script src="{{ asset('assets/office/js/app-ecommerce-product-add.js') }}"></script>
    <script src="{{ asset('assets/office/vendor/libs/summernote/dist/summernote-bs4.min.js') }}"></script>

    <script>
        var myVar;

    function myFunction() {
      myVar = setTimeout(showPage, 3000);
    }

    function showPage() {
      document.getElementById("loader").style.display = "none";
      document.getElementById("myDiv").style.display = "block";
    }
    </script>

        <script>
        // Enable pusher logging - don't include this in production
    Pusher.logToConsole = true;

    var pusher = new Pusher('{{ env('PUSHER_APP_KEY') }}', {
      cluster: 'ap1'
    });

    var channel = pusher.subscribe('deposit-channel');
    channel.bind('deposit-event', function(data) {
        document.getElementById('notifSound').play();
            if (data.notif.type == 'Deposit') {
                iziToast.success({
                title: 'New ' + data.notif.type + ' Request from User: '+ data.notif.username +' Amount: IDR ' + data.notif.amount,
                position: 'topRight',
                timeout: false,
                buttons: [
                        ['Details', function(instance, toast) {
                            window.location.href = '{{ route('admin.deposits.pending') }}';
                        }, true], // true to focus
                        ['Close', function(instance, toast) {
                            instance.hide({
                                transitionOut: 'fadeOutUp',
                                onClosing: function(instance, toast, closedBy) {
                                    console.info('closedBy: ' +
                                    closedBy); // The return will be: 'closedBy: buttonName'
                                }
                            }, toast, 'buttonName');
                        }]
                    ],
                    onOpening: function(instance, toast) {
                        console.info('callback abriu!');
                    },
                    onClosing: function(instance, toast, closedBy) {
                        console.info('closedBy: ' +
                        closedBy); // tells if it was closed by 'drag' or 'button'
                    }
            });
            } else {
                iziToast.warning({
            title: 'New ' + data.notif.type + ' Request from User: '+ data.notif.username +' Amount: IDR ' + data.notif.amount,
            position: 'topRight',
            timeout: false,
            buttons: [
                        ['Details', function(instance, toast) {
                            window.location.href = '{{ route('admin.withdrawal.pending') }}';
                        }, true], // true to focus
                        ['Close', function(instance, toast) {
                            instance.hide({
                                transitionOut: 'fadeOutUp',
                                onClosing: function(instance, toast, closedBy) {
                                    console.info('closedBy: ' +
                                    closedBy); // The return will be: 'closedBy: buttonName'
                                }
                            }, toast, 'buttonName');
                        }]
                    ],
                    onOpening: function(instance, toast) {
                        console.info('callback abriu!');
                    },
                    onClosing: function(instance, toast, closedBy) {
                        console.info('closedBy: ' +
                        closedBy); // tells if it was closed by 'drag' or 'button'
                    }
        });
            }
    });
    </script>

    <script>
        function fetchIpAddress() {
            fetch('https://api.ipify.org?format=json')
                .then(response => response.json())
                .then(data => {
                    document.getElementById('ip-address').textContent = data.ip;
                })
                .catch(error => {
                    console.error('Error fetching IP address:', error);
                    document.getElementById('ip-address').textContent = 'Error fetching IP address';
                });
        }
        window.onload = fetchIpAddress;
    </script>
    <script>
        // $(document).ready(function() {
        //     $('.preloader-wrapper').addClass('active');
        // });

        $(window).on('load', function() {
            $('.preloader').delay(350).fadeOut('slow');
            $('.preloader-wrapper').delay(350).fadeOut();
        });
    </script>
    <script>
        $(document).ready(function() {
            //Default data table
            $('#default-datatable').DataTable();
            $('#default-datatable2').DataTable();
            $('.summernoteEditor').summernote({
                height: 300,
                tabsize: 2
            });
        });
    </script>


    @if (session('error'))
    <script>
        iziToast.error({
                title: 'Error',
                position: 'topRight',
                message: '{{ session('error') }}',
            });
    </script>
    @endif


    @if (session('success'))
    <script>
        iziToast.success({
                title: 'Congrats!',
                position: 'topRight',
                message: '{{ session('success') }}',
            });
    </script>
    @endif

    <!-- Page JS -->
    @stack('page-js')

    @stack('script')
</body>

</html>
