@extends('backend.layouts.main')
@section('panel')
<h4 class="fw-bold py-3 mb-3">Edit Pasaran: {{ $pasaran->title }}</h4>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.lottery.manage.update', $pasaran->id) }}" method="POST">
            @csrf
            <div class="mb-3">
                <label class="form-label">Hasil Keluaran</label>
                <input type="text" name="keluaran" value="{{ old('keluaran', $pasaran->keluaran) }}" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Tanggal</label>
                <input type="text" name="tanggal" value="{{ old('tanggal', $pasaran->tanggal) }}" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Periode</label>
                <input type="number" name="periode" value="{{ old('periode', $pasaran->periode) }}" class="form-control" required>
            </div>

            <button type="submit" class="btn btn-success">Simpan Perubahan</button>
            <a href="{{ route('admin.lottery.manage') }}" class="btn btn-secondary">Kembali</a>
        </form>
    </div>
</div>
@endsection
