{{-- resources/views/backend/lottery/history.blade.php --}}
@extends('backend.layouts.main')
@section('panel')
<h4 class="fw-bold py-3 mb-3">History Taruhan Member</h4>

<div class="card">
    <div class="card-body">
        <a href="{{ route('admin.lottery.manage') }}" class="btn btn-secondary btn-sm mb-3">Kembali ke Manage Pasaran</a>

        <table class="table table-bordered table-sm" id="history-table">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Username</th>
                    <th>Pasaran</th>
                    <th>Pasang</th>
                    <th>Amount</th>
                    <th>Amount Bet</th>
                    <th>Tanggal</th>
                    <th>Win</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($taruhans as $t)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $t->username }}</td>
                    <td>{{ $t->market }}</td>
                    <td>{{ $t->pasang }}</td>
                    <td>{{ $t->amount }}</td>
                    <td>{{ $t->amount_bet }}</td>
                    <td>{{ $t->date }}</td>
                    <td>{{ $t->win }}</td>
                    <td>
                        @if($t->status == '0')
                            <span class="badge bg-danger">Kalah</span>
                        @elseif($t->status == '1')
                            <span class="badge bg-primary">Menunggu</span>
                        @elseif($t->status == '2')
                            <span class="badge bg-success">Sukses</span>
                        @else
                            <span class="badge bg-secondary">{{ $t->status }}</span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection

@push('script')
<script>
$(function(){
    $('#history-table').DataTable({
        lengthMenu:[[25,50,100,-1],[25,50,100,"All"]],
        order:[[6,'desc']],
        columnDefs:[{className:'text-center',targets:'_all'}]
    });
});
</script>
@endpush