@extends('backend.layouts.main')
@section('panel')
<h4 class="fw-bold py-3 mb-3">Edit Pasaran: {{ $pasaran->title }}</h4>

<div class="card">
    <div class="card-body">
        <a href="{{ route('admin.lottery.manage') }}" class="btn btn-secondary btn-sm mb-3">Kembali ke Manage Pasaran</a>

        <form action="{{ route('admin.lottery.manage.update', $pasaran->id) }}" method="POST">
            @csrf
            <div class="mb-3">
                <label for="title" class="form-label">Nama Pasaran</label>
                <input type="text" name="title" id="title" class="form-control" value="{{ old('title', $pasaran->title) }}" required>
            </div>

            <div class="mb-3">
                <label for="date" class="form-label">Tanggal</label>
                <input type="text" name="date" id="date" class="form-control" value="{{ old('date', $pasaran->date) }}" required>
            </div>

            <div class="mb-3">
                <label for="result" class="form-label">Result</label>
                <input type="text" name="result" id="result" class="form-control" value="{{ old('result', $pasaran->result) }}" required>
            </div>

            <div class="mb-3">
                <label for="periode" class="form-label">Periode</label>
                <input type="text" name="periode" id="periode" class="form-control" value="{{ old('periode', $pasaran->periode) }}">
            </div>

            <button type="submit" class="btn btn-success">Update Pasaran</button>
        </form>
    </div>
</div>
@endsection
