{{-- resources/views/backend/lottery/update_result.blade.php --}}
@extends('backend.layouts.main')
@section('panel')
<h4 class="fw-bold py-3 mb-3">Update Result Pasaran</h4>

<div class="card">
    <div class="card-body">

        {{-- Jumlah taruhan --}}
        <div class="mb-3">
            <strong>Jumlah Taruhan yang sudah pasang:</strong> {{ $taruhan_count }}
            @if($taruhan_count == 0)
                <span class="text-danger">(Belum ada taruhan Rubah dari EDIT)</span>
            @endif
        </div>

        {{-- Form update result --}}
        <form action="{{ route('admin.lottery.manage.result.update', $pasaran->id) }}" method="POST">
            @csrf
            <div class="mb-3">
                <label class="form-label">Keluaran</label>
                <input type="text" name="keluaran" class="form-control" value="{{ $pasaran->keluaran }}">
            </div>
            <div class="mb-3">
                <label class="form-label">Tanggal</label>
                <input type="text" name="tanggal" class="form-control" value="{{ $pasaran->tanggal }}">
            </div>
            <div class="mb-3">
                <label class="form-label">Periode</label>
                <input type="number" name="periode" class="form-control" value="{{ $pasaran->periode }}">
            </div>

            <button type="submit" class="btn btn-success" 
                @if($taruhan_count == 0) disabled @endif>Update Result</button>
            @if($taruhan_count == 0)
                <small class="text-muted">Tidak bisa update result karena belum ada taruhan.</small>
            @endif
        </form>

        {{-- Table semua taruhan --}}
        @if($taruhan_count > 0)
        <hr>
        <h5 class="mt-4">Detail Taruhan</h5>
        <div class="table-responsive">
            <table class="table table-bordered table-sm" id="taruhan-table">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Username</th>
                        <th>Market</th>
                        <th>Pasang</th>
                        <th>Amount</th>
                        <th>Amount Bet</th>
                        <th>Date</th>
                        <th>Win</th>
                        <th>Type</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($taruhans as $t)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $t->username }}</td>
                        <td>{{ $t->market }}</td>
                        <td>{{ $t->pasang }}</td>
                        <td>{{ $t->amount }}</td>
                        <td>{{ $t->amount_bet }}</td>
                        <td>{{ $t->date }}</td>
                        <td>{{ $t->win }}</td>
                        <td>{{ $t->type }}</td>
                        <td>
                            @if($t->status == '0')
                                <span class="badge bg-danger">Kalah</span>
                            @elseif($t->status == '1')
                                <span class="badge bg-primary">Menunggu</span>
                            @elseif($t->status == '2')
                                <span class="badge bg-success">Sukses</span>
                            @else
                                <span class="badge bg-secondary">{{ $t->status }}</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @endif

    </div>
</div>
@endsection

@push('script')
<script>
$(function(){
    $('#taruhan-table').DataTable({
        lengthMenu:[[25,50,100,-1],[25,50,100,"All"]],
        order:[[6,'desc']],
        columnDefs:[{className:'text-center',targets:'_all'}]
    });
});
</script>
@endpush