@extends('layouts.main')
@section('panel')
<div class="row">
    <div class="col-lg-4 mb-3">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Search</h4>
                <form class="form p-t-20" method="POST" action="" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group mb-3">
                        <label class="form-label">User :</label>
                        <select id="extplayer" name="extplayer" class="form-control select2" required>
                            <option value=""> Select User </option>
                            @foreach ($user as $mem)
                            <option value="{{ $mem->extplayer }}"> {{ $mem->username }} ( {{ $mem->nama_lengkap }} )
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary m-r-10">Search</button>
                </form>
            </div>
        </div>
    </div>
    <div id="to_tb" class="col-lg-8"></div>
</div>
@endsection


@push('script')
<script>
    $(document).ready(function () {
  $("form").submit(function (event) {
    var formData = {
      extplayer: $("#extplayer").val(),
    };

    $.ajax({
      type: "GET",
      url: window.location.href,
      data: formData,
    }).done(function (data) {
        $("#to_tb").html(data);
    });

    event.preventDefault();
  });
});
</script>
@endpush
