@extends('layouts.main')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Tanggal</h5>
                <div class="col-md-3">
                    <div id="daterange"
                        style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%; text-align:center">
                        <i class="mdi mdi-calendar-filter-outline"></i>
                        <span></span>
                    </div>
                </div>
            </div>
            <div class="card-datatable table-responsive">
                <table id="data-table" class="table table-bordered table-sm table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Tanggal</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Member Total</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Member Deposit</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Member Withdraw</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Deposit Total</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Withdraw Total</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Bonus</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 10px;">Total Profit</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script type="text/javascript">
    $(function () {
        var start_date = moment();
    var end_date = moment().add(15, 'days');;

    $('#daterange span').html(start_date.format('MMMM D, YYYY') + ' - ' + end_date.format('MMMM D, YYYY'));

    $('#daterange').daterangepicker({
        startDate : start_date,
        endDate : end_date
    }, function(start_date, end_date){
        $('#daterange span').html(start_date.format('MMMM D, YYYY') + ' - ' + end_date.format('MMMM D, YYYY'));
        table.draw();
    });
      var table = $('#data-table').DataTable({
          processing: false,
          serverSide: true,
          lengthMenu: [[25, 50, 100, -1], [25, 50, 100, "All"]],
          ajax: {
            url : "{{ $url }}",
            data : function(data){
                data.from_date = $('#daterange').data('daterangepicker').startDate.format('YYYY-MM-DD');
                data.to_date = $('#daterange').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
          },
          columns: [
              {data: 'created_at', name: 'created_at', orderable: false},
              {data: 'members', name: 'members', orderable: false},
              {data: 'deposit', name: 'deposit_success', orderable: false},
              {data: 'withdraw', name: 'withdraw_success', orderable: false},
              {data: 'deposit_success', name: 'deposit_success', orderable: false},
              {data: 'withdraw_success', name: 'withdraw_success', orderable: false},
              {data: 'bonus', name: 'bonus', orderable: false},
              {data: 'profit', name: 'profit', orderable: false},
          ] ,
          columnDefs: [
        { className: 'text-center lowdt', targets: '_all' }]
      });

    });
</script>
@endpush
