@extends('backend.layouts.main')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-tile mb-0">Settings Logo & Favicon</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-3 mb-3">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-tile mb-0">Logo</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-label-primary text-center mb-3 pt-2 rounded-3">
                                    <img class="img-fluid" src="{{ env('AWS_URL') }}{{ $web->logo }}" alt="Boy card image" width="150"
                                        loading="lazy">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 mb-3">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-tile mb-0">Favicon</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-label-primary text-center mb-3 pt-2 rounded-3">
                                    <img class="img-fluid" src="{{ env('AWS_URL') }}{{ $web->icon_web }}" alt="Boy card image" width="150"
                                        loading="lazy">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 mb-3">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-tile mb-0">Banner</h5>
                            </div>
                            <div class="card-body">
                                <div class="bg-label-primary text-center mb-3 pt-2 rounded-3">
                                    <img class="img-fluid" src="{{ env('AWS_URL') }}{{ $web->banner }}" alt="Boy card image" width="150"
                                        loading="lazy">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <form action="{{ route('admin.settings.logo_update') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="form-floating form-floating-outline mb-3">
                        <input type="file" class="form-control" name="logo">
                        <label for="ecommerce-product-name">Logo</label>
                    </div>

                    <div class="form-floating form-floating-outline mb-3">
                        <input type="file" class="form-control" name="icon_web">
                        <label for="ecommerce-product-name">Favicon</label>
                    </div>

                    <div class="form-floating form-floating-outline mb-3">
                        <input type="file" class="form-control" name="banner">
                        <label for="ecommerce-product-name">Banner</label>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary me-2">Save changes</button>
                    </div>
                </form>
                <!-- Comment -->
            </div>
        </div>
    </div>
</div>
@endsection
