@extends('backend.layouts.main')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-tile mb-0">SEO Settings</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.settings.seo_update') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="form-floating form-floating-outline mb-3">
                        <input type="text" class="form-control" value="{{ $web->title }}" name="title"
                            aria-label="Product title" />
                        <label>Title</label>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Keywords</label>
                        <textarea name="keyword" rows="2" class="form-control">{{ $web->keyword }}</textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea name="deskripsi" rows="2" class="form-control">{{ $web->deskripsi }}</textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Script</label>
                        <textarea name="script" rows="10" class="form-control">{{ $web->script }}</textarea>
                    </div>

                    <div class="form-group mb-2">
                        <label class="form-label">Articles :</label>
                        <textarea class="form-control summernoteEditor" type="text" name="articles">{!! $web->articles !!}</textarea>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary me-2">Save changes</button>
                    </div>
                </form>
                <!-- Comment -->
            </div>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-lg-4">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Create Meta</h4>
                <form class="form p-t-20" method="POST" action="{{ route('admin.settings.create_meta') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group mb-3">
                        <label>Tag</label>
                        <select name="tag" class="form-control select2" required>.
                            <option value="link"> Link Tag </option>
                            <option value="meta"> Meta Tag </option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Title</label>
                        <div class="input-group mb-3">
                            <input type="text" name="title" class="form-control" placeholder="Title"
                                required="" aria-label="Title" aria-describedby="basic-addon11" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Url</label>
                        <div class="input-group mb-3">
                            <input type="text" name="url" class="form-control"
                                placeholder="Url / Content" required="" aria-label="url"
                                aria-describedby="basic-addon11" required>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Meta List</h4>
            </div>
            <div class="card-datatable table-responsive">
                <table id="default-datatable" class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Tag</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Title</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Url / Conent</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($meta as $item)
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 13px;">{{ $loop->iteration }}</th>
                                <td class="text-center"
                                    style="vertical-align: middle; white-space: normal; font-size: 13px;">{{ $item->tag }}
                                </td>
                                <td class="text-center"
                                    style="vertical-align: middle; white-space: normal; font-size: 13px;">{{ $item->title }}
                                </td>
                                <td class="text-center"
                                    style="vertical-align: middle; white-space: normal; font-size: 13px;">{{ $item->url }}
                                </td>
                                <td class="text-center" style="vertical-align: middle; font-size: 13px;">
                                    <a href="{{ route('admin.settings.meta_delete',$item->id) }}" class="btn btn-xs btn-danger"
                                        onclick="return confirm('Are you sure want to delete this content?');"><span
                                            class="mdi mdi-trash-can"></span></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
