@extends('backend.layouts.main')
@section('panel')
<h4 class="fw-bold py-3 mb-3">
    Active Betting
</h4>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="col-sm-3">
                    <label class="form-label">Market :</label>
                    <select id="market" name="market" class="form-control select2" required>
                        <option value=""> Select Market </option>
                        @foreach ($pasaran as $market)
                        <option value="{{ $market->title }}"> {{ $market->title }} </option>
                        @endforeach
                    </select>

                    <button type="button" class="btn btn-danger mt-2" onclick="setResult('2');">Set Lose</button>
                    <button type="button" class="btn btn-info mt-2" onclick="setResult('1');">Set Win</button>
                </div>
            </div>
            <div class="card-datatable table-responsive">
                <table id="data-table" class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Trx ID</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Username</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Market</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Type</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Pasang</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bet Amount</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Jumlah Bayar</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Win</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Status</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Creted At</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="popupWin" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Set Win</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ route('admin.taruhan.approve') }}" method="POST">
                    @csrf
                    <div class="form-group mb-2">
                        <label class="form-label">Market :</label>
                        <select name="title" class="form-control select2" required>
                            <option value=""> Select Market </option>
                            @foreach ($pasaran as $market)
                            <option value="{{ $market->title }}"> {{ $market->title }} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Result</label>
                        <input type="text" name="result" placeholder="Keluaran" class="form-control" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="popupLose" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Set Lose</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ route('admin.taruhan.reject') }}" method="POST">
                    @csrf
                    <div class="form-group mb-2">
                        <label class="form-label">Market :</label>
                        <select name="title" class="form-control select2" required>
                            <option value=""> Select Market </option>
                            @foreach ($pasaran as $market)
                            <option value="{{ $market->title }}"> {{ $market->title }} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Result</label>
                        <input type="text" name="result" placeholder="Keluaran" class="form-control" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script type="text/javascript">
    $(function () {

      var table = $('#data-table').DataTable({
          processing: true,
          serverSide: true,
          lengthMenu: [[25, 50, 100, -1], [25, 50, 100, "All"]],
          ajax: {
            url: window.location.href,
            type: "GET",
            data: function (d) {
                d.market = $('#market').val();
            },
          },
          columns: [
              {data: 'id', name: 'id', orderable: false},
              {data: 'tid', name: 'tid', orderable: false},
              {data: 'username', name: 'username', orderable: false},
              {data: 'pasang', name: 'pasang', orderable: false},
              {data: 'market', name: 'market', orderable: false},
              {data: 'type', name: 'type', orderable: false},
              {data: 'amount', name: 'amount', orderable: false},
              {data: 'amount_bet', name: 'amount_bet', orderable: false},
              {data: 'win', name: 'win', orderable: false},
              {data: 'status', name: 'status', orderable: false, searchable: false},
              {data: 'created_at', name: 'created_at', orderable: false, searchable: false},
          ] ,
          columnDefs: [
        { className: 'text-center', targets: '_all' },
    ]
      });


      $(document).ready(function () {
        table.draw();
        $('#market').change(function () {
            table.ajax.reload();
        });
      })

    });

    function setResult(id) {
        if (id == 1) {
            $('#popupWin').modal('show');
        } else {
            $('#popupLose').modal('show');
        }
    }
</script>
@endpush
