@extends('backend.layouts.main')
@section('panel')
    <h4 class="fw-bold py-3 mb-3">
        History Betting
    </h4>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-datatable table-responsive">
                    <table id="data-table" class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Trx ID</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Username</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Pasang</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Market</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Type</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bet Amount</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Jumlah Bayar</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Win</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Status</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Creted At</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
<script type="text/javascript">
    $(function () {

      var table = $('#data-table').DataTable({
          processing: true,
          serverSide: true,
          lengthMenu: [[25, 50, 100, -1], [25, 50, 100, "All"]],
          ajax: {
            url: window.location.href,
            type: "GET",
          },
          columns: [
              {data: 'id', name: 'id', orderable: false},
              {data: 'tid', name: 'tid', orderable: false},
              {data: 'username', name: 'username', orderable: false},
              {data: 'pasang', name: 'pasang', orderable: false},
              {data: 'market', name: 'market', orderable: false},
              {data: 'type', name: 'type', orderable: false},
              {data: 'amount', name: 'amount', orderable: false},
              {data: 'amount_bet', name: 'amount_bet', orderable: false},
              {data: 'win', name: 'win', orderable: false},
              {data: 'status', name: 'status', orderable: false, searchable: false},
              {data: 'created_at', name: 'created_at', orderable: false, searchable: false},
          ] ,
          columnDefs: [
        { className: 'text-center', targets: '_all' },
    ]
      });

    });
</script>
@endpush
