@extends('backend.layouts.main')
@section('panel')
    <h4 class="fw-bold py-3 mb-3">
        Lottery Market
    </h4>

    <div class="row">
        <div class="col-lg-3">
            @if (Route::is('admin.taruhan.list.edit'))
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Edit Market <b>{{ $data->title }}</b></h4>
                        <form class="form p-t-20" method="POST" action="{{ route('admin.taruhan.list.update',$data->id) }}"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label>Icon</label>
                                <div class="input-group mb-3">
                                    <input type="file" class="form-control" name="file">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Pasaran</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="title" class="form-control" placeholder="Hongkong"
                                        required="" aria-label="Username" aria-describedby="basic-addon11" value="{{ $data->title }}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Jam Buka</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="buka" class="form-control" placeholder="00:00"
                                        required="" aria-label="Username" aria-describedby="basic-addon11"
                                        value="{{ $data->buka }}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Jam tutup</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="tutup" class="form-control" placeholder="00:00"
                                        required="" aria-label="Username" aria-describedby="basic-addon11"
                                        value="{{ $data->tutup }}">
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                        </form>
                    </div>
                </div>
            @else
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Create Market</h4>
                        <form class="form p-t-20" method="POST" action="{{ route('admin.taruhan.list.create') }}"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label>Icon</label>
                                <div class="input-group mb-3">
                                    <input type="file" class="form-control" required="" name="file">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Pasaran</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="title" class="form-control" placeholder="Hongkong"
                                        required="" aria-label="Username" aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Jam Buka</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="buka" class="form-control" placeholder="00:00"
                                        required="" aria-label="Username" aria-describedby="basic-addon11"
                                        value="00:00">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Jam tutup</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="tutup" class="form-control" placeholder="00:00"
                                        required="" aria-label="Username" aria-describedby="basic-addon11"
                                        value="00:00">
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                        </form>
                    </div>
                </div>
            @endif
        </div>
        <div class="col-lg-9">
            <div class="card">
                <div class="card-datatable table-responsive">
                    <table id="default-datatable" class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Logo</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Market</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Last Result</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Last Result Date
                                </th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Last Periode</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Open</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Close</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($pasaran as $trx)
                                <tr>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $loop->iteration }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <img src="{{ $trx->logo }}" alt="" loading="lazy" width="40">
                                    </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->title }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->keluaran }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->tanggal }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->periode }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->buka }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->tutup }}</td>
                                    <td class="text-center" style="vertical-align: middle; font-size: 13px;">
                                        <a href="{{ route('admin.taruhan.list.edit', $trx->id) }}"
                                            class="btn btn-xs btn-primary"><span class="mdi mdi-pencil"></span></a>
                                        <a href="{{ route('admin.taruhan.list.delete', $trx->id) }}"
                                            class="btn btn-xs btn-danger"
                                            onclick="return confirm('Are you sure want to delete this market?');"><span
                                                class="mdi mdi-trash-can"></span></a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
