@extends('backend.layouts.main')
@section('panel')
    <h4 class="fw-bold py-3 mb-3">
        Lottery Result
    </h4>

    <div class="row">
        <div class="col-lg-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Create Result</h4>
                    <form class="form p-t-20" method="POST" action="{{ route('admin.taruhan.create') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group mb-3">
                            <label class="form-label">Market :</label>
                            <select name="title" class="form-control select2" required>
                                <option value=""> Select Market </option>
                                @foreach ($pasaran as $market)
                                <option value="{{ $market->title }}"> {{ $market->title }} </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Result</label>
                            <div class="input-group mb-3">
                                <input type="text" name="result" class="form-control"
                                    placeholder="1234" required="" aria-label="Username"
                                    aria-describedby="basic-addon11" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Periode</label>
                            <div class="input-group mb-3">
                                <input type="text" name="periode" class="form-control"
                                    placeholder="1234" required="" aria-label="Username"
                                    aria-describedby="basic-addon11" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Date</label>
                            <div class="input-group mb-3">
                                <input type="date" name="date" class="form-control"
                                    placeholder="1234" required="" aria-label="Username"
                                    aria-describedby="basic-addon11" required>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-9">
            <div class="card">
                <div class="card-datatable table-responsive">
                    <table id="default-datatable" class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Market</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Result</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Periode</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($result as $trx)
                                <tr>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $loop->iteration }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <b>{{ $trx->title }}</b></td>
                                        <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <b>{{ $trx->result }}</b></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->periode }}</td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        {{ $trx->date }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
