@extends('frontend.layouts.main')
@section('content')
    <div class="page-header-title">
        <h3>Registrasi Anggota</h3>
        <a href="#" id="returnlastpage"><i class="icon-close"></i></a>
    </div>
    <div class="btn-default-container">
        @if (session('success'))
            <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">
                {{ session('error') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
        @endif
        <div id="Alert" class="alert  " role="alert" style="display: none;">
        </div>
        <form id="RegisterForm" action="{{ route('api.register') }}" method="POST" data-parsley-validate=""
            novalidate="novalidate">
            {{ csrf_field() }}
            <input type="hidden" name="ipAddress" value="{{ request()->ip() }}">
            <div class="textfield-wrap" id="UsernameCheck">
                <label for="username">Nama Pengguna<span>*</span></label>
                <div class="group-wrap">
                    <div class="input-field">
                        <input type="text" name="username" id="Username" placeholder='Antara 5 dan 16 karakter'
                            minlength="5" maxlength="16" required="required" data-validate="false" autocomplete="off">
                        <i class="fas fa-times-circle"></i>
                    </div>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap password-field" id="PasswordCheck">
                <label for="password">Kata Sandi<span>*</span></label>
                <div class="group-wrap">
                    <div class="input-field">
                        <input type="password" name="password" id="Password" class="pwdinput"
                            placeholder='Antara 6 dan 16 karakter' minlength="6" maxlength="16" required="required"
                            autocomplete="off">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <button type="button" class="login-show-pass btn btn-grey btn-pwd-visibility"
                        id="pwd_visibility">Perlihatkan</button>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap" id="cpasswordCheck">
                <label for="Confirm Password">Konfirmasi Sandi<span>*</span></label>
                <div class="input-field">
                    <input type="password" name="cpassword" id="cpassword" class="pwdinput"
                        placeholder='Antara 6 dan 16 karakter' minlength="6" maxlength="16" required="required"
                        autocomplete="off">
                    <i class="fas fa-times-circle"></i>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap" id="FirstNameCheck">
                <label for="firstName">Nama Lengkap<span>*</span></label>
                <div class="input-field">
                    <input type="text" name="accName" id="FirstName" required="required" autocomplete="off">
                    <i class="fas fa-times-circle"></i>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap mobile-field" id="MobileNumberCheck">
                <label for="mobileNumber">Nomor Telepon<span>*</span></label>
                <div class="group-wrap">
                    <div class="select-type">
                        <select id="CountryCode" name="countryCode">
                            <option value="62">+62</option>
                        </select>
                    </div>
                    <div class="input-field">
                        <input type="tel" name="phone" id="MobileNumber" minlength="7" maxlength="12"
                            placeholder="81261xxx" required="required" autocomplete="off">
                        <i class="fas fa-times-circle"></i>
                    </div>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap input-referral" data-area="ReferralCheck">
                <label for="referral ID">Kode Referral</label>
                <div class="input-field">
                    <input type="text" name="referral" id="Referral" value="" data-validate="false"
                        autocomplete="off">
                    <i class="fas fa-times-circle"></i>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap captcha-field" data-area="CaptchaCheck">
                <label for="captcha">Captcha<span>*</span></label>
                <div class="group-wrap">
                    <div class="input-field">
                        <input type="text" name="captcha" id="Captcha" maxlength="4" autocomplete="off"
                            required="required" data-validate="false">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <img src="{{ captcha_src() }}" id="imgCaptcha" class="img-captcha img-thumbnail" width="100"
                        style="height:40px !important;margin-left:10px;">
                    <i class="fas fa-redo-alt btn-reload-captcha" id="reloadCaptcha"></i>
                </div>
                <span class="tooltip" data-area="message"></span>
            </div>
            <div class="textfield-wrap" style="position:relative;margin-top:40px;">
                <button class="btn-primary btn-space btn-submit-register" type="submit">Kirim</button>
            </div>
        </form>
    </div>

   <script>
    // Button text configuration
    var button = {
        "show": "Perlihatkan",
        "hide": "Sembunyikan"
    };

    // Password Visibility Toggle Script
    document.addEventListener('DOMContentLoaded', function() {
        // Mobile version toggle
        const mobileToggleBtn = document.getElementById('pwd_visibility');
        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function() {
                togglePasswordVisibility('Password', this);
            });
        }

        // Desktop version toggle
        const desktopToggleBtn = document.getElementById('PasswordVisibility');
        if (desktopToggleBtn) {
            desktopToggleBtn.addEventListener('click', function() {
                togglePasswordVisibility('Password', this);
            });
        }

        // Core toggle function
        function togglePasswordVisibility(fieldId, buttonElement) {
            const passwordField = document.getElementById(fieldId);
            if (passwordField) {
                if (passwordField.type === 'password') {
                    passwordField.type = 'text';
                    buttonElement.textContent = button.hide;
                } else {
                    passwordField.type = 'password';
                    buttonElement.textContent = button.show;
                }
            }
        }

        // Captcha refresh functionality
        const captchaRefreshBtns = document.querySelectorAll('.btn-reload-captcha');
        captchaRefreshBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                fetch('/refresh-captcha')
                    .then(response => response.json())
                    .then(data => {
                        document.querySelectorAll('.img-captcha').forEach(img => {
                            img.src = data.captcha;
                        });
                    });
            });
        });
    });
</script>
@endsection


@section('desktop')
    <div class="middle">
        <div class="container">
            <h4 class="title">Registrasi Anggota</h4>

            @if (session('success'))
            <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">
                {{ session('error') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
        @endif
            <form id="RegisterForm" action="{{ route('api.register') }}" method="POST">
                @csrf
                <input type="hidden" name="ipAddress" value="{{ request()->ip() }}">
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="Username" class="col-sm-3">Nama Pengguna<span>*</span></label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="text" id="Username" class="form-control" name="username"
                                    minlength="5" maxlength="16" required="required" data-validate="false"
                                    autocomplete="off"
                                    placeholder='Nama pengguna harus minimal antara 5 dan 16 karakter Dan gunakan alfanumerik' required>
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="Email" class="col-sm-3">Email</label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="email" id="Email" class="form-control" name="email"
                                    data-validate="false" autocomplete="off" required>
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="Password" class="col-sm-3">Kata Sandi<span>*</span></label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="password" id="Password" class="form-control pwdinput" name="password"
                                    minlength="6" maxlength="16" required="required" autocomplete="off"
                                    placeholder='Panjang kata sandi minimal harus antara 6 dan 16 karakter'>
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                        <div class="col-sm-3">
                            <button type="button" class="bttn-check check-availability btn-pwd-visibility"
                                id="PasswordVisibility">Perlihatkan</button>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="cpassword" class="col-sm-3">Konfirmasi Sandi<span>*</span></label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="password" id="cpassword" class="form-control pwdinput" name="cpassword"
                                    minlength="6" maxlength="16" required="required" autocomplete="off"
                                    placeholder='Panjang kata sandi minimal harus antara 6 dan 16 karakter'>
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="FirstName" class="col-sm-3">Nama Lengkap<span>*</span></label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="text" id="FirstName" class="form-control" name="accName"
                                    required="required" autocomplete="off"
                                    placeholder='Masukkan nama Anda seperti yang tercantum pada kartu debit, kartu kredit atau rekening bank Anda' required>
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="MobileNumber" class="col-sm-3">Nomor Telepon<span>*</span></label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <select id="CountryCode" class="form-control col-sm-2" name="CountryCode"
                                    style="float:left;font-size:.825rem;">
                                    <option value="62">+62</option>
                                </select>
                                <input type="text" id="MobileNumber" class="form-control col-sm-10"
                                    name="phone" minlength="7" maxlength="12" required="required"
                                    autocomplete="off" placeholder="81261xxx" style="float:right;">
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap input-referral">
                    <div class="row">
                        <label for="Referral" class="col-sm-3">Kode Referral</label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="text" id="Referral" class="form-control" name="referral"
                                    value="" autocomplete="off" data-validate="false">
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                    </div>
                </div>
                <div class="form-group textfield-wrap">
                    <div class="row">
                        <label for="Captcha" class="col-sm-3">Captcha<span>*</span></label>
                        <div class="row col-sm-6">
                            <div class="input-field">
                                <input type="text" id="Captcha" class="form-control" name="captcha"
                                    required="required" data-validate="false" maxlength="4" autocomplete="off">
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="help-block" data-area="message"></span>
                        </div>
                        <div class="col-sm-3">
                            <img src="/captcha/login/123123132" id="imgCaptcha" class="img-captcha img-thumbnail"
                                width="100" height="32" align="left">
                            <i class="fas fa-redo-alt btn-reload-captcha" id="ReloadCaptchaRegister"></i>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="row">
                        <div class="col-sm-6 offset-sm-3 padding-left-0">
                            <button class="bttn-register btn-submit-register" id="RegisterButton"
                                type="submit">Kirim</button>
                        </div>
                    </div>
                </div>
            </form>

            <script>
    // Button text configuration
    var button = {
        "show": "Perlihatkan",
        "hide": "Sembunyikan"
    };

    // Password Visibility Toggle Script
    document.addEventListener('DOMContentLoaded', function() {
        // Mobile version toggle
        const mobileToggleBtn = document.getElementById('pwd_visibility');
        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function() {
                togglePasswordVisibility('Password', this);
            });
        }

        // Desktop version toggle
        const desktopToggleBtn = document.getElementById('PasswordVisibility');
        if (desktopToggleBtn) {
            desktopToggleBtn.addEventListener('click', function() {
                togglePasswordVisibility('Password', this);
            });
        }

        // Core toggle function
        function togglePasswordVisibility(fieldId, buttonElement) {
            const passwordField = document.getElementById(fieldId);
            if (passwordField) {
                if (passwordField.type === 'password') {
                    passwordField.type = 'text';
                    buttonElement.textContent = button.hide;
                } else {
                    passwordField.type = 'password';
                    buttonElement.textContent = button.show;
                }
            }
        }

        // Captcha refresh functionality
        const captchaRefreshBtns = document.querySelectorAll('.btn-reload-captcha');
        captchaRefreshBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                fetch('/refresh-captcha')
                    .then(response => response.json())
                    .then(data => {
                        document.querySelectorAll('.img-captcha').forEach(img => {
                            img.src = data.captcha;
                        });
                    });
            });
        });
    });
</script>
        </div>
    </div>
@endsection
