
<!DOCTYPE html>
<html id="">
	<head>
		<meta charset="UTF-8">
	    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	    <meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="robots" content="noindex, nofollow">
	    <link rel="icon" type="image/x-icon" href="https://cdn.robotaset.com/assets/images/common/favicon.ico">
		<title>Pemeliharaan</title>
		<link href="https://cdn.robotaset.com/assets/thirdparty/css/bootstrap.min.css" rel="stylesheet">
		<link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/brands.css" media="print" onload="this.media='all'" rel="stylesheet">
		<link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/solid.css" media="print" onload="this.media='all'" rel="stylesheet">
		<link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/fontawesome.css" media="print" onload="this.media='all'" rel="stylesheet">
		<link href="https://cdn.robotaset.com/assets/css/main-style.css" rel="stylesheet">
		<link href="https://cdn.robotaset.com/assets/tpl//css/style.css" rel="stylesheet">
		<link href="https://cdn.robotaset.com/assets/css/fonts.google.ubuntu.css" media="print" onload="this.media='all'" rel="stylesheet">
		<script src="https://cdn.robotaset.com/assets/js/common/jquery-3.6.0.min.js"></script>
		<style type="text/css">
			.modal-content [class^=modal-] {
			  background-color: #fff;
			}

			.modal-header h5 {
				color: #000;
			}
			.desc {
				padding-top: unset;
				width: 100%;
				max-width: unset;
			}
			#normal-countdown .time-sec {
				background: rgb(0 0 0 / 10%);
			}
		</style>
	</head>

	<body>
		<div class="modal" id="maintenanceSystemMessage" tabindex="-1" aria-labelledby="maintenanceSystemMessageLabel" aria-hidden="true">
			<div class="modal-dialog modal-xl modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title text-center" id="maintenanceSystemMessageLabel">Pemeliharaan</h5>
					</div>
					<div class="modal-body">
				        <p class="desc text-center mb-4">Kepada para pemain,<br><br>Kami informasikan bahwa {{ $provider_name }} sedang melakukan kegiatan rutin perbaikan sistem.<br>Mohon untuk menutup semua permainan selama perbaikan berlangsung untuk menghindari kehilangan saldo.<br><br>Mohon maaf atas ketidaknyamanannya,<br>terima kasih atas pengertian dan kerjasamanya.</p>
						<div class="mb-4" id="normal-countdown" data-ts="1746028800000" data-date="{{ date('d-m-Y h:i:s', strtotime("+30 days")); }}">
						    <div class="time-sec">
						        <h3 class="main-time days">22</h3>
						        <span>hari</span>
						    </div>
						    <div class="time-sec">
						        <h3 class="main-time hours">03</h3>
						        <span>jam</span>
						    </div>
						    <div class="time-sec">
						        <h3 class="main-time minutes">42</h3>
						        <span>menit</span>
						    </div>
						    <div class="time-sec">
						        <h3 class="main-time seconds">22</h3>
						        <span>detik</span>
						    </div>
						</div>
					</div>
					<div class="modal-footer d-flex justify-content-center">
						<a href="/" type="button" class="btn btn-warning col-sm-3">Kembali ke Halaman Utama</a>
					</div>
				</div>
			</div>
		</div>

		<script src="https://cdn.robotaset.com/assets/js/common/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.robotaset.com/assets/js/common/popper.min.js" type="text/javascript"></script>
		<script src="https://cdn.robotaset.com/assets/js/common/bootstrap.min.js" type="text/javascript"></script>
		<script>
		    $(document).ready(function() {
				var element = $("#normal-countdown");
				var ts = element.data("ts");

				var x = setInterval(function() {
					var now = new Date().getTime();
					var distance = ts - now;
					// If the count down is finished, write some text
					var days = "00";
					var hours = "00";
					var minutes = "00";
					var seconds = "00";

					if(distance < 1000) {
						clearInterval(x);
						setTimeout(function() {
							location.reload();
						}, 500);
					} else {
						days = Math.floor(distance / (1000 * 60 * 60 * 24));
						hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
						minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
						seconds = Math.floor((distance % (1000 * 60)) / 1000);

						days = days < 10 ? '0'+days : days;
						hours = hours < 10 ? '0'+hours : hours;
						minutes = minutes < 10 ? '0'+minutes : minutes;
						seconds = seconds < 10 ? '0'+seconds : seconds;
					}

					element.find(".days").text(days);
					element.find(".hours").text(hours);
					element.find(".minutes").text(minutes);
					element.find(".seconds").text(seconds);
				}, 1000);

		    	var _modal = $('#maintenanceSystemMessage');

		    	_modal.modal({backdrop:'static',keyboard:false, show:true});
				_modal.modal('show');
				_modal.find('button').focus();
		    });
		</script>

		</body>
</html>
