@extends('frontend.layouts.main')
@section('content')
    <div class="newsInfo" id="newsInfo">
        <i class="icon-speaker"></i>
        <marquee class="marquee">SELAMAT DATANG DI {{ general()->title }} - {{ strtoupper($game_type) }} GAMES DARI {{ strtoupper($provider->provider_name) }}</marquee>
        <i class="icon-navigate-next"></i>
    </div>

    <div class="main-header-title">
        <i class="provider-logo-type {{ strtolower($provider->provider_code) }}-logo"></i>
        <div class="search-wrapper">
            <input class="search" type="search" placeholder='Cari {{ $game_type }} game...' id="gameName">
            <a href="#{{ $provider->provider_code }}"><i class="icon-search" id="gameSearch"></i></a>
        </div>
    </div>

    <ul class="game-item-tabs" id="GameCategory">
        <li>
            <a href="#{{ $provider->provider_code }}" class="active">{{ $provider->provider_name }} {{ strtoupper($game_type) }}</a>
        </li>
    </ul>

    <div class="game-item-list">
        <div id="gameUl" class="tab-content clearfix">
            <ul role="tabpanel" class="tab-pane fade show active" id="{{ $provider->provider_code }}">
                @forelse ($games as $item)
                    <li data-area="game_{{ strtolower($game_type) }}" data="{{ $item->game_code }}" class="">
                        <div class="game-wrapper">
                            <div class="game-list-core">
                                <div class="game-list-content">
                                    <a href="/play?gamecode={{ $item->game_code }}&type={{ $game_type }}" class="open-game-inline" data-id="{{ $item->game_code }}">
                                        <img data-alt="{{ $item->game_name }}"
                                             title="{{ $item->game_name }}" 
                                             alt="{{ $item->game_name }}"
                                             src="{{ $item->game_image }}"
                                             class="img-fluid img-thumbnail"
                                             onerror="this.src='{{ asset('assets/images/d6fb4a76.png') }}'; this.onerror=null;"
                                             width="100%" height="100%" loading="lazy">
                                    </a>
                                </div>
                            </div>
                            <div class="figure-text">
                                <p>{{ $item->game_name }}</p>
                                <span class="game-badge">{{ strtoupper($game_type) }}</span>
                            </div>
                        </div>
                    </li>
                @empty
                    <li class="no-games">
                        <div class="alert alert-warning">Tidak ada game {{ $game_type }} tersedia untuk provider ini</div>
                    </li>
                @endforelse
            </ul>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Search functionality
            $(document).on("keyup", "#gameName", function(e) {
                const searchTerm = $(this).val().toLowerCase();
                $("#gameUl li").each(function() {
                    const gameName = $(this).find(".figure-text p").text().toLowerCase();
                    $(this).toggle(gameName.includes(searchTerm));
                });
            });

            // Game category tabs
            $(".game-item-tabs a").click(function(e) {
                e.preventDefault();
                $(".game-item-tabs a").removeClass("active");
                $(this).addClass("active");
                const target = $(this).attr("href");
                $(".tab-pane").removeClass("show active");
                $(target).addClass("show active");
            });
        });
    </script>
@endsection

@section('desktop')
    <div class="middle">
        <div class="container">
            <h4 class="title">{{ $provider->provider_name }} - {{ strtoupper($game_type) }} GAMES</h4>

            <div class="input-group mb-3">
                <input type="search" class="form-control search-game-name" id="desktopGameName"
                    placeholder='Cari {{ $game_type }} game...'>
                <div class="input-group-append">
                    <button class="btn btn-outline-secondary" type="button" id="searchButton">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>

            <div id="GamePanel">
                <ul id="GameCategory" class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a href="#{{ $provider->provider_code }}" data-toggle="tab"
                            class="nav-link active">{{ $provider->provider_name }} {{ strtoupper($game_type) }}</a>
                    </li>
                </ul>

                <div id="GameSubCategory" class="tab-content clearfix">
                    <div role="tabpanel" class="tab-pane fade show active" id="{{ $provider->provider_code }}">
                        <div class="row">
                            @forelse ($games as $item)
                                <div class="col-2 game-list">
                                    <div class="game_group">
                                        <div class="game-list-content">
                                            <span class="game-favorite" data-id="{{ $item->game_code }}">
                                                <i class="fas fa-star"></i>
                                            </span>
                                            <img src="{{ $item->game_image }}" 
                                                 alt="{{ $item->game_name }}"
                                                 class="img-fluid img-thumbnail" 
                                                 onerror="this.src='{{ asset('assets/images/d6fb4a76.png') }}';"
                                                 loading="lazy">
                                            <button class="btn-game" 
                                                    data-id="{{ $item->game_code }}"
                                                    data-url="/play?gamecode={{ $item->game_code }}&type={{ $game_type }}">
                                                Main Sekarang
                                            </button>
                                        </div>
                                        <div class="figure-text">
                                            <p>{{ $item->game_name }}</p>
                                            <span class="badge badge-primary">{{ strtoupper($game_type) }}</span>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-12">
                                    <div class="alert alert-warning">Tidak ada game {{ $game_type }} tersedia</div>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            <script>
                // Desktop search functionality
                $(document).ready(function() {
                    $('#desktopGameName, #searchButton').on('input click', function() {
                        const searchTerm = $('#desktopGameName').val().toLowerCase();
                        $('.game-list').each(function() {
                            const gameName = $(this).find('.figure-text p').text().toLowerCase();
                            $(this).toggle(gameName.includes(searchTerm));
                        });
                    });

                    // Force same tab opening for game buttons
                    document.querySelectorAll('.btn-game').forEach(btn => {
                        btn.addEventListener('click', function(e) {
                            e.preventDefault();
                            window.location.href = this.getAttribute('data-url');
                        });
                    });
                });
            </script>
        </div>
    </div>
@endsection