@extends('frontend.layouts.main')
@section('content')
<main id="main-route">
    <div class="main-content contact-us">
        <div class="container">
            <div class="page-header">Kontak Kami</div>
            <div class="contact-us__content">
                <div class="row">
                    @foreach ($contact as $item)
                    <div class="col-lg-4 col-md-6 mb-4">
                        <a href="{{ $item->url }}" target="_blank" rel="noreferrer">
                            <div class="contact-us__item">
                                <div class="item-header {{ $item->icon }}">{{ strtoupper($item->title) }}</div>
                                <div class="item-content">
                                    <h5 class="title">{{ $item->title }}</h5>
                                    <div class="description">Hubungi CS kami dan kami akan dengan senang hati membantu
                                        Anda.</div>
                                </div>
                            </div>
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="main-content game">
        <div class="container">
            <div class="game__seo">
                <div hidden="" id="title-seo">{{ general()->judul }}: Contact</div>
                <div class="seo-content showFooter">
                    <h1>Contact</h1>
                    <p>Contact</p>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
