@extends('frontend.layouts.main')
@section('content')
<div class="page-header-title">
    <h3>Profil</h3>
    <a href="/"><i class="icon-close"></i></a>
</div>

<div class="info-page-content">
    <div class="toggle-button">
        <a class="toggle-button-option active" href="/account/profile">Profil</a>
        <a class="toggle-button-option " href="/account/password">Ubah Sandi</a>
    </div>
    <!-- Profile Info -->
    <div id="Profile" class="profile-tab">
        <div class="textfield-wrap">
            <label for="currency">Nama Pengguna</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtusername" value="{{ auth()->user()->username }}" readonly="readonly">
                </div>
            </div>
        </div>
        <div class="textfield-wrap">
            <label for="currency">ID Referral</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtreferralid" value="{{ auth()->user()->username }}" readonly="readonly">
                </div>
            </div>
            <!-- <span class="msg-notice">Anda dapat menyalin ID Referral Anda ke pemain</span> -->
        </div>
        @if(auth()->user()->nama_bank != 'notset')
        <div class="textfield-wrap">
            <label for="currency">Nama Bank</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtbankname" value="{{ strtoupper(auth()->user()->nama_bank) }}" readonly="readonly">
                </div>
            </div>
        </div>
        <div class="textfield-wrap">
            <label for="currency">Nomor Rekening Bank</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtaccountno" value="{{ censor(auth()->user()->nomor_rekening,4) }}" readonly="readonly">
                </div>
            </div>
        </div>
        <div class="textfield-wrap">
            <label for="currency">Nama Rekening</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtaccountname" value="{{ censor(auth()->user()->nama_lengkap,4) }}" readonly="readonly">
                </div>
            </div>
        </div>
        @else
        <div class="textfield-wrap">
            <label for="currency">Nama Bank</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtbankname" value="" readonly="readonly">
                </div>
            </div>
        </div>
        <div class="textfield-wrap">
            <label for="currency">Nomor Rekening Bank</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtaccountno" value="" readonly="readonly">
                </div>
            </div>
        </div>
        <div class="textfield-wrap">
            <label for="currency">Nama Rekening</label>
            <div class="group-wrap">
                <div class="input-field browser-default">
                    <input type="text" id="txtaccountname" value="" readonly="readonly">
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@section('account')
<div class="row con_box">
    <div class="account_main info-page-content">
        <div id="Alert" class="alert  " role="alert" style="display: none;">
        </div>
        <div class="col-7 con_item">
            <!-- Get the error parameter from the URL -->
            <h4>PROFILE</h4>
            <div class="form-group">
                <label for="">Nama Pengguna</label>
                <span class="info_type" id="txtusername">{{ auth()->user()->username }}</span>

                <label for="">ID Referral</label>
                <span class="info_type" id="txtreferralid">{{ auth()->user()->username }}</span>

                <label for="">Nama Bank</label>
                <span class="info_type" id="txtbankname">{{ strtoupper(auth()->user()->nama_bank) }}</span>

                <label for="">Nomor Rekening Bank</label>
                <span class="info_type" id="txtaccountno">{{ censor(auth()->user()->nomor_rekening,4) }}</span>

                <label for="">Nama Rekening</label>
                <span class="info_type" id="txtaccountname">{{ censor(auth()->user()->nama_lengkap,4) }}</span>
            </div>
        </div>
    </div>
</div>
@endsection
