@mobile
@forelse ($history as $item)
<div class="bank-history history-wrapper">
    <div class="history-card">
        @if ($item->status == 'Sukses')
        <div class="history-status alert-success">Approved</div>
        @elseif ($item->status == 'Ditolak')
        <div class="history-status alert-danger">Rejected</div>
        @else
        <div class="history-status alert-warning">Pending</div>
        @endif
        <div class="history-content">
            <div class="history-summary">
                <div class="history-summary-info">
                    <div class="bank-{{ strtolower($item->metode) }}"></div>
                    <div class="history-title @if ($item->transaksi == 'Top Up') text-primary
                    @else text-success @endif">
                        @if ($item->transaksi == 'Top Up')
                        Deposit
                        @else
                        {{ $item->transaksi }}
                        @endif
                    </div>
                    <div class="history-summary-row">{{ date('d M Y H:i:s', strtotime($item->created_at)) }}
                    </div>
                    @if ($item->transaksi == 'Top Up')
                    <div class="history-summary-row"><span>Ke {{ $item->metode }}</span>
                        @else
                        <div class="history-summary-row"><span>Ke
                                {{ strtoupper(auth()->user()->nama_bank) }} -
                                {{ censor(auth()->user()->nomor_rekening, 4) }} -
                                {{ censor(auth()->user()->nama_lengkap, 2) }}</span>
                            @endif
                            <span class="amount text-primary">{{ number_format($item->total) }}</span>
                        </div>
                        <div class="history-summary-row">No. Referensi: <span class="trx-refno"
                                id="refno-{{ $item->trx_id }}">{{ $item->trx_id }}<i class="fas fa-copy copyRef"
                                    data-clipboard-target="#refno-{{ $item->trx_id }}"></i></span><span
                                class="copied"></span></div>
                        @if ($item->status == 'Ditolak')
                        <div class="history-summary-row" style="padding-top:10px"><b>Catatan:</b> <span
                                class="text-danger">{{ $item->keterangan }}</span></div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @empty
    <h2>Riwayat transaksi kosong.</h2>
    <p>Riwayat transaksi akan ditampilkan jika tersedia.</p>
    @endforelse
    @endmobile
    @desktop
    @forelse ($history as $item)
    <tr style="vertical-align:top">
        <td>{{ $loop->iteration }}</td>
        <td align="right">{{ date('d M Y H:i:s', strtotime($item->created_at)) }}</td>
        <td>
            @if ($item->transaksi == 'Top Up')
            Deposit
            @else
            {{ $item->transaksi }}
            @endif
        </td>
        <td align="left">
            @if ($item->transaksi == 'Top Up')
            <span>Ke {{ $item->metode }}</span>
            @else
            <span>Ke {{ strtoupper(auth()->user()->nama_bank) }} - {{ censor(auth()->user()->nomor_rekening, 4) }} - {{
                censor(auth()->user()->nama_lengkap, 2) }}</span>
            @endif
            <p style="margin-bottom:0">No. Referensi :
                <span class="trx-refno" id="refno-{{ $item->trx_id }}">
                    {{ $item->trx_id }} <i class="fas fa-copy copyRef"
                        data-clipboard-target="#refno-{{ $item->trx_id }}"></i>
                </span>
                <span class="copied" style="margin-left:.75rem;color:#4CAF50 !important;"></span>
            </p>

        </td>
        <td align="right" class="text-primary">{{ number_format($item->total) }}</td>
        <td>
            @if ($item->status == 'Sukses')
            <span class="text-success">Approved</span>
            @elseif ($item->status == 'Ditolak')
            <span class="text-danger">Rejected</span>
            @else
            <span class="text-warning">Pending</span>
            @endif
        </td>
        <td align="left">
            <span></span>

            <br>

        </td>
    </tr>
    @empty
    <h2>Riwayat transaksi kosong.</h2>
    <p>Riwayat transaksi akan ditampilkan jika tersedia.</p>
    @endforelse
    @enddesktop
