@extends('frontend.layouts.main')
@section('content')
@php
        $user = Auth::user();

        $username = $user->username;
       
        $data = [
            'username' => $username
        ];

        $jsonString = json_encode($data);

        $base64Encoded = base64_encode($jsonString);
@endphp
<div class="page-header-title">
    <h3>Bank</h3>
</div>
<div class="account-structure">
    <ul class="account-menu" id="account_menu">
        <li><a href="/bank/account">Akun Saya</a></li>
        <li><a href="/bank/deposit" class="active">Deposit</a></li>
        <li><a href="/bank/history">History</a></li>
        <li><a href="/bank/withdraw">Withdraw</a></li>
    </ul>
</div>
@if (auth()->user()->nama_bank == 'notset')
<form id="DepositForm" class="bank-form" action="/api/bank/setDeposit" method="POST">
    @csrf
    <div class="info-page-content" data-otd="false" data-wait="false" data-empty="true">
        <div class="account-content">
            <div class="default-wrap">
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>Silahkan isi data bank sebelum melakukan deposit. <br> Anda akan dialihkan ke halaman bank
                dalam
                <span id="counter">3</span> detik..
                <script></script>
                <script src="https://cdn.robotaset.com/assets/js/common/axios.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/common/clipboard.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/pages/bank_deposit.js"></script>
                <script>
                    var clipboard = new ClipboardJS('.copyText');

                            clipboard.on('success', function(e) {
                                $(".copied").text(alertMsg.copy_success);
                                setTimeout(function() {
                                    $(".copied").text("");
                                }, 3000);
                                e.clearSelection();
                            });
                            clipboard.on('error', function(e) {
                                $(".copied").text(alertMsg.copy_failed).css("color", "#D32F2F");
                                setTimeout(function() {
                                    $(".copied").text("");
                                }, 3000);
                                e.clearSelection();
                            });
                </script>
            </div>
        </div>
    </div>
</form>
@else
@if (!empty($last) && $last->metode == 'qris')
<form id="DepositForm" class="bank-form" action="/api/bank/setDeposit" method="POST">
    <div class="info-page-content" data-otd="true" data-wait="false" data-empty="true">
        <div class="account-content">
            <div class="default-wrap">
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>
                <div class="finish-payment-wrapper">
                    <div class="outstanding-date">
                        <div class="please-pay-to">Selesaikan pembayaran dalam</div>
                        <div class="css-0">
                            <p class="due-date">{{ date('d M Y H:i:s', strtotime($last->created_at . ' +1 day')) }}</p>
                        </div>
                    </div>
                    <div class="otd-acc-detail">
                        <div class="bank-name-row">
                            <div class="bank-name">{{ banksDetails($last->metode)->nama_bank }} -
                                {{ banksDetails($last->metode)->nama_pemilik }}</div>
                            <div class="css-vhe8zj payment-bank-logo">
                                <div class="qris"></div>
                            </div>
                        </div>

                        <div class="">
                            <div class="">
                                <div class=""></div>
                                <div class="">
                                    <div class="">
                                        <div class=""></div>
                                    </div>
                                </div>
                            </div>
                            <div class="">
                                <div class=""></div>
                                <div class="">
                                    <div class="">
                                        <div class="">
                                            <span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="">
                                <div class=""></div>
                                <div class="">
                                    <div class="css-158s7cq">
                                        <div id=""""><i
                                                class=""></i></div>
                                        <div id="" class=""></div>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center">
                                <div id="qrcode" class="qr-img"
                                    data-value="{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}"
                                    data-alt="qris-opz">
                                    <p class="mb-0 qr-download-instruction">Ketuk gambar QR untuk mengunduh</p>
                                    <canvas id="qr-canvas" style="display:none;"></canvas>
                                    <img id="qr-img" src="{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}"
                                        alt="qris-opz">
                                    <a id="download-qrcode">Download QR Code</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="action-btn-wrapper">
                        <button type="button" id="download-qrcodes" class="otd-reject-btn e1ggruw00"><span>Download QR
                                Code</span></button>
                    </div>
                    <div>
                    </div>
                </div>

                <script src="https://cdn.robotaset.com/assets/js/pages/outstanding.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/common/qrious.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/common/clipboard.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/common/moment.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/common/sweetalert2.min.js"></script>
                <script>
                    function copyContent(el) {
                                    // Copy
                                    new ClipboardJS(el, {
                                        text: function(trigger) {
                                            var element = trigger.previousElementSibling;
                                            return $(element).text().replace(/,/g, '').trim();
                                        }
                                    }).on("success", function(e) {
                                        $(".copied").text(alertMsg.copy_success);
                                        setTimeout(function() {
                                            $(".copied").text("");
                                        }, 3000);
                                    }).on("error", function(e) {
                                        $(".copied").text(alertMsg.copy_failed).css("color", "#D32F2F");
                                        setTimeout(function() {
                                            $(".copied").text("");
                                        }, 3000);
                                    });
                                }

                                function generateQR() {
                                    var el = $("#qrcode");
                                    if (el.length == 1) {
                                        var data = el.data("value");
                                        var alt = el.data("alt");
                                        const qrCanvas = document.getElementById('qr-canvas');
                                        const qr = new QRious({
                                            element: qrCanvas,
                                            value: data,
                                            size: 250,
                                            background: '#ffffff',
                                            foreground: '#000000'
                                        });
                                    }
                                }

                                $(document).ready(function() {
                                    // copy content
                                    copyContent("#copy-number");
                                    copyContent("#copy-amount");

                                    // countdown timer
                                    var element = $("#expiration-countdown");
                                    var ts = element.data("ts");

                                    var x = setInterval(function() {
                                        var now = new Date().getTime();
                                        var distance = ts;

                                        // If the count down is finished, write some text
                                        var hours = "00";
                                        var minutes = "00";
                                        var seconds = "00";

                                            hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                                            minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                                            seconds = Math.floor((distance % (1000 * 60)) / 1000);

                                            hours = hours < 10 ? '0' + hours : hours;
                                            minutes = minutes < 10 ? '0' + minutes : minutes;
                                            seconds = seconds < 10 ? '0' + seconds : seconds;

                                        $(".hours").text(hours);
                                        $(".minutes").text(minutes);
                                        $(".seconds").text(seconds);
                                    }, 1000);


                                    const qrCodeDiv = document.getElementById('qrcode');
                                    qrCodeDiv.style.position = 'relative';

                                    const qrCodeDownload = document.getElementById('download-qrcode');
                                    qrCodeDownload.style.position = 'absolute';
                                    qrCodeDownload.style.width = '100%';
                                    qrCodeDownload.style.height = '100%';
                                    qrCodeDownload.style.color = 'transparent';
                                    qrCodeDownload.style.top = '0';
                                    qrCodeDownload.style.left = '0';

                                    document.getElementById('download-qrcode').addEventListener('click', function() {
                                        fetch('{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}')
                                            .then(resp => resp.blob())
                                            .then(blob => {
                                                const url = window.URL.createObjectURL(blob);
                                                const a = document.createElement('a');
                                                a.style.display = 'none';
                                                a.href = url;
                                                // the filename you want
                                                a.download = 'qrisPayment.png';
                                                document.body.appendChild(a);
                                                a.click();
                                                window.URL.revokeObjectURL(url);
                                            })
                                            .catch(() => alert('An error sorry'));
                                    });

                                    document.getElementById('download-qrcodes').addEventListener('click', function() {
                                        fetch('{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}')
                                            .then(resp => resp.blob())
                                            .then(blob => {
                                                const url = window.URL.createObjectURL(blob);
                                                const a = document.createElement('a');
                                                a.style.display = 'none';
                                                a.href = url;
                                                // the filename you want
                                                a.download = 'qrisPayment.png';
                                                document.body.appendChild(a);
                                                a.click();
                                                window.URL.revokeObjectURL(url);
                                            })
                                            .catch(() => alert('An error sorry'));
                                    });

                                });
                </script>
            </div>
        </div>
    </div>
</form>
@elseif(!$last)
<form id="DepositForm" class="bank-form" action="/api/bank/setDeposit" method="POST">
    @csrf
    <input type="hidden" name="dari_bank"
        value="{{ auth()->user()->nama_bank }} / {{ auth()->user()->nomor_rekening }} / {{ auth()->user()->nama_pemilik }}">
    <div class="info-page-content" data-otd="false" data-wait="false" data-empty="false">
        <div class="account-content">
            <div class="default-wrap">
                @if (session('success'))
                <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">{{
                    session('success') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true"></span>
                    </button>
                </div>
                @endif

                @if (session('error'))
                <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">{{ session('error')
                    }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                @endif
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>
                <div data-area="Deposit_Div" id="Deposit_" style="">
                    <div id="Step1" style="">
                        <div class="textfield-wrap">
                            <div class="qris-dp-note alert alert-primary">
                                Kini telah hadir pembayaran QRIS proses Deposit secara instan</div>
                        </div>
                        <center>
                                <a href="https://iframe04.otomatis.vip/?data=eyJjbGllbnQiOiJ3YXJ1bmd0b3RvODgiLCJsYWJlbCI6IiIsInV1aWQiOiIxNzE5ZDFiMC0xYTNiLTRmMTctYWY0Ny00MzU4NDk0MGFhOTUiLCJiZ2NvbG9yIjoiIzAwMDAwMCIsImJvcmRlcmNvbG9yIjoiI0ZGRkZGRiIsImZvbnRjb2xvciI6IiNGRkZGRkYiLCJtaW4iOjEwMDAsIm1heCI6MTAwMDAwMDAsImZlZSI6NjAwMCwiYm9udXNzaG93Ijp0cnVlLCJib3RoIjpmYWxzZX0=&msg=<?php echo $base64Encoded;?>" target="_blank" class="qris-button" style="
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 12px 24px;
    background: linear-gradient(135deg, #4e54c8, #8f94fb);
    color: white;
    border: none;
    border-radius: 8px;
    font-weight: bold;
    font-size: 16px;
    text-decoration: none;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    margin: 10px 0;
">
    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-right: 8px;">
        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
        <path d="M7 7h4v4H7z"></path>
        <path d="M17 7h.01"></path>
        <path d="M7 17h.01"></path>
        <path d="M17 17h3"></path>
        <path d="M10 7h1"></path>
        <path d="M7 14h1"></path>
        <path d="M14 7h1"></path>
        <path d="M12 12h1"></path>
        <path d="M14 14h3"></path>
    </svg>
    QRIS OTOMATIS
</a>
</center>
<style>
    .qris-button {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 12px 24px;
        background: linear-gradient(135deg, #4e54c8, #8f94fb);
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: bold;
        font-size: 16px;
        text-decoration: none;
        box-shadow: 0 4px 15px rgba(78, 84, 200, 0.6);
        transition: all 0.3s ease;
        margin: 10px 0;
        position: relative;
        overflow: hidden;
        animation: pulse 2s infinite;
    }
    
    .qris-button i {
        margin-right: 10px;
        font-size: 20px;
    }
    
    .qris-button:hover {
        background: linear-gradient(135deg, #3a3f9e, #6a6fc7);
        box-shadow: 0 6px 20px rgba(78, 84, 200, 0.8);
        transform: translateY(-2px);
        animation: none;
    }
    
    .qris-button:active {
        transform: translateY(0);
    }
    
    .qris-button::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: rgba(255, 255, 255, 0.1);
        transform: rotate(45deg);
        animation: shine 3s infinite;
    }
    
    @keyframes pulse {
        0% {
            box-shadow: 0 0 0 0 rgba(78, 84, 200, 0.7);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(78, 84, 200, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(78, 84, 200, 0);
        }
    }
    
    @keyframes shine {
        0% {
            left: -100%;
        }
        20% {
            left: 100%;
        }
        100% {
            left: 100%;
        }
    }
</style>
                        <div class="textfield-wrap">
                            <label for="bankname">Nama Bank</label>
                            <div class="input-field browser-default">
                                <input type="text" id="BankName" name="BankName"
                                    value="{{ strtoupper(auth()->user()->nama_bank) }}" readonly="readonly">
                            </div>
                        </div>
                        <div class="textfield-wrap">
                            <label for="">Nomor Rekening Bank</label>
                            <div class="input-field browser-default">
                                <input type="text" name="AccountNo" id="AccountNo" maxlength="30"
                                    value="{{ censor(auth()->user()->nomor_rekening, 4) }}" readonly="readonly">
                            </div>
                        </div>
                        <div class="textfield-wrap">
                            <label for="">Nama Rekening</label>
                            <div class="input-field browser-default">
                                <input type="text" name="AccountName" id="AccountName" maxlength="30"
                                    value="{{ censor(auth()->user()->nama_lengkap, 2) }}" readonly="readonly">
                            </div>
                        </div>
                        <div class="textfield-wrap">
                            <label for="">Tujuan<span>*</span></label>
                            <div class="select-type">
                                <select id="TransferTo" name="TransferTo" onchange="show();" required>
                                    <option value="">--- Pilih Bank ---</option>
                                    @foreach ($bank as $bks)
                                    <option value="{{ $bks->id }}" code="{{ $bks->nama_bank }}" payment-type="2"
                                        min-dp="20" max-dp="100000">
                                        {{ strtoupper($bks->nama_bank) }}
                                        - {{ $bks->nama_pemilik }} - {{ $bks->nomor_rekening }}</option>
                                    @endforeach
                                </select>
                                <i class="far fa-copy copyText" data-clipboard-text=""></i>
                            </div>
                            <span class="copied"></span>
                        </div>
                        <div class="textfield-wrap">
                            <label for="">Bonus<span></span></label>
                            <div class="select-type">
                                <select id="bonus" name="bonus">
                                    <option value="tanpabonus">--- Pilih Bonus ---</option>
                                    @foreach ($bonus as $bns)
                                    <option value="{{ $bns->id }}">{{ $bns->judul }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="textfield-wrap">
                            <label for="">Nominal Transfer<span>*</span></label>
                            <div class="amount-button">
                                <strong>(Silahkan pilih nominal dari tombol atau masukkan secara
                                    manual)</strong>
                                <ul id="Amtbutton">
                                    <li><input class="btn-amount" type="button" value="50"></li>
                                    <li><input class="btn-amount" type="button" value="200"></li>
                                    <li><input class="btn-amount" type="button" value="1000"></li>
                                </ul>
                            </div>
                            <div data-area="supportAmt">
                                <div class="input-field">
                                    <input type="number" onkeydown="return digits(event)" id="Amount" name="Amount"
                                        value="0" required="required" autofocus="autofocus">
                                </div>
                                <span class="tooltip" data-area="message"></span>
                                <span class="tooltip">Min : <span class="TxtMinimal">0</span> / Max : <span
                                        class="TxtMaximal">0</span></span>
                                <span class="tooltip">IDR 1 = 1,000</span>
                            </div>
                        </div>
                        <div class="textfield-wrap">
                            <label for="">Nominal Asli</label>
                            <div class="input-field">
                                <input type="text" name="RealAmount" id="RealAmount" value="0" readonly="readonly">
                            </div>
                        </div>
                        <div class="textfield-wrap deposit_note">
                            <label for="">Berita</label>
                            <div class="input-field">
                                <textarea id="Note" name="Note" rows="3" placeholder='' maxlength="50"></textarea>
                            </div>
                        </div>
                        <div id="qrisDetails" class="textfield-wrap va_payment_instruction" style="display: none;">
                            <div class="input-field">
                                <div id="vabni" class="payment-wrapper">
                                    <div class="payment-cardbox">
                                        <div class="payment-card-header">
                                        <div class="payment-title">PEMBERITAHUAN PENTING</div>
                                            <div class="payment-bank-logo">
                                            </div>
                                        </div>
                                        <div class="p-16">
                                            <ul class="payment-instruction-list">
                                                <li>Saat transfer diwajibkan menggunakan <span class="bold">KODE UNIK</span>.</li>
                                                <li><span class="bold">CONTOH NOMINAL TRANSFER</span> Senilai 50.666/50.777 </li>
                                                <li>Jika tidak menggunakan<span class="bold"> KODE UNIK </span> maka <span class="bold">DEPOSIT </span> tidak kami proses.</li>
                                                <li>Saat mengisi <span class="bold">FORM DEPOSIT</span> tidak diperlukan <span class="bold"> KODE UNIK</span>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="btn-primary" id="DepositReset" type="reset">Ulangi</button>
                        <button class="btn-primary" id="DepositSubmit" name="Deposit" type="submit">Kirim</button>
                    </div>
                </div>
                <script src="https://cdn.robotaset.com/assets/js/common/axios.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/common/clipboard.min.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/pages/bank_deposit.js"></script>
                <script>
                    function show() {
                                    document.getElementById('qrisDetails').style = '';
                                }
                                var clipboard = new ClipboardJS('.copyText');

                                clipboard.on('success', function(e) {
                                    $(".copied").text(alertMsg.copy_success);
                                    setTimeout(function() {
                                        $(".copied").text("");
                                    }, 3000);
                                    e.clearSelection();
                                });
                                clipboard.on('error', function(e) {
                                    $(".copied").text(alertMsg.copy_failed).css("color", "#D32F2F");
                                    setTimeout(function() {
                                        $(".copied").text("");
                                    }, 3000);
                                    e.clearSelection();
                                });
                </script>
            </div>
        </div>
    </div>
</form>

<script>
    $(document).on("click", ".btn-amount", function() {
                    var totalamount = 0;
                    var amount = $(this).attr("value");
                    var currentamount = $("#Amount").val();
                    currentamount = currentamount == "" ? 0 : currentamount;
                    totalamount = parseInt(currentamount) + parseInt(amount);
                    $("#Amount").val(totalamount);

                    $("#RealAmount").val(formatCurrency(totalamount * 1000));
                });

                $(document).on("keyup", "#Amount", function(e) {
                    var element = $(this);
                    // set new min & max deposit value
                    /*if( selectedBank.hasOwnProperty("mindp") ) {
                    	mindeposit = parseInt(selectedBank.mindp);
                    }
                    if( selectedBank.hasOwnProperty("maxdp") ) {
                    	maxdeposit = parseInt(selectedBank.maxdp);
                    }*/
                    maxdeposit = parseInt($('#MaxDeposit').val());

                    if (element.val() != "") {
                        let currentamount = parseInt(element.val());
                        $("#RealAmount").val(formatCurrency(currentamount * 1000));
                    } else {
                        $("#RealAmount").val("");
                    }
                });


                $("#TransferTo").on("change", function() {
                    // reset
                    clearAmount();
                    $("#Amount").focus();

                    var id = $(this).val();
                    let url = "{{ route('user.norek') }}"
                    $.ajax({
                        type: 'post',
                        url: url,
                        data: {
                            _token: "{{ csrf_token() }}",
                            id: id
                        },
                        success: function(data) {
                            $(".copyText").attr("data-clipboard-text", data.data);
                        },
                    });
                });

                function clearAmount() {
                    $("#Amount").val(0);
                    $("#RealAmount").val(0);
                }
</script>
@else
<form id="DepositForm" class="bank-form" action="/api/bank/setDeposit" method="POST">
    <div class="info-page-content" data-otd="true" data-wait="false" data-empty="true">
        <div class="account-content">
            <div class="default-wrap">
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>Proses deposit sedang dalam proses persetujuan oleh sistem. Mohon menunggu.
            </div>
        </div>
    </div>
</form>
@endif
@endif
@endsection


@section('account')
@if (auth()->user()->nama_bank == 'notset')
<div class="row con_box">
    <div class="account_main info-page-content" data-otd='false' data-wait='false' data-empty='true'>
        <div id="Alert" class="alert  " role="alert" style="display: none;">
        </div>Silahkan isi data bank sebelum melakukan deposit. <br> Anda akan dialihkan ke halaman bank dalam <span
            id="counter">3</span> detik..
        <script src="https://cdn.robotaset.com/assets/js/common/axios.min.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/clipboard.min.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/pages/bank_deposit.js"></script>
        <script>
            var clipboard = new ClipboardJS('.copyText');

                    clipboard.on('success', function(e) {
                        $(".copied").text(alertMsg.copy_success);
                        setTimeout(function() {
                            $(".copied").text("");
                        }, 3000);
                        e.clearSelection();
                    });
                    clipboard.on('error', function(e) {
                        $(".copied").text(alertMsg.copy_failed).css("color", "#D32F2F");
                        setTimeout(function() {
                            $(".copied").text("");
                        }, 3000);
                        e.clearSelection();
                    });
        </script>
    </div>
</div>
@else
<div class="row con_box">
    @if (!empty($last))
    <div class="account_main info-page-content" data-otd='true' data-wait='false' data-empty='true'>
        <div id="Alert" class="alert  " role="alert" style="display: none;">
        </div>
        <div class="finish-payment-wrapper">
            <div class="outstanding-date">
                <div class="please-pay-to">Selesaikan pembayaran dalam</div>
                <p id="expiration-countdown" class="countdown-timer" data-ts="1743176407000"
                    data-date="{{ date('Y-m-d H:i:s', strtotime('+1 day')) }}">
                    <span class="hours">06</span>:<span class="minutes">59</span>:<span class="seconds">30</span>
                </p>
                <p class="due-date-payment">Batas Akhir Pembayaran</p>
                <div class="css-0">
                    <p class="due-date">{{ date('d M Y H:i:s', strtotime('+1 day')) }}</p>
                </div>
            </div>
            <div class="otd-acc-detail">
                <div class="bank-name-row">
                    <div class="bank-name">{{ banksDetails($last->metode)->nama_bank }} -
                        {{ banksDetails($last->metode)->nama_pemilik }}</div>
                    <div class="css-vhe8zj payment-bank-logo">
                        <div class="qris"></div>
                    </div>
                </div>

                <div class="detail-amount">
                    <div class="row-amount">
                        <div class="row-title">Jumlah</div>
                        <div class="row-content">
                            <div class="css-158s7cq">
                                <div class="css-1h9cifw has-amt">{{ number_format($last->total) }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="row-amount">
                        <div class="row-title">Biaya Layanan</div>
                        <div class="row-content">
                            <div class="css-158s7cq">
                                <div class="css-1h9cifw has-amt">
                                    <span>0</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row-amount">
                        <div class="row-title">Total Pembayaran</div>
                        <div class="row-content">
                            <div class="css-158s7cq">
                                <div id="copy-amount" data-clipboard-target="#total-amount" class="copy-code"><i
                                        class="fas fa-copy"></i></div>
                                <div id="total-amount" class="css-1h9cifw has-amt">{{ number_format($last->total) }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="text-center">
                        <div id="qrcode" class="qr-img"
                        data-value="{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}"
                        data-alt="qris-opz">
                        <p class="mb-0 qr-download-instruction">Ketuk gambar QR untuk mengunduh</p>
                        <canvas id="qr-canvas" style="display:none;"></canvas>
                        <img id="qr-img" src="{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}"
                            alt="qris-opz">
                        <a id="download-qrcode">Download QR Code</a>
                    </div>
                    </div>
                </div>
            </div>

            <div class="action-btn-wrapper">
                <button type="button" id="download-qrcodes" class="otd-reject-btn e1ggruw00"><span>Download QR
                        Code</span></button>
            </div>
            <div>
            </div>
        </div>

        <script src="https://cdn.robotaset.com/assets/js/pages/outstanding.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/qrious.min.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/clipboard.min.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/moment.min.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/sweetalert2.min.js"></script>
        <script>
            function copyContent(el) {
                            // Copy
                            new ClipboardJS(el, {
                                text: function(trigger) {
                                    var element = trigger.previousElementSibling;
                                    return $(element).text().replace(/,/g, '').trim();
                                }
                            }).on("success", function(e) {
                                $(".copied").text(alertMsg.copy_success);
                                setTimeout(function() {
                                    $(".copied").text("");
                                }, 3000);
                            }).on("error", function(e) {
                                $(".copied").text(alertMsg.copy_failed).css("color", "#D32F2F");
                                setTimeout(function() {
                                    $(".copied").text("");
                                }, 3000);
                            });
                        }

                        function generateQR() {
                            var el = $("#qrcode");
                            if (el.length == 1) {
                                var data = el.data("value");
                                var alt = el.data("alt");
                                const qrCanvas = document.getElementById('qr-canvas');
                                const qr = new QRious({
                                    element: qrCanvas,
                                    value: data,
                                    size: 250,
                                    background: '#ffffff',
                                    foreground: '#000000'
                                });
                            }
                        }

                        $(document).ready(function() {
                            // copy content
                            copyContent("#copy-number");
                            copyContent("#copy-amount");

                            // countdown timer
                            var element = $("#expiration-countdown");
                            var ts = element.data("ts");

                            var x = setInterval(function() {
                                var now = new Date().getTime();
                                var distance = ts - now;

                                // If the count down is finished, write some text
                                var hours = "00";
                                var minutes = "00";
                                var seconds = "00";

                                if (distance < 1000) {
                                    clearInterval(x);
                                    setTimeout(function() {
                                        location.reload();
                                    }, 500);
                                } else {
                                    hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                                    minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                                    seconds = Math.floor((distance % (1000 * 60)) / 1000);

                                    hours = hours < 10 ? '0' + hours : hours;
                                    minutes = minutes < 10 ? '0' + minutes : minutes;
                                    seconds = seconds < 10 ? '0' + seconds : seconds;
                                }

                                $(".hours").text(hours);
                                $(".minutes").text(minutes);
                                $(".seconds").text(seconds);
                            }, 1000);


                            const qrCodeDiv = document.getElementById('qrcode');
                            qrCodeDiv.style.position = 'relative';

                            const qrCodeDownload = document.getElementById('download-qrcode');
                            qrCodeDownload.style.position = 'absolute';
                            qrCodeDownload.style.width = '100%';
                            qrCodeDownload.style.height = '100%';
                            qrCodeDownload.style.color = 'transparent';
                            qrCodeDownload.style.top = '0';
                            qrCodeDownload.style.left = '0';

                            document.getElementById('download-qrcode').addEventListener('click', function() {
                                fetch('{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}')
                                    .then(resp => resp.blob())
                                    .then(blob => {
                                        const url = window.URL.createObjectURL(blob);
                                        const a = document.createElement('a');
                                        a.style.display = 'none';
                                        a.href = url;
                                        // the filename you want
                                        a.download = 'qrisPayment.png';
                                        document.body.appendChild(a);
                                        a.click();
                                        window.URL.revokeObjectURL(url);
                                    })
                                    .catch(() => alert('An error sorry'));
                            });

                            document.getElementById('download-qrcodes').addEventListener('click', function() {
                                fetch('{{ env('AWS_URL') }}{{ banksDetails($last->metode)->icon }}')
                                    .then(resp => resp.blob())
                                    .then(blob => {
                                        const url = window.URL.createObjectURL(blob);
                                        const a = document.createElement('a');
                                        a.style.display = 'none';
                                        a.href = url;
                                        // the filename you want
                                        a.download = 'qrisPayment.png';
                                        document.body.appendChild(a);
                                        a.click();
                                        window.URL.revokeObjectURL(url);
                                    })
                                    .catch(() => alert('An error sorry'));
                            });

                        });
        </script>
    </div>
</div>
@elseif(!$last)
<div class="account_main info-page-content" data-otd='false' data-wait='false' data-empty='false'>
    <div id="Alert" class="alert  " role="alert" style="display: none;">
    </div>
    @if (session('success'))
    <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
    </div>
</div>
@endif

@if (session('error'))
<div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">
    {{ session('error') }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
</div>
</div>
@endif
<div class="col-7 con_item" style="display: block;">
    <h4>Deposit</h4>
    <form id="DepositForm" class="bank-form" action="/api/bank/setDeposit" method="POST">
        @csrf
        <input type="hidden" name="dari_bank"
            value="{{ auth()->user()->nama_bank }} / {{ auth()->user()->nomor_rekening }} / {{ auth()->user()->nama_pemilik }}">
        <div class="form-group">
            <input type="hidden" id="MinDeposit" name="MinDeposit" value="20">
            <input type="hidden" id="MaxDeposit" name="MaxDeposit" value="100000">
            <div class="clearfix">
                <div class="qris-dp-note alert alert-primary">
                    Kini telah hadir pembayaran QRIS proses Deposit secara instan</div>
            </div>
            <div class="clearfix">
                <label for="BankId">Nama Bank<span>*</span></label>
                <span class="info_type" id="BankName">BRI</span>
                <input type="hidden" id="BankId" value="{{ auth()->user()->nama_bank }}">
            </div>

            <div class="clearfix">
                <label for="AccountNo">Nomor Rekening Bank<span>*</span></label>
                <span class="info_type" id="AccountNo">{{ censor(auth()->user()->nomor_rekening, 4) }}</span>
            </div>

            <div class="clearfix">
                <label for="AccountName">Nama Rekening<span>*</span></label>
                <span class="info_type" id="AccountName">{{ censor(auth()->user()->nama_pemilik, 4) }}</span>
            </div>

            <div class="clearfix">
                <label for="TransferTo">Tujuan<span>*</span></label>
                <div class="form_group_category textfield-wrap">
                    <select id="TransferTo" name="TransferTo" required>
                        @foreach ($bank as $bks)
                        <option value="{{ $bks->id }}" code="{{ $bks->nama_bank }}" payment-type="2" min-dp="20"
                            max-dp="100000">
                            {{ strtoupper($bks->nama_bank) }}
                            - {{ $bks->nama_pemilik }} - {{ $bks->nomor_rekening }}</option>
                        @endforeach
                    </select>
                    <i class="fas fa-copy copyText" data-clipboard-text=""></i>
                    <span class="copied tooltip"></span>
                </div>
            </div>

            <div class="clearfix">
                <label for="Amount">Nominal Transfer<span>*</span></label>
                <div class="form_group_category textfield-wrap">
                    <input type="number" onkeydown="return digits(event)" id="Amount" name="Amount" value="0"
                        required="required" autofocus="autofocus">
                    <span class="tooltip" data-area="message"></span>
                </div>
            </div>

            <div class="clearfix deduction-amount" style="display:none">
                <label for="DeductionFinalAmount">Setelah Potongan</label>
                <div class="form_group_category textfield-wrap">
                    <input type="number" id="DeductionFinalAmount" value="0" disabled="disabled">
                    <span class="tooltip" data-area="message"></span>
                </div>
            </div>

            <div class="clearfix">
                <label for="">Nominal Asli</label>
                <div class="form_group_category">
                    <input type="text" id="RealAmount" value="0" readonly="readonly">
                </div>
            </div>

            <div class="clearfix" style="margin-bottom:10px">
                <label for="">&nbsp;</label>
                <div class="form_group_category">
                    <p class="explain_text">
                        <span>
                            ( Min: <span class="TxtMinimal"></span> /
                            Max: <span class="TxtMaximal"></span> )
                        </span>
                    </p>
                    <p class="explain_text"><span>1 = IDR 1,000</span></p>
                </div>
            </div>

            <div class="clearfix deposit_note">
                <label for="">Berita</label>
                <div class="form_group_category">
                    <textarea id="Note" name="Note" rows="3" placeholder='' maxlength="50"></textarea>
                </div>
            </div>

            <div class="clearfix va_payment_instruction" style="display:none">
                <label>&nbsp;</label>
                <div class="form_group_category">
                    <div id="vabni" class="payment-wrapper">
                        <div class="mb-16">
                            <div class="payment-cardbox">
                                <div class="payment-card-header">
                                    <div class="payment-title"></div>
                                    <div class="payment-bank-logo">
                                        <div class="vabni"></div>
                                    </div>
                                </div>
                                <div class="p-16">
                                    <ul class="payment-instruction-list">
                                        <li><span class="bold">Kode pembayaran</span> akan muncul setelah
                                            klik "Kirim".</li>
                                        <li><span class="bold">Tidak disarankan</span> bayar melalui bank
                                            lain agar transaksi dapat diproses tanpa kendala.</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <ul class="btn_type clear-both">
            <li><input class="btn_default" type="reset" value='Ulangi'></li>
            <li><input type="submit" id="DepositSubmit" value='Kirim'></li>
        </ul>
    </form>
</div>
<script src="https://cdn.robotaset.com/assets/js/common/axios.min.js"></script>
<script src="https://cdn.robotaset.com/assets/js/common/clipboard.min.js"></script>
<script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
<script src="https://cdn.robotaset.com/assets/js/pages/bank_deposit.js"></script>
<script>
    var clipboard = new ClipboardJS('.copyText');

            clipboard.on('success', function(e) {
                $(".copied").text(alertMsg.copy_success);
                setTimeout(function() {
                    $(".copied").text("");
                }, 3000);
                e.clearSelection();
            });
            clipboard.on('error', function(e) {
                $(".copied").text(alertMsg.copy_failed).css("color", "#D32F2F");
                setTimeout(function() {
                    $(".copied").text("");
                }, 3000);
                e.clearSelection();
            });
</script>
</div>
</div>
@else
<div class="account_main info-page-content" data-otd='true' data-wait='false' data-empty='true'>
    <div id="Alert" class="alert  " role="alert" style="display: none;">
    </div>Proses deposit sedang dalam proses persetujuan oleh sistem. Mohon menunggu.
</div>
</div>
@endif
@endif

<div class="account_list con_box embed_account_list">
    <div class="mainNav_width ">
        <h4>Riwayat</h4>
        <form id="ReportsubmitFrm" action="/api/bank/transactionHistory" method="POST">
            <input type="hidden" id="type" name="type" value="deposit">

            <ul class="date_list input-daterange">
                <li><strong>Tanggal</strong></li>
                <li>
                    <input type="text" class="selection hasDatepicker" id="startDate" name="startDate"
                        value="27-03-2025" readonly="readonly">
                </li>
                <li><i class="fa fa-chevron-right"></i></li>
                <li>
                    <input type="text" class="selection hasDatepicker" id="endDate" name="endDate" value="27-03-2025"
                        readonly="readonly">
                </li>
                <li>
                    <button type="button" id="ReportSubmitButton">Cari</button>
                </li>
                <li id="loading" style="display:none;">
                    <i class="fa fa-spinner fa-pulse fa-fw"></i>
                </li>
            </ul>
        </form>

        <table class="account_info" id="TableHistory">
            <thead>
                <tr>
                    <th width="60">&nbsp;#&nbsp;</th>
                    <th width="150">Tanggal</th>
                    <th width="100">Event</th>
                    <th>Deskripsi</th>
                    <th width="130">Nominal Transfer</th>
                    <th width="130">Status</th>
                    <th>Catatan</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
</div>
<script>
    $(document).on('click', '.copyRef', function() {
            var id = $(this).data('clipboard-target');
            copyText(id);
            var target = $(this).closest('.trx-refno').next('.copied');
            target.text('Berhasil menyalin');
            setTimeout(function() {
                target.text('');
            }, 3000);
        });
</script>
<script>
    $(document).on("keyup", "#Amount", function(e) {
            var element = $(this);
            // set new min & max deposit value
            /*if( selectedBank.hasOwnProperty("mindp") ) {
            	mindeposit = parseInt(selectedBank.mindp);
            }
            if( selectedBank.hasOwnProperty("maxdp") ) {
            	maxdeposit = parseInt(selectedBank.maxdp);
            }*/
            maxdeposit = parseInt($('#MaxDeposit').val());

            if (element.val() != "") {
                let currentamount = parseInt(element.val());
                $("#RealAmount").val(formatCurrency(currentamount * 1000));
            } else {
                $("#RealAmount").val("");
            }
        });

        $(document).ready(function() {
            // Copy the Reference No.
            $(document).on('click', '.copyRef', function() {
                var id = $(this).data('clipboard-target');
                copyText(id);
                var target = $(this).closest('.trx-refno').next('.copied');
                target.text('Berhasil menyalin');
                setTimeout(function() {
                    target.text('');
                }, 3000);
            });
        });



        $("#ReportSubmitButton").on("click", function() {
            // play loading
            $("#loading").show();
            $.ajax({
                type: "POST",
                url: "{{ route('transaksi.transaction_history') }}",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    $("#loading").hide();
                    $(".account_info > tbody").html(response);
                }
            });
        });
</script>
@endsection
