@extends('frontend.layouts.main')
@section('content')
<div class="page-header-title">
    <h3>Bank</h3>
</div>
<div class="account-structure">
    <ul class="account-menu" id="account_menu">
        <li><a href="/bank/account">Akun Saya</a></li>
        <li><a href="/bank/deposit">Deposit</a></li>
        <li><a href="/bank/history">History</a></li>
        <li><a href="/bank/withdraw" class="active">Withdraw</a></li>
    </ul>
</div>
@if(auth()->user()->nama_bank == 'notset')
<form id="WithdrawForm" class="bank-form" action="/api/bank/setWithdraw" method="POST">
    <div class="info-page-content" data-otd="false" data-wait="false" data-empty="true">
        <div class="account-content">
            <div class="default-wrap">
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>Silahkan isi data bank sebelum melakukan withdraw. <br> Anda akan dialihkan ke halaman bank dalam
                <span id="counter">3</span> detik..<script src="https://cdn.robotaset.com/assets/js/pages/Bank.js">
                </script>
                <script src="https://cdn.robotaset.com/assets/js/pages/240715_bank-withdraw.js"></script>
            </div>
        </div>
    </div>
</form>
@else
<form id="WithdrawForm" class="bank-form" action="/api/bank/setWithdraw" method="POST">
    @csrf
    <input type="hidden" name="bank" value="{{ auth()->user()->nama_bank }} / {{ auth()->user()->nomor_rekening }} / {{ auth()->user()->nama_pemilik }}">
    <div class="info-page-content" data-otd="false" data-wait="false" data-empty="false">
        <div class="account-content">
            <div class="default-wrap">
                @if (session('success'))
                <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">{{ session('success')
                    }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                @endif

                @if (session('error'))
                <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">{{ session('error')
                    }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                @endif
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div><input type="hidden" id="MinWithdraw" name="MinWithdraw" value="50">
                <input type="hidden" id="MaxWithdraw" name="MaxWithdraw" value="10000000">

                <div class="textfield-wrap">
                    <label for="">Saldo Saat Ini</label>
                    <div class="input-field browser-default">
                        <input type="text" id="CurrentBalance" data-balance="0" value="{{ number_format(auth()->user()->balance,2,",", ".") }} K" readonly="readonly">
                    </div>
                </div>
                <div class="textfield-wrap">
                    <label for="">Nominal Withdraw<span>*</span></label>
                    <div class="input-field">
                        <input type="number" min="50" max="100000" onkeydown="return digits(event)" name="Amount"
                            id="Amount" required="required">
                    </div>
                    <span class="tooltip" data-area="message"></span>
                    <span class="tooltip">Min : 50 / Max : 100,000</span>
                    <span class="tooltip">IDR 1 = 1,000</span>
                </div>
                <div class="textfield-wrap">
                    <label for="">Nominal Asli</label>
                    <div class="input-field browser-default">
                        <input type="text" id="RealAmount" name="RealAmount" value="0" readonly="readonly">
                    </div>
                </div>
                <div class="textfield-wrap">
                    <label for="bankname">Nama Bank</label>
                    <div class="input-field browser-default">
                        <input type="text" id="BankName" name="BankName" value="{{ strtoupper(auth()->user()->nama_bank) }}"
                            readonly="readonly">
                    </div>
                </div>
                <div class="textfield-wrap">
                    <label for="">Nomor Rekening Bank</label>
                    <div class="input-field browser-default">
                        <input type="text" name="AccountNo" id="AccountNo" maxlength="30"
                            value="{{ censor(auth()->user()->nomor_rekening,4) }}" readonly="readonly">
                    </div>
                </div>
                <div class="textfield-wrap">
                    <label for="">Nama Rekening</label>
                    <div class="input-field browser-default">
                        <input type="text" name="AccountName" id="AccountName" maxlength="30"
                            value="{{ censor(auth()->user()->nama_lengkap,2) }}" readonly="readonly">
                    </div>
                </div>

                <button class="btn-primary" type="submit" id="WithdrawSubmit">Kirim</button>
                <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/pages/240715_bank-withdraw.js"></script>
            </div>
        </div>
    </div>
</form>
<script>
    $(document).on("keyup", "#Amount", function(e) {
			var element = $(this);
			// set new min & max deposit value
			/*if( selectedBank.hasOwnProperty("mindp") ) {
				mindeposit = parseInt(selectedBank.mindp);
			}
			if( selectedBank.hasOwnProperty("maxdp") ) {
				maxdeposit = parseInt(selectedBank.maxdp);
			}*/
			maxdeposit = parseInt($('#MaxDeposit').val());

			if( element.val() != "" ) {
				let currentamount = parseInt(element.val());
				$("#RealAmount").val( formatCurrency(currentamount * 1000) );
			} else {
				$("#RealAmount").val("");
			}
		});
</script>
@endif
@endsection


@section('account')

@if(auth()->user()->nama_bank == 'notset')
<div class="row con_box">
    <div class="account_main info-page-content" data-otd='false' data-wait='false' data-empty='true'>
        <div id="Alert" class="alert  " role="alert" style="display: none;">
        </div>Silahkan isi data bank sebelum melakukan withdraw. <br> Anda akan dialihkan ke halaman bank dalam
        <span id="counter">3</span> detik..
        <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/pages/240715_bank-withdraw.js"></script>
    </div>
</div>
@else
<div class="row con_box">
    <div class="account_main info-page-content" data-otd='false' data-wait='false' data-empty='false'>
        @if (session('success'))
        <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">{{ session('success')
            }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>
        </div>
        @endif

        @if (session('error'))
        <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">{{ session('error')
            }}<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>
        </div>
        @endif
        <div id="Alert" class="alert  " role="alert" style="display: none;">
        </div>
        <div class="col-7 con_item" style="display: block;">
            <h4>Withdraw</h4>
            <form id="WithdrawForm" class="bank-form" action="/api/bank/setWithdraw" method="POST">
                @csrf
                <input type="hidden" name="bank" value="{{ auth()->user()->nama_bank }} / {{ auth()->user()->nomor_rekening }} / {{ auth()->user()->nama_pemilik }}">
                <div class="form-group">
                    <input type="hidden" id="MinWithdraw" name="MinWithdraw" value="50">
                    <input type="hidden" id="MaxWithdraw" name="MaxWithdraw" value="{{ number_format(auth()->user()->balance/1000) }}">

                    <label for="BankId">Nama Bank<span>*</span></label>
                    <span class="info_type" id="BankName">{{ strtoupper(auth()->user()->nama_bank) }}</span>

                    <label for="AccountNo">Nomor Rekening Bank<span>*</span></label>
                    <span class="info_type" id="AccountNo">{{ censor(auth()->user()->nomor_rekening,4) }}</span>

                    <label for="AccountName">Nama Rekening<span>*</span></label>
                    <span class="info_type" id="AccountName">{{ censor(auth()->user()->nama_lengkap,4) }}</span>

                    <label for="">Saldo Saat Ini</label>
                    <span class="info_type" id="CurrentBalance" data-balance="{{ number_format(auth()->user()->balance/1000) }}">{{ number_format(auth()->user()->balance/1000) }}</span>

                    <label for="">Nominal Withdraw<span>*</span></label>
                    <div class="deposit_content textfield-wrap">
                        <input type="number" min="50" max="{{ number_format(auth()->user()->balance/1000) }}" onkeydown="return digits(event)" name="Amount"
                            id="Amount" required="required">
                        <span class="tooltip" data-area="message"></span>
                    </div>

                    <label for="">Nominal Asli</label>
                    <div class="form_group_category">
                        <input type="text" id="RealAmount" value="0" readonly="readonly">
                        <p class="explain_text"><span>(Min: 50 / Max: 100,000)</span></p>
                        <p class="explain_text"><span>IDR 1 = 1,000</span></p>
                    </div>

                </div>
                <ul class="btn_type">
                    <li><input type="submit"></li>
                </ul>
            </form>
        </div>

        <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/pages/240715_bank-withdraw.js"></script>
    </div>
</div>
@endif

<div class="account_list con_box embed_account_list">
    <div class="mainNav_width ">
        <h4>Riwayat</h4>
        <form id="ReportsubmitFrm" action="/api/bank/transactionHistory" method="POST">
            <input type="hidden" id="type" name="type" value="withdraw">

            <ul class="date_list input-daterange">
                <li><strong>Tanggal</strong></li>
                <li>
                    <input type="text" class="selection hasDatepicker" id="startDate" name="startDate"
                        value="27-03-2025" readonly="readonly">
                </li>
                <li><i class="fa fa-chevron-right"></i></li>
                <li>
                    <input type="text" class="selection hasDatepicker" id="endDate" name="endDate"
                        value="27-03-2025" readonly="readonly">
                </li>
                <li>
                    <button type="button" id="ReportSubmitButton">Cari</button>
                </li>
                <li id="loading" style="display:none;">
                    <i class="fa fa-spinner fa-pulse fa-fw"></i>
                </li>
            </ul>
        </form>

        <table class="account_info" id="TableHistory">
            <thead>
                <tr>
                    <th width="60">&nbsp;#&nbsp;</th>
                    <th width="150">Tanggal</th>
                    <th width="100">Event</th>
                    <th>Deskripsi</th>
                    <th width="130">Nominal Transfer</th>
                    <th width="130">Status</th>
                    <th>Catatan</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
</div>
<script>
    $(document).on('click', '.copyRef', function() {
		var id = $(this).data('clipboard-target');
		copyText(id);
		var target = $(this).closest('.trx-refno').next('.copied');
		target.text('Berhasil menyalin');
		setTimeout(function() {
			target.text('');
		}, 3000);
	});
</script>
<script>
    $(document).ready(function() {
		// Copy the Reference No.
		$(document).on('click', '.copyRef', function() {
			var id = $(this).data('clipboard-target');
			copyText(id);
			var target = $(this).closest('.trx-refno').next('.copied');
			target.text('Berhasil menyalin');
			setTimeout(function() {
				target.text('');
			}, 3000);
		});
	});



    $("#ReportSubmitButton").on("click", function() {
		// play loading
		$("#loading").show();
        $.ajax({
            type: "POST",
            url: "{{ route('transaksi.transaction_history') }}",
            data: { _token: "{{ csrf_token() }}"},
            success: function (response) {
                $("#loading").hide();
                $(".account_info > tbody").html(response);
            }
        });
	});
</script>
@endsection
