@extends('gameloby.layouts.main')
@section('content')
<main>
    <div class="container">
        <div class="global-title global-title-black">
            <div class="icon-market-game" data-bs-toggle="dropdown">
                <img src="{{ $result->logo }}" class="active-img-bounce">
                <h4 class="ml-2">{{ $result->title }}</h4>
            </div>

            <div class="dropdown-menu dropdown-menu-market">
                <div class="market-draw">
                    <div class="market-draw__list">
                        <div class="row justify-content-center">

                            @foreach (togels() as $det)
                            <div class="col-lg-2 col-md-3 col-4 px-2">
                                <div class="market-draw-item">
                                    <img src="{{ $det->logo }}">
                                    <span class="d-block font-weight-bold market-name">{{ $det->title }}</span>
                                    <a href="{{ route('games.play',$det->slug) }}">
                                        <button type="button" class="custom-btn color-secondary custom-sm"><i
                                                class="fa fa-play-circle"></i><span trs="play">Main
                                                Game</span></button>
                                    </a>
                                </div>
                            </div>
                            @endforeach


                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="market-timer">
            <div class="market-timer__counter">
                <div class="counter-result">
                    <div class="row d-flex text-start">
                        <div class="fs-p8r fw-bolder" trs="lastResultLive">Keluaran Terakhir</div>

                        <div class="col-sm order-1">
                            <div class="result-title">1st</div>
                            <h1>{{ $result->keluaran }}</h1>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="custom-breadcrumb" aria-label="breadcrumb">
            <div class="dropdown dropdown-info-all new-grid-test">

                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i
                        class="fa fa-question-circle me-1"></i><span trs="marketInfo">Info Pasaran</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="market-timer__container">
                        <div class="market-timer-content">
                            <div class="info-list">
                                <div class="item">
                                    <div class="title" trs="undian">Jam Undian</div>
                                    <div class="subtitle">: {{ $result->buka }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i class="fa fa-question-circle"></i><span
                        trs="gamesInfo">Info Permainan</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="custom-table">
                        <div class="custom-table__header" trs="gamesInfo">Info Permainan</div>
                        <table id="table_game_terms" class="stripe cell-border dataTable custom-table-game-info"
                            cellspacing="0" width="100%" data-level="1" data-role="Digit" section="10791" dt-c="1">
                            <thead>
                                <tr>
                                    <th class="sorting sorting_asc" tabindex="0" aria-controls="table_game_terms"
                                        rowspan="1" colspan="1" style="width: 68px;" aria-sort="ascending"
                                        aria-label="Desc: activate to sort column descending">Desc</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 89px;"
                                        aria-label="4D: activate to sort column ascending">4D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 99px;"
                                        aria-label="3D: activate to sort column ascending">3D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 102px;"
                                        aria-label="2D: activate to sort column ascending">2D</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Diskon</td>
                                    <td>66%</td>
                                    <td>59%</td>
                                    <td>29%</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Kei</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td>-</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Max Bet</td>
                                    <td>Rp&nbsp;200.000</td>
                                    <td>Rp&nbsp;1.000.000</td>
                                    <td>Rp&nbsp;5.000.000</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Min Bet</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Prize</td>
                                    <td>3000x</td>
                                    <td>400x</td>
                                    <td>70x</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="global-bet">
    <div class="global-bet__header text-center">Pasang Nomor Anda</div>
    <div class="global-bet__body">
        <div class="bet-title text-center">
            <div class="block-bet-title">
                <select class="select-discount" aria-label="Default select example">
                    <option disc="1" selected trs="diskon">Diskon</option>
                    <option disc="0" trs="noDisc">Tanpa Diskon</option>
                </select>
                <h6>
                    <span trs="game">Permainan</span> 50 50 - {{ $result->title }} - 
                    <span trs="periode">Periode</span> {{ $result->periode }}
                </h6>
            </div>
        </div>

        <div class="mb-4">
            <table class="table table-bordered fifty-table">
                <thead>
                    <tr>
                        <th>Taruhan</th>
                        <th>Posisi</th>
                        <th>Jumlah Taruhan</th>
                        <th>Kei</th>
                        <th>Total Bayar</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $bets = ['As','Kop','Kepala','Ekor'];
                        $positions = ['Besar','Kecil','Ganjil','Genap'];
                        $kei = 3;
                    @endphp

                    @foreach($bets as $bet)
                        @foreach($positions as $pos)
                        <tr>
                            <td>{{ $bet }}</td>
                            <td>{{ $pos }}</td>
                            <td><input type="number" class="bet-input form-control" min="0" value="0"></td>
                            <td class="kei-cell">{{ $kei }}%</td>
                            <td class="total-bayar">0</td>
                        </tr>
                        @endforeach
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="4" class="text-end">Grand Total:</th>
                        <th class="grand-total">0</th>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div class="text-center mt-3">
            <button id="button-submit-fifty" class="custom-btn color-primary btn-secondary">
                <i class="fa fa-check-circle"></i> Konfirmasi Taruhan
            </button>
        </div>
    </div>
</div>

@push('script')
<script>
$(document).ready(function() {

    const minBet = parseFloat({{ $result->min_bet ?? 0 }});
    const maxBet = parseFloat({{ $result->max_bet ?? 0 }});

    function updateGrandTotal(table) {
        let total = 0;
        table.find("tbody tr").each(function(){
            let bet = parseFloat($(this).find(".bet-input").val()) || 0;
            let keiPercent = parseFloat($(this).find(".kei-cell").text().replace('%','')) || 0;
            let bayar = bet + (bet * keiPercent / 100);
            $(this).find(".total-bayar").text(bayar.toFixed(0));
            total += bayar;
        });
        table.find(".grand-total").text(total.toFixed(0));
    }

    // Tambahkan Min/Max info di atas input taruhan
    $(".bet-input").each(function(){
        $(this).before(`<div class="bet-limit-info" style="font-size:12px; color:#888;">Min Bet: ${minBet} | Max Bet: ${maxBet}</div>`);
    });

    // Validasi min/max saat input berubah
    $(document).on("input blur", ".bet-input", function(){
        let bet = parseFloat($(this).val()) || 0;
        if(bet < minBet){
            $(this).val(minBet);
            bet = minBet;
        }
        if(bet > maxBet){
            $(this).val(maxBet);
            bet = maxBet;
        }

        let table = $(this).closest("table");
        updateGrandTotal(table);
    });

    // Update total saat input berubah
    $(document).on("input", ".bet-input", function(){
        let table = $(this).closest("table");
        updateGrandTotal(table);
    });

    // Submit semua taruhan
    $("#button-submit-fifty").on("click", function(){
        let table = $(".fifty-table");
        let betsData = [];

        table.find("tbody tr").each(function(){
            let row = $(this);
            let betAmount = parseFloat(row.find(".bet-input").val()) || 0;

            if(betAmount < minBet) betAmount = minBet;
            if(betAmount > maxBet) betAmount = maxBet;
            row.find(".bet-input").val(betAmount);

            if(betAmount > 0){
                let keiPercent = parseFloat(row.find(".kei-cell").text().replace('%','')) || 0;
                let totalBayar = betAmount + (betAmount * keiPercent / 100);
                betsData.push({
                    bet: row.find("td:first").text(),
                    position: row.find("td:nth-child(2)").text(),
                    betAmount: betAmount,
                    totalBayar: totalBayar
                });
                row.find(".total-bayar").text("Proses...");
            }
        });

        if(betsData.length === 0){
            return; // Tanpa alert
        }

        $.ajax({
            url: "{{ route('games.taruhan') }}",
            type: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                type: "50 50",
                market: "{{ $result->title }}",
                bets: betsData
            },
            success: function(res){
                table.find("tbody tr").each(function(index){
                    if(betsData[index]){
                        $(this).find(".total-bayar").text(betsData[index].totalBayar.toFixed(0));
                    }
                });
                new Notify({ text: res.message, status: "success", autoclose: true, effect: "slide" });
                updateGrandTotal(table);
            },
            error: function(err){
                table.find("tbody tr").each(function(){
                    $(this).find(".total-bayar").text("Gagal");
                });
                new Notify({ text: err.responseJSON?.message ?? 'Error', status: "error", autoclose: true, effect: "slide" });
            }
        });
    });

});
</script>

@endpush





