@extends('gameloby.layouts.main')
@section('content')
<main>
    <div class="container">
        <div class="global-title global-title-black">
            <div class="icon-market-game" data-bs-toggle="dropdown">
                <img src="{{ $result->logo }}" class="active-img-bounce">
                <h4 class="ml-2">{{ $result->title }}</h4>
            </div>

            <div class="dropdown-menu dropdown-menu-market">
                <div class="market-draw">
                    <div class="market-draw__list">
                        <div class="row justify-content-center">

                            @foreach (togels() as $det)
                            <div class="col-lg-2 col-md-3 col-4 px-2">
                                <div class="market-draw-item">
                                    <img src="{{ $det->logo }}">
                                    <span class="d-block font-weight-bold market-name">{{ $det->title }}</span>
                                    <a href="{{ route('games.play',$det->slug) }}">
                                        <button type="button" class="custom-btn color-secondary custom-sm"><i
                                                class="fa fa-play-circle"></i><span trs="play">Main
                                                Game</span></button>
                                    </a>
                                </div>
                            </div>
                            @endforeach


                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="market-timer">
            <div class="market-timer__counter">
                <div class="counter-result">
                    <div class="row d-flex text-start">
                        <div class="fs-p8r fw-bolder" trs="lastResultLive">Keluaran Terakhir</div>

                        <div class="col-sm order-1">
                            <div class="result-title">1st</div>
                            <h1>{{ $result->keluaran }}</h1>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="custom-breadcrumb" aria-label="breadcrumb">
            <div class="dropdown dropdown-info-all new-grid-test">

                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i
                        class="fa fa-question-circle me-1"></i><span trs="marketInfo">Info Pasaran</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="market-timer__container">
                        <div class="market-timer-content">
                            <div class="info-list">
                                <div class="item">
                                    <div class="title" trs="undian">Jam Undian</div>
                                    <div class="subtitle">: {{ $result->buka }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i class="fa fa-question-circle"></i><span
                        trs="gamesInfo">Info Permainan</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="custom-table">
                        <div class="custom-table__header" trs="gamesInfo">Info Permainan</div>
                        <table id="table_game_terms" class="stripe cell-border dataTable custom-table-game-info"
                            cellspacing="0" width="100%" data-level="1" data-role="Digit" section="10791" dt-c="1">
                            <thead>
                                <tr>
                                    <th class="sorting sorting_asc" tabindex="0" aria-controls="table_game_terms"
                                        rowspan="1" colspan="1" style="width: 68px;" aria-sort="ascending"
                                        aria-label="Desc: activate to sort column descending">Desc</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 89px;"
                                        aria-label="4D: activate to sort column ascending">4D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 99px;"
                                        aria-label="3D: activate to sort column ascending">3D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 102px;"
                                        aria-label="2D: activate to sort column ascending">2D</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Diskon</td>
                                    <td>66%</td>
                                    <td>59%</td>
                                    <td>29%</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Kei</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td>-</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Max Bet</td>
                                    <td>Rp&nbsp;200.000</td>
                                    <td>Rp&nbsp;1.000.000</td>
                                    <td>Rp&nbsp;5.000.000</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Min Bet</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Prize</td>
                                    <td>3000x</td>
                                    <td>400x</td>
                                    <td>70x</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="global-bet">
    <div class="global-bet__header text-center" trs="betNumber">Pasang Nomor Anda</div>
    <div class="global-bet__body">
        <div class="bet-title text-center">
            <h6>Bbfs - {{ $result->title }} - Periode {{ $result->periode }}</h6>
            <h6 trs="bbfs">Kombinasi Angka (2-5 digit)</h6>
        </div>

        <div class="bet-content d-flex align-items-center mb-2">
            <input type="text" id="game-digit-input" class="bet-input-digit form-control me-2"
                placeholder="xxxxx" maxlength="5" value="">
        </div>

        <div class="bet-content d-flex align-items-center mb-2 gap-2">
            <div>
                <label for="bet-4d" class="form-label">Nominal 4D</label>
                <input id="bet-4d" class="form-control" type="number" placeholder="Taruhan 4D" min="0" value="">
            </div>
            <div>
                <label for="bet-3d" class="form-label">Nominal 3D</label>
                <input id="bet-3d" class="form-control" type="number" placeholder="Taruhan 3D" min="0" value="">
            </div>
            <div>
                <label for="bet-2d" class="form-label">Nominal 2D</label>
                <input id="bet-2d" class="form-control" type="number" placeholder="Taruhan 2D" min="0" value="">
            </div>
        </div>

        <div class="bet-button text-center mb-4">
            <button id="button-generate-bbfs" class="custom-btn color-primary btn-secondary">
                <i class="fa fa-calculator"></i>
                <span>Hitung Kombinasi BBFS</span>
            </button>
        </div>

        <div class="mt-4">
            <h6 class="fw-bold">Hasil Kombinasi BBFS:</h6>
            <table id="bbfs-table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="check-all" checked></th>
                        <th>Kombinasi</th>
                        <th>Total Bayar</th>
                        <th>Status</th>
                        <th>Pesan</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- hasil via JS -->
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" class="text-end">Total Bayar Semua:</th>
                        <th id="grand-total-bayar">0</th>
                        <th colspan="2"></th>
                    </tr>
                </tfoot>
            </table>
            <div class="text-center mt-2">
                <button id="button-submit-selected" class="custom-btn color-primary btn-secondary">
                    <i class="fa fa-check-circle"></i> Konfirmasi Taruhan Terpilih
                </button>
            </div>
        </div>
    </div>
</div>

@push('script')
<script>
$(document).ready(function() {

    const minBet = parseFloat({{ $result->min_bet ?? 0 }});
    const maxBet = parseFloat({{ $result->max_bet ?? 0 }});

    // Tambahkan info Min/Max Bet di atas input taruhan
    function addBetLimitInfo() {
        const betInputs = $("#bet-4d, #bet-3d, #bet-2d");
        betInputs.each(function(){
            if(!$(this).prev().hasClass("bet-limit-info")) {
                $(this).before(`<div class="bet-limit-info" style="font-size:12px; color:#888;">Min Bet: ${minBet} | Max Bet: ${maxBet}</div>`);
            }
        });
    }
    addBetLimitInfo();

    // Validasi otomatis input taruhan sesuai Min/Max Bet
    function validateBetInput(input) {
        let val = parseFloat($(input).val()) || 0;
        if(val < minBet) val = minBet;
        if(val > maxBet) val = maxBet;
        $(input).val(val);
    }

    $("#bet-4d, #bet-3d, #bet-2d").on("input blur", function(){
        validateBetInput(this);
    });

    // Generate kombinasi BBFS
    function getCombinations(arr, k) {
        let results = [];
        function helper(start, combo) {
            if (combo.length === k) {
                results.push(combo.join(""));
                return;
            }
            for (let i = start; i < arr.length; i++) {
                helper(i + 1, combo.concat(arr[i]));
            }
        }
        helper(0, []);
        return results;
    }

    // Generate table BBFS langsung dengan Total Bayar sesuai nominal input
    function generateBbfsTable(combos, bet4d, bet3d, bet2d) {
        const tbody = $("#bbfs-table tbody");
        tbody.empty();
        combos.forEach(c => {
            let total = 0;
            if(c.length >= 4) total = bet4d;
            else if(c.length == 3) total = bet3d;
            else if(c.length == 2) total = bet2d;

            tbody.append(`
                <tr>
                    <td><input type="checkbox" class="bbfs-check" checked></td>
                    <td class="combo">${c}</td>
                    <td class="total-bayar">${total}</td>
                    <td class="status">-</td>
                    <td class="message">-</td>
                </tr>
            `);
        });
        updateGrandTotal();
    }

    // Hitung grand total
    function updateGrandTotal() {
        let grandTotal = 0;
        $("#bbfs-table tbody tr").each(function(){
            grandTotal += parseFloat($(this).find(".total-bayar").text()) || 0;
        });
        $("#grand-total-bayar").text(grandTotal);
    }

    // Generate kombinasi BBFS
    $("#button-generate-bbfs").on("click", function(){
        let digit = $("#game-digit-input").val().trim();
        let bet4d = parseFloat($("#bet-4d").val()) || 0;
        let bet3d = parseFloat($("#bet-3d").val()) || 0;
        let bet2d = parseFloat($("#bet-2d").val()) || 0;

        // Validasi input taruhan
        bet4d = Math.max(minBet, Math.min(bet4d, maxBet));
        bet3d = Math.max(minBet, Math.min(bet3d, maxBet));
        bet2d = Math.max(minBet, Math.min(bet2d, maxBet));
        $("#bet-4d").val(bet4d);
        $("#bet-3d").val(bet3d);
        $("#bet-2d").val(bet2d);

        if(digit === ""){
            new Notify({ text: "Masukkan angka!", status: "error", autoclose: true, effect: "slide" });
            return;
        }

        let arr = digit.split("");
        let allCombos = [];
        [2,3,4].forEach(k => {
            if(arr.length >= k){
                allCombos = allCombos.concat(getCombinations(arr, k));
            }
        });

        generateBbfsTable(allCombos, bet4d, bet3d, bet2d);
    });

    // Checkbox semua
    $("#check-all").on("change", function(){
        $(".bbfs-check").prop("checked", $(this).is(":checked"));
    });

    // Submit kombinasi yang dicentang
    async function submitSelectedBbfs() {
        const rows = $("#bbfs-table tbody tr");
        for(let i=0;i<rows.length;i++){
            let row = $(rows[i]);
            if(row.find(".bbfs-check").is(":checked")){
                let combo = row.find(".combo").text();
                let total = parseFloat(row.find(".total-bayar").text()) || 0;

                row.find(".status").text("Proses...");
                row.find(".message").text("");

                try {
                    let response = await $.ajax({
                        url: "{{ route('games.taruhan') }}",
                        type: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}",
                            betAmount: total,
                            bet: combo,
                            type : "Bbfs",
                            market : "{{ $result->title }}",
                        }
                    });
                    row.find(".status").text("Berhasil").addClass("text-success");
                    row.find(".message").text(response.message);
                } catch (err) {
                    row.find(".status").text("Gagal").addClass("text-danger");
                    row.find(".message").text(err.responseJSON?.message ?? 'Error');
                }
            }
        }
    }

    $("#button-submit-selected").on("click", function(){
        submitSelectedBbfs();
    });
});
</script>
@endpush


