@extends('gameloby.layouts.main')
@section('content')
<main>
    <div class="container">
        <div class="global-title global-title-black">
            <div class="icon-market-game" data-bs-toggle="dropdown">
                <img src="{{ $result->logo }}" class="active-img-bounce">
                <h4 class="ml-2">{{ $result->title }}</h4>
            </div>

            <div class="dropdown-menu dropdown-menu-market">
                <div class="market-draw">
                    <div class="market-draw__list">
                        <div class="row justify-content-center">

                            @foreach (togels() as $det)
                            <div class="col-lg-2 col-md-3 col-4 px-2">
                                <div class="market-draw-item">
                                    <img src="{{ $det->logo }}">
                                    <span class="d-block font-weight-bold market-name">{{ $det->title }}</span>
                                    <a href="{{ route('games.play',$det->slug) }}">
                                        <button type="button" class="custom-btn color-secondary custom-sm"><i
                                                class="fa fa-play-circle"></i><span trs="play">Main
                                                Game</span></button>
                                    </a>
                                </div>
                            </div>
                            @endforeach


                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="market-timer">
            <div class="market-timer__counter">
                <div class="counter-result">
                    <div class="row d-flex text-start">
                        <div class="fs-p8r fw-bolder" trs="lastResultLive">Keluaran Terakhir</div>

                        <div class="col-sm order-1">
                            <div class="result-title">1st</div>
                            <h1>{{ $result->keluaran }}</h1>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="custom-breadcrumb" aria-label="breadcrumb">
            <div class="dropdown dropdown-info-all new-grid-test">

                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i
                        class="fa fa-question-circle me-1"></i><span trs="marketInfo">Info Pasaran</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="market-timer__container">
                        <div class="market-timer-content">
                            <div class="info-list">
                                <div class="item">
                                    <div class="title" trs="undian">Jam Undian</div>
                                    <div class="subtitle">: {{ $result->buka }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i class="fa fa-question-circle"></i><span
                        trs="gamesInfo">Info Permainan</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="custom-table">
                        <div class="custom-table__header" trs="gamesInfo">Info Permainan</div>
                        <table id="table_game_terms" class="stripe cell-border dataTable custom-table-game-info"
                            cellspacing="0" width="100%" data-level="1" data-role="Digit" section="10791" dt-c="1">
                            <thead>
                                <tr>
                                    <th class="sorting sorting_asc" tabindex="0" aria-controls="table_game_terms"
                                        rowspan="1" colspan="1" style="width: 68px;" aria-sort="ascending"
                                        aria-label="Desc: activate to sort column descending">Desc</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 89px;"
                                        aria-label="4D: activate to sort column ascending">4D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 99px;"
                                        aria-label="3D: activate to sort column ascending">3D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 102px;"
                                        aria-label="2D: activate to sort column ascending">2D</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Diskon</td>
                                    <td>66%</td>
                                    <td>59%</td>
                                    <td>29%</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Kei</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td>-</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Max Bet</td>
                                    <td>Rp&nbsp;200.000</td>
                                    <td>Rp&nbsp;1.000.000</td>
                                    <td>Rp&nbsp;5.000.000</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Min Bet</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Prize</td>
                                    <td>3000x</td>
                                    <td>400x</td>
                                    <td>70x</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="global-bet">
    <div class="global-bet__header text-center">Pasang Nomor Anda</div>
    <div class="global-bet__body">
        <div class="bet-title text-center">
            <h6>Digit Set - {{ $result->title }} - Periode {{ $result->periode }}</h6>
            <h6>Kombinasi Angka (acak dari input 2-4 digit)</h6>
        </div>

        <div class="bet-content d-flex align-items-center mb-2">
            <input type="number" id="game-digit-input" class="bet-input-digit form-control" placeholder="xxxx"
                maxlength="4" min="0" max="9999" value="">
        </div>

        <div class="bet-pouch mb-3">
            <div class="row">
                <div class="col">
                    <div class="bet-label text-center mt-2 mb-1">Jumlah Taruhan</div>
                    <input id="bet-amount" class="bet-input-amount form-control" type="number" min=0 value="">
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-center mb-4 gap-2">
            <button id="button-generate-digitset" class="custom-btn btn-info">Generate ke Tabel</button>
        </div>

        <div class="mt-4">
            <h6 class="fw-bold">Hasil Taruhan Digit Set:</h6>
            <table id="digitset-table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="check-all-digitset" checked></th>
                        <th>Angka</th>
                        <th>Total Bayar</th>
                        <th>Status</th>
                        <th>Pesan</th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" class="text-end">Total Bayar Semua:</th>
                        <th id="grand-total-digitset">0</th>
                        <th colspan="2"></th>
                    </tr>
                </tfoot>
            </table>

            <div class="text-center mt-3">
                <button id="button-submit-digitset" class="custom-btn color-primary btn-secondary">
                    <i class="fa fa-check-circle"></i> Konfirmasi Taruhan
                </button>
            </div>
        </div>
    </div>
</div>

@push('script')
<script>
$(document).ready(function() {

    const minBet = parseFloat({{ $result->min_bet ?? 0 }});
    const maxBet = parseFloat({{ $result->max_bet ?? 0 }});

    // Fungsi untuk menghasilkan semua permutasi angka
    function permuteArray(arr) {
        if(arr.length <= 1) return [arr.join('')];
        let result = [];
        for(let i = 0; i < arr.length; i++){
            let rest = arr.slice(0, i).concat(arr.slice(i + 1));
            permuteArray(rest).forEach(r => result.push(arr[i] + r));
        }
        return result;
    }

    // Update total semua baris di tabel Digit Set
    function updateGrandTotalDigitSet() {
        let grandTotal = 0;
        $("#digitset-table tbody tr").each(function(){
            grandTotal += parseFloat($(this).find(".total-bayar").text()) || 0;
        });
        $("#grand-total-digitset").text(grandTotal);
    }

    // Generate kombinasi dan tambah baris ke tabel
    $("#button-generate-digitset").on('click', function() {
        let bet = parseFloat($('#bet-amount').val()) || 0;
        let digits = $('#game-digit-input').val().trim();

        // Validasi Min Bet
        if (bet < minBet) {
            new Notify({ text: `Minimal taruhan adalah Rp ${minBet}`, status: "error", autoclose: true, effect: "slide" });
            return;
        }

        // Validasi Max Bet
        if (bet > maxBet) {
            new Notify({ text: `Maksimal taruhan adalah Rp ${maxBet}`, status: "error", autoclose: true, effect: "slide" });
            return;
        }

        if (bet <= 0) {
            new Notify({ text: "Nominal Taruhan Belum Diisi", status: "error", autoclose: true, effect: "slide" });
            return;
        }

        if (digits.length < 2 || digits.length > 4) {
            new Notify({ text: "Masukkan angka 2-4 digit", status: "error", autoclose: true, effect: "slide" });
            return;
        }

        const combos = permuteArray(digits.split(''));
        const tbody = $("#digitset-table tbody");

        // Hapus tabel sebelumnya
        tbody.empty();

        combos.forEach(c => {
            tbody.append(`
                <tr>
                    <td><input type="checkbox" class="digitset-check" checked></td>
                    <td class="combo">${c}</td>
                    <td class="total-bayar">${bet}</td>
                    <td class="status">-</td>
                    <td class="message">-</td>
                </tr>
            `);
        });

        updateGrandTotalDigitSet();
        $('#game-digit-input').val('');
    });

    // Checkbox untuk pilih semua
    $("#check-all-digitset").on("change", function(){
        $(".digitset-check").prop("checked", $(this).is(":checked"));
    });

    // Kirim taruhan yang dicentang
    async function submitDigitSetBets() {
        const rows = $("#digitset-table tbody tr");
        for(let i = 0; i < rows.length; i++){
            let row = $(rows[i]);
            if(row.find(".digitset-check").is(":checked")){
                let combo = row.find(".combo").text();
                let total = parseFloat(row.find(".total-bayar").text()) || 0;

                // Validasi Min Bet
                if (total < minBet) {
                    row.find(".status").text("❌").addClass("text-danger");
                    row.find(".message").text(`Minimal taruhan adalah Rp ${minBet}`);
                    continue;
                }

                // Validasi Max Bet
                if (total > maxBet) {
                    row.find(".status").text("❌").addClass("text-danger");
                    row.find(".message").text(`Maksimal taruhan adalah Rp ${maxBet}`);
                    continue;
                }

                let d2 = 0, d3 = 0, d4 = 0;
                if(combo.length === 2) d2 = total;
                else if(combo.length === 3) d3 = total;
                else if(combo.length === 4) d4 = total;

                row.find(".status").text("⏳ Proses...").removeClass("text-success text-danger");
                row.find(".message").text("");

                try {
                    let response = await $.ajax({
                        url: "{{ route('games.taruhan') }}",
                        type: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}",
                            pasang: combo,
                            d2: d2,
                            d3: d3,
                            d4: d4,
                            type: "Digit Set",
                            market: "{{ $result->title }}",
                            discount: "diskon"
                        }
                    });

                    row.find(".status").text("✅ Berhasil").addClass("text-success");
                    row.find(".message").text(response.message || '');
                } catch (err) {
                    row.find(".status").text("❌ Gagal").addClass("text-danger");
                    row.find(".message").text(err.responseJSON?.message || 'Error');
                }
            }
        }
        updateGrandTotalDigitSet();
    }

    $("#button-submit-digitset").on("click", submitDigitSetBets);

});
</script>
@endpush





