@extends('gameloby.layouts.main')
@section('content')
<main>
    <div class="container">
        <div class="global-title global-title-black">
            <div class="icon-market-game" data-bs-toggle="dropdown">
                <img src="{{ $result->logo }}" class="active-img-bounce">
                <h4 class="ml-2">{{ $result->title }}</h4>
            </div>

            <div class="dropdown-menu dropdown-menu-market">
                <div class="market-draw">
                    <div class="market-draw__list">
                        <div class="row justify-content-center">

                            @foreach (togels() as $det)
                            <div class="col-lg-2 col-md-3 col-4 px-2">
                                <div class="market-draw-item">
                                    <img src="{{ $det->logo }}">
                                    <span class="d-block font-weight-bold market-name">{{ $det->title }}</span>
                                    <a href="{{ route('games.play',$det->slug) }}">
                                        <button type="button" class="custom-btn color-secondary custom-sm"><i
                                                class="fa fa-play-circle"></i><span trs="play">Main
                                                Game</span></button>
                                    </a>
                                </div>
                            </div>
                            @endforeach


                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="market-timer">
            <div class="market-timer__counter">
                <div class="counter-result">
                    <div class="row d-flex text-start">
                        <div class="fs-p8r fw-bolder" trs="lastResultLive">Keluaran Terakhir</div>

                        <div class="col-sm order-1">
                            <div class="result-title">1st</div>
                            <h1>{{ $result->keluaran }}</h1>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="custom-breadcrumb" aria-label="breadcrumb">
            <div class="dropdown dropdown-info-all new-grid-test">

                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i
                        class="fa fa-question-circle me-1"></i><span trs="marketInfo">Info Pasaran</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="market-timer__container">
                        <div class="market-timer-content">
                            <div class="info-list">
                                <div class="item">
                                    <div class="title" trs="undian">Jam Undian</div>
                                    <div class="subtitle">: {{ $result->buka }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="dropdown-info-all-box" data-bs-toggle="dropdown"><i class="fa fa-question-circle"></i><span
                        trs="gamesInfo">Info Permainan</span></div>
                <div class="dropdown-menu dropdown-menu-info">
                    <div class="custom-table">
                        <div class="custom-table__header" trs="gamesInfo">Info Permainan</div>
                        <table id="table_game_terms" class="stripe cell-border dataTable custom-table-game-info"
                            cellspacing="0" width="100%" data-level="1" data-role="Digit" section="10791" dt-c="1">
                            <thead>
                                <tr>
                                    <th class="sorting sorting_asc" tabindex="0" aria-controls="table_game_terms"
                                        rowspan="1" colspan="1" style="width: 68px;" aria-sort="ascending"
                                        aria-label="Desc: activate to sort column descending">Desc</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 89px;"
                                        aria-label="4D: activate to sort column ascending">4D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 99px;"
                                        aria-label="3D: activate to sort column ascending">3D</th>
                                    <th class="sorting" tabindex="0" aria-controls="table_game_terms" rowspan="1"
                                        colspan="1" style="width: 102px;"
                                        aria-label="2D: activate to sort column ascending">2D</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Diskon</td>
                                    <td>66%</td>
                                    <td>59%</td>
                                    <td>29%</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Kei</td>
                                    <td>-</td>
                                    <td>-</td>
                                    <td>-</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Max Bet</td>
                                    <td>Rp&nbsp;200.000</td>
                                    <td>Rp&nbsp;1.000.000</td>
                                    <td>Rp&nbsp;5.000.000</td>
                                </tr>
                                <tr class="even">
                                    <td class="dtr-control sorting_1" tabindex="0">Min Bet</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                    <td>Rp&nbsp;500</td>
                                </tr>
                                <tr class="odd">
                                    <td class="dtr-control sorting_1" tabindex="0">Prize</td>
                                    <td>3000x</td>
                                    <td>400x</td>
                                    <td>70x</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="global-bet">
    <div class="global-bet__header text-center">Pasang Shio Anda</div>
    <div class="global-bet__body">
        <div class="bet-title text-center">
            <h6>Shio - {{ $result->title }} - Periode {{ $result->periode }}</h6>
        </div>

        <div class="mb-4">
            <table class="table table-bordered shio-table">
                <thead>
                    <tr>
                        <th>Tebakan</th>
                        <th>Jumlah Taruhan</th>
                        <th>Bayar</th>
                        <th>X</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $shios = ['Tikus','Sapi','Harimau','Kelinci','Naga','Ular','Kuda','Kambing','Monyet','Ayam','Anjing','Babi'];
                    @endphp

                    @foreach($shios as $shio)
                    <tr>
                        <td>{{ $shio }}</td>
                        <td><input type="number" class="bet-input form-control" min="0" value="0"></td>
                        <td class="total-bayar">0</td>
                        <td><button class="btn btn-sm btn-danger remove-row">X</button></td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th class="text-end">Total Bayar:</th>
                        <th colspan="2" class="grand-total">0</th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div class="text-center mt-3">
            <button id="button-submit-shio" class="custom-btn color-primary btn-secondary">
                <i class="fa fa-check-circle"></i> Konfirmasi Taruhan
            </button>
        </div>
    </div>
</div>


@push('script')
<script>
$(document).ready(function() {

    const minBet = parseFloat({{ $result->min_bet ?? 0 }});
    const maxBet = parseFloat({{ $result->max_bet ?? 0 }});

    function updateGrandTotal(table) {
        let total = 0;
        table.find("tbody tr").each(function(){
            let bet = parseFloat($(this).find(".bet-input").val()) || 0;
            $(this).find(".total-bayar").text(bet);
            total += bet;
        });
        table.find(".grand-total").text(total);
    }

    // Hapus baris
    $(document).on("click", ".remove-row", function(){
        $(this).closest("tr").remove();
        updateGrandTotal($(this).closest("table"));
    });

    // Update total saat input berubah
    $(document).on("input", ".bet-input", function(){
        let table = $(this).closest("table");
        updateGrandTotal(table);
    });

    // Submit tabel Shio
    $("#button-submit-shio").on("click", async function(){
        let table = $(".shio-table");
        let valid = true;

        table.find("tbody tr").each(async function(){
            let row = $(this);
            let shio = row.find("td:first").text();
            let betAmount = parseFloat(row.find(".bet-input").val()) || 0;

            if(betAmount < minBet || betAmount > maxBet){
                new Notify({ 
                    text: `Taruhan harus antara ${minBet} dan ${maxBet}`, 
                    status: "error", autoclose: true, effect: "slide" 
                });
                valid = false;
                return false; // hentikan loop
            }

            if(betAmount <= 0){
                new Notify({ text: "Harap masukkan taruhan!", status: "error", autoclose: true, effect: "slide" });
                valid = false;
                return false;
            }

            row.find(".total-bayar").text("Proses...");
            try{
                let response = await $.ajax({
                    url: "{{ route('games.taruhan') }}",
                    type: 'POST',
                    data: {
                        _token: "{{ csrf_token() }}",
                        betAmount: betAmount,
                        bet: shio,
                        type: "Shio",
                        market: "{{ $result->title }}",
                    }
                });
                row.find(".total-bayar").text(betAmount);
                new Notify({ text: response.message, status: "success", autoclose: true, effect: "slide" });
            } catch(err){
                row.find(".total-bayar").text("Gagal");
                new Notify({ text: err.responseJSON?.message ?? 'Error', status: "error", autoclose: true, effect: "slide" });
            }
        });

        if(valid) updateGrandTotal(table);
    });

});
</script>
@endpush






