@extends('gameloby.layouts.main')

@section('content')
<main id="home-page">
    <div class="container">
        <div class="home__lottery">

            {{-- Live Market --}}
            <div class="global-title">
                <img src="{{ asset('static/img/icons/star.svg') }}">
                <h4 trs="liveMarket">Live Market</h4>
            </div>

            <div class="item-container">
                @foreach ($live as $lv)
                <div class="lottery-item" c="{{ $loop->iteration }}" i="{{ $lv->slug }}">
                    <div class="lottery-result shadow-dark">
                        <div class="content">
                            <div class="content-info">
                                <h6>
                                    <i class="fa fa-circle fa-xs" style="color:{{ $lv->status == 1 ? '#15ff00' : '#ff0000' }}"></i>
                                    {{ $lv->title }}
                                </h6>
                                <div class="date">{{ date('D', strtotime($lv->tanggal)) }}, {{ $lv->tanggal }}</div>
                                <div class="periode">
                                    <strong trs="periode">Periode</strong> {{ $lv->periode }}
                                </div>
                            </div>
                            <div class="content-result d-flex flex-column">
                                <img src="{{ $lv->logo }}">
                                <div class="result-item order-1">
                                    <div class="number">{{ $lv->keluaran }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="result-footer">
                            <div class="info">{{ $lv->buka }}</div>
                        </div>
                    </div>
                    <div class="lottery-button">
                        <a href="{{ route('games.result', $lv->slug) }}">
                            <button class="custom-btn-fix color-secondary mb-3">
                                <i class="fa fa-check-circle fa-2xl"></i>
                                <span trs="resultBtn">Hasil Keluaran</span>
                            </button>
                        </a>

                        @if($lv->status == 1)
                            <a href="{{ route('games.games', $lv->slug) }}">
                                <button class="custom-btn-fix color-danger">
                                    <i class="fa fa-play-circle fa-2xl"></i>
                                    <span trs="betBtn">Pasang</span>
                                </button>
                            </a>
                        @else
                            <button class="custom-btn-fix color-danger" disabled>
                                <i class="fa fa-lock fa-2xl"></i>
                                <span>Closed</span>
                            </button>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>

            {{-- Favorite Market --}}
            <div class="global-title mt-5">
                <img src="{{ asset('static/img/icons/star.svg') }}">
                <h4 trs="favoriteMarket">Favorite Market</h4>
            </div>

            <div class="item-container">
                @foreach ($data as $item)
                <div class="lottery-item" c="{{ $loop->iteration }}" i="{{ $item->slug }}">
                    <div class="lottery-result shadow-dark">
                        <div class="content">
                            <div class="content-info">
                                <h6>
                                    <i class="fa fa-circle fa-xs" style="color:{{ $item->status == 1 ? '#15ff00' : '#ff0000' }}"></i>
                                    {{ $item->title }}
                                </h6>
                                <div class="date">{{ date('D', strtotime($item->tanggal)) }}, {{ $item->tanggal }}</div>
                                <div class="periode">
                                    <strong trs="periode">Periode</strong> {{ $item->periode }}
                                </div>
                            </div>
                            <div class="content-result d-flex flex-column">
                                <img src="{{ $item->logo }}">
                                <div class="result-item order-1">
                                    <div class="number">{{ $item->keluaran }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="result-footer">
                            <div class="info">
                                <span trs="jamTutup">Jam Tutup</span> {{ $item->tutup }}
                                <span class="ct"></span> |
                                <span trs="undian">Jam Undian</span> {{ $item->buka }}
                                <span class="ot"></span>
                            </div>
                        </div>
                    </div>

                    <div class="lottery-button">
                        <a href="{{ route('games.result', $item->slug) }}">
                            <button class="custom-btn-fix color-secondary mb-3">
                                <i class="fa fa-check-circle fa-2xl"></i>
                                <span trs="resultBtn">Hasil Keluaran</span>
                            </button>
                        </a>

                        @if($item->status == 1)
                            <a href="{{ route('games.games', $item->slug) }}">
                                <button class="custom-btn-fix color-danger">
                                    <i class="fa fa-play-circle fa-2xl"></i>
                                    <span trs="betBtn">Pasang</span>
                                </button>
                            </a>
                        @else
                            <button class="custom-btn-fix color-danger" disabled>
                                <i class="fa fa-lock fa-2xl"></i>
                                <span>Closed</span>
                            </button>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>

        </div>
    </div>
</main>
@endsection
