@extends('gameloby.layouts.main')
@section('content')
<main>
    <div class="container">
        <div class="history-bet__container">
            <div class="d-flex justify-content-between">
                <div class="global-title mb-0">
                    <img src="{{ asset('static/img/icons/history.svg') }}">
                    <h4 class="ml-2" id="titleBet" trs="invoiceHistory">Riwayat Taruhan</h4>
                </div>
            </div>
            <div class="custom-table mt-2">
                <table id="table_market_result" class="stripe cell-border">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Tanggal</th>
                            <th>T-ID</th>
                            <th>Pasaran</th>
                            <th>Permainan</th>
                            <th>Pasang</th>
                            <th>Jumlah Taruhan</th>
                            <th>Bayar</th>
                            <th>Menang</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($transaksi as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->date }}</td>
                            <td>{{ $item->tid }}</td>
                            <td>{{ $item->market }}</td>
                            <td>{{ $item->type }}</td>
                            <td>{{ $item->pasang }}</td>
                            <td>{{ number_format($item->amount_bet) }}</td>
                            <td>{{ number_format($item->amount) }}</td>
                            <td>{{ number_format($item->win) }}</td>
                            <td>
                                @if($item->status == 1)
                                Menunggu
                                @elseif ($item->status == 2)
                                Menang
                                @else
                                Kalah
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

@endsection
