<!DOCTYPE html>

<html>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>{{ general()->judul }} - Lobby</title>
    <meta name="robots" content="noindex nofollow">
    <link rel="shortcut icon" type="image/png"
        href="{{ general()->icon_web }}">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Montserrat:wght@900&display=swap">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.6/css/responsive.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/simple-notify@0.5.5/dist/simple-notify.min.css">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.1.1/css/all.css">
    <script type="text/javascript" src="{{ asset('static/js/app.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('static/css/style.min.css') }}">

</head>

<body>

    <header>
        <div class="container">
            <div class="wallet">
                <i class="fa fa-wallet fa-lg me-2"></i>
                <h6 class="fw-bold"><span class="me-2 d-none">IDR</span><span id="ballance">{{ number_format(auth()->user()->balance / 1000, 2) }}</span></h6>
                <i id="reloadSaldo" class="fa fa-refresh ms-2"></i>
            </div>
            <div class="running-header-container">
                <div class="running-header">
                    <div class="me-2">SELAMAT DATANG DI {{ general()->judul }}</div>
                </div>
            </div>
            <div class="lang-container">
                <div class="box-lang">
                    <div class="flag-lang">&#x1F1EE;&#x1F1E9;</div>
                    <select id="playerLanguage" data-i18n-switcher d-lang="id">
                        <option value="id">&#x1F1EE;&#x1F1E9;</option>
                        <option value="en">&#127482;&#127480;</option>
                    </select>
                </div>
                <div class="sidenav-toggle"><i class="fa fa-bars fa-xl"></i></div>
            </div>
        </div>
    </header>

    <nav>
        <div class="sidenav__header">
            <div class="header-greeting"><span>
                    <c-t trs="welcome">Selamat Datang</c-t>, {{ auth()->user()->extplayer }}
                </span></div>
            
        </div>

        <div class="sidenav__list">
            <ul>
                <a href="{{ route('games.index') }}">
                    <li><i class="fa fa-home"></i>
                        <c-t trs="home">Beranda</c-t>
                    </li>
                </a>
                <a href="{{ route('games.howto') }}">
                    <li><i class="fa fa-circle-question"></i>
                        <c-t trs="help">Bantuan</c-t>
                    </li>
                </a>
                <a href="{{ route('games.invoice') }}">
                    <li><i class="fa fa-file"></i>
                        <c-t trs="history">Riwayat</c-t>
                    </li>
                </a>
                <a href="{{ route('games.mimpi') }}">
                    <li><i class="fa fa-book-bookmark"></i>
                        <c-t trs="bukuMimpi">Buku Mimpi</c-t>
                    </li>
                </a>
            </ul>
        </div>
    </nav>


    <footer>
        <div class="footer__item"><a href="{{ route('games.index') }}">
                <div class="icon"><i class="fa fa-house"></i></div>
                <div class="name" trs="home">Beranda</div>
            </a></div>
        <div class="footer__item"><a href="{{ route('games.howto') }}">
                <div class="icon"><i class="fa fa-circle-question"></i></div>
                <div class="name" trs="help">Bantuan</div>
            </a></div>
        <div class="footer__item item-game"><a href="" data-bs-toggle="modal" data-bs-target="#playGame">
                <div class="icon"><i class="fa fa-circle-play"></i></div>
                <div class="name" trs="play">Main</div>
            </a></div>
        <div class="footer__item"><a href="{{ route('games.invoice') }}">
                <div class="icon"><i class="fa fa-file"></i></div>
                <div class="name" trs="history">Riwayat</div>
            </a></div>
        <div class="footer__item"><a href="{{ route('games.mimpi') }}">
                <div class="icon"><i class="fa fa-book-bookmark"></i></div>
                <div class="name" trs="bukuMimpi">Buku Mimpi</div>
            </a></div>
    </footer>

    <div class="modal fade custom-modal" id="playGame" tabindex="-1" aria-labelledby="playGameLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 trs="main">MAIN GAME</h5>
                </div>
                <div class="modal-body">
                    <div class="market-draw">
                        <div class="global-title global-title-black justify-content-center mb-3">
                            <img src="{{ asset('static/img/icons/star.svg') }}">
                            <h4 class="ml-2" trs="chooseMarket">Pilih Pasaran</h4>
                        </div>
                        <div class="market-draw__list">
                            <div class="row justify-content-center">

                                @foreach (togels() as $sel)
                                <div class="col-lg-2 col-md-3 col-4 px-2">
                                    <div class="market-draw-item">
                                        <a href="{{ route('games.games',$sel->slug) }}">
                                            <img src="{{ $sel->logo }}">
                                            <span class="d-block font-weight-bold market-name">{{ $sel->title }}</span>
                                        </a>
                                    </div>
                                </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer"><button class="custom-btn color-danger" data-bs-dismiss="modal"><i
                            class="fa fa-times-circle"></i><span trs="tutup">Tutup</span></button></div>
            </div>
        </div>
    </div>
    <div class="overlay"></div>

    @yield('content')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.3/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.6/js/dataTables.responsive.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/simple-notify@0.5.2/dist/simple-notify.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.0/sweetalert2.all.min.js"></script>

    <script src="{{ asset('static/js/script.min.js') }}"></script>
    <script>
        $('.bet-input-digit').keypress(function() {
            if (this.value.length >= this.maxLength) {
                return false;
            }
        });

        function notif(title, content, is_success = true) {
            new Notify({
                title: title,
                text: content,
                status: is_success ? "success" : "error",
                autoclose: true,
                effect: "slide",
            });
        }
    </script>

    @stack('script')

<script>
    $(document).ready(function() {
        function formatBalance(balance) {
            // bagi 1000 lalu format 2 angka di belakang koma
            return (balance / 1000).toFixed(2);
        }

        function reloadBalance() {
            $.ajax({
                type: "POST",
                url: "{{ route('api.balance') }}",
                data: { _token: "{{ csrf_token() }}" },
                success: function (response) {
                    if (response.success === true) {
                        $('#ballance').text(formatBalance(response.balance));
                    }
                }
            });
        }

        // load saldo pertama kali
        reloadBalance();

        // klik reload icon
        $("#reloadSaldo").on("click", function (e) {
            e.preventDefault();
            $('#ballance').text("....");
            $('#reloadSaldo').hide();

            $.ajax({
                type: "POST",
                url: "{{ route('api.balance') }}",
                data: { _token: "{{ csrf_token() }}" },
                success: function (response) {
                    if (response.success === true) {
                        $('#ballance').text(formatBalance(response.balance));
                        $('#reloadSaldo').show();
                    }
                }
            });
        });
    });
</script>


</body>

</html>
