<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Mews\Captcha\Facades\Captcha;
use App\Http\Controllers\TestApiController;
use App\Http\Controllers\Frontend\TransactionController;

use App\Http\Controllers\Game\TogelController;


Route::get('/sync-games', [TestApiController::class, 'syncGameList'])->name('sync.games');
Route::post('/callback/qris', [TransactionController::class, 'qrisCallback']);


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::prefix('bo')->group( function () {
    Route::namespace('Backend')->name('admin.')->group(function () {
        Route::namespace('Auth')->group(function () {
            Route::controller('LoginController')->group(function () {
                Route::get('/', 'showLoginForm')->name('login');
                Route::post('doLogin', 'login')->name('doLogin');
                Route::get('logout', 'logout')->name('logout');
            });
        });

        Route::get('app/cronsjob', 'DashboardController@cron')->name('cron');

        Route::middleware(['admin'])->group(function () {
           Route::prefix('lottery')->group(function () {
    Route::get('manage', 'LotteryController@index')->name('lottery.manage');
    Route::get('manage/add', 'LotteryController@create')->name('lottery.manage.create'); // Form tambah
    Route::post('manage/add', 'LotteryController@store')->name('lottery.manage.store'); // Proses simpan
    Route::get('manage/update/{id}', 'LotteryController@edit')->name('lottery.manage.edit'); // EDIT → GET
    Route::post('manage/update/{id}', 'LotteryController@update')->name('lottery.manage.update'); // UPDATE → POST
    Route::get('manage/history', 'LotteryController@history')->name('lottery.manage.history');
    Route::post('manage/toggle/{id}', 'LotteryController@toggleBet')->name('lottery.manage.toggle');
    Route::get('manage/settings', 'LotteryController@settings')->name('lottery.manage.settings');
    Route::post('manage/settings/update', 'LotteryController@settingsupdate')->name('lottery.manage.settings.update');
    // **Update result**
    Route::get('manage/result/{id}', 'LotteryController@editResult')->name('lottery.manage.result.edit');
    Route::post('manage/result/{id}', 'LotteryController@updateResult')->name('lottery.manage.result.update');

});

            Route::get('dashboard', 'DashboardController@index')->name('dashboard');
            Route::get('app/transaction-reports', 'DashboardController@reports')->name('reports');

            Route::get('profile', 'ProfileController@index')->name('profile');
            Route::post('profile/update', 'ProfileController@update')->name('profile.update');

            Route::get('members', 'MemberController@index')->name('members.list');
            Route::get('members/turn-over', 'MemberController@turn_over')->name('turnover');
            Route::get('members/create', 'MemberController@create')->name('member.create');
            Route::post('members/create/post', 'MemberController@createp')->name('member.createp');
            Route::get('members/{extplayer}/details', 'MemberController@details')->name('members.list.details');
            Route::get('members/{extplayer}/games/{games}', 'MemberController@games')->name('members.list.games');
            Route::get('members/{extplayer}/status/{status}', 'MemberController@status')->name('members.list.status');
            Route::post('members/{id}/update', 'MemberController@update')->name('members.list.update');
            Route::post('members/{extplayer}/bank', 'MemberController@banks')->name('members.list.bank');
            Route::get('members/balance', 'MemberController@balance')->name('members.balance');
            Route::get('members/{id}/bonus_update_v2', 'MemberController@update_statusc')->name('members.update_statusc');
            Route::get('members/{id}/bonus_update', 'MemberController@update_statusb')->name('members.update_statusb');
            Route::post('members/balance/add', 'MemberController@balanceup')->name('members.balance.update');
            

            Route::get('deposits/pending', 'DepositController@index')->name('deposits.pending');
            Route::get('deposits/transaction', 'DepositController@list')->name('deposits.list');
            Route::get('deposits/bonus-detail/{id}', 'DepositController@bonus_detail')->name('deposits.bonus_detail');
            Route::get('deposits/{id}/approve', 'DepositController@approve')->name('deposits.approve');
            Route::get('deposits/{id}/reject', 'DepositController@reject')->name('deposits.reject');

            Route::get('banks/account', 'BankController@index')->name('bank.list');
            Route::get('banks/{id}/edit', 'BankController@edit')->name('bank.edit');

            Route::post('banks/create', 'BankController@create')->name('bank.create');
            Route::post('banks/{id}/update', 'BankController@update')->name('bank.update');
            Route::get('banks/{id}/delete', 'BankController@delete')->name('bank.delete');

            Route::get('settings/website/seo_settings', 'SettingController@index')->name('settings.seo');
            Route::get('settings/website/logo_icon', 'SettingController@logo')->name('settings.logo');
            Route::get('settings/website/general_settings', 'SettingController@general')->name('settings.general');
            Route::get('settings/website/contact_settings', 'SettingController@contact')->name('settings.contact');
            Route::get('settings/website/contact_settings/{id}/edit', 'SettingController@contact_edit')->name('settings.contact_edit');
            Route::get('settings/website/contact_settings/{id}/delete', 'SettingController@contact_delete')->name('settings.contact_delete');
            Route::get('settings/config-clear', 'SettingController@clear')->name('settings.clear');
            Route::post('settings/website/seo_update', 'SettingController@seo_update')->name('settings.seo_update');
            Route::post('settings/website/update', 'SettingController@general_update')->name('settings.update');
            Route::post('settings/website/logo_update', 'SettingController@logo_update')->name('settings.logo_update');
            Route::post('settings/website/contact_settings/create_contact', 'SettingController@create_contact')->name('settings.create_contact');
            Route::post('settings/website/contact_settings/{id}/update_contact', 'SettingController@update_contact')->name('settings.update_contact');
            Route::post('settings/website/seo_settings/create_meta', 'SettingController@create_meta')->name('settings.create_meta');
            Route::get('settings/website/seo_settings/{id}/delete', 'SettingController@meta_delete')->name('settings.meta_delete');


            Route::get('settings/api/call-manage', 'ProviderController@call')->name('website.call');
            Route::get('settings/api/call/players', 'ProviderController@call_players')->name('website.call-players');
            Route::get('settings/api/call/list', 'ProviderController@call_list')->name('website.call_list');
            Route::get('settings/api/call/apply', 'ProviderController@call_apply')->name('website.call_apply');
            Route::get('settings/api/call/rtp', 'ProviderController@rtp')->name('website.rtp');

            Route::get('settings/promotion', 'PromotionController@index')->name('website.promotion');
            Route::get('settings/promotion/{id}/edit', 'PromotionController@edit')->name('website.promotion.edit');

            Route::get('settings/promotion-deposit', 'PromotionController@deposit')->name('website.deposit');
            Route::get('settings/promotion-deposit/{id}/edit', 'PromotionController@editd')->name('website.deposit.edit');

            Route::post('settings/promotion/{id}/update', 'PromotionController@update')->name('website.promotion.update');
            Route::post('settings/promotion/create', 'PromotionController@create')->name('website.promotion.create');
            Route::get('settings/promotion/{id}/delete', 'PromotionController@delete')->name('website.promotion.delete');

            Route::get('settings/banner', 'PromotionController@banner')->name('website.banner');
            Route::post('settings/banner/create', 'PromotionController@bcreate')->name('website.banner.create');
            Route::get('settings/banner/{id}/delete', 'PromotionController@bdelete')->name('website.banner.delete');

            Route::get('settings/floating', 'PromotionController@float')->name('website.floating');
            Route::get('settings/floating/{id}/edit', 'PromotionController@floatedit')->name('website.floating.edit');
            Route::post('settings/floating/{id}/update', 'PromotionController@floatupdate')->name('website.floating.update');
            Route::post('settings/floating/create', 'PromotionController@floatcreate')->name('website.floating.create');
            Route::post('settings/popup/update', 'PromotionController@popup')->name('website.floating.popup');
            Route::get('settings/floating/{id}/delete', 'PromotionController@floatdelete')->name('website.floating.delete');

            Route::get('settings/api/setting', 'ProviderController@index')->name('website.api');
            Route::post('settings/api/edit/{id}', 'ProviderController@edit')->name('website.api.update');
            Route::get('settings/api/use/{id}', 'ProviderController@use')->name('website.api.use');

            Route::get('admin/app/list', 'AdminController@index')->name('admin.list');
            Route::get('admin/app/edit/{id}', 'AdminController@edit')->name('admin.list.edit');
            Route::post('admin/app/create', 'AdminController@create')->name('admin.list.create');
            Route::post('admin/app/update/{id}', 'AdminController@update')->name('admin.list.update');
            Route::get('admin/app/delete/{id}', 'AdminController@delete')->name('admin.list.delete');

            Route::get('withdrawal/pending', 'WithdrawController@index')->name('withdrawal.pending');
            Route::get('withdrawal/transaction', 'WithdrawController@list')->name('withdrawal.list');
            Route::get('withdrawal/{id}/approve', 'WithdrawController@approve')->name('withdrawal.approve');
            Route::get('withdrawal/{id}/reject', 'WithdrawController@reject')->name('withdrawal.reject');

            Route::get('WinLoseReport/WinLose', 'GsReportController@index')->name('winlosereport.winlose');
            Route::get('WinLoseReport/ProductAgentWinLose', 'GsReportController@index')->name('winlosereport.product');
            Route::post('WinLoseReport/SearchWinLoseReport_V2', 'GsReportController@winlose')->name('winlosereport.winloses');

            Route::get('WinLoseSettlementReport/WinLose', 'GsReportController@settlement')->name('settle.winlose');
            Route::get('WinLoseSettlementReport/ProductAgentWinLose', 'GsReportController@settlement')->name('settle.product');
            Route::post('WinLoseSettlementReport/SearchWinLoseReport_V2', 'GsReportController@winloses')->name('settle.winloses');

            Route::get('admin/app/notification', 'AdminController@getNotif')->name('getNotif');
            Route::get('admin/app/notifications', 'AdminController@getNotifwd')->name('getNotif2');

            Route::get('lottery/pasaran', 'TaruhanController@index')->name('taruhan.list');
            Route::get('lottery/pasaran/{id}/edit', 'TaruhanController@pasaranedit')->name('taruhan.list.edit');
            Route::get('lottery/pasaran/{id}/delete', 'TaruhanController@pasarandelete')->name('taruhan.list.delete');
            Route::post('lottery/pasaran/{id}/update', 'TaruhanController@pasaranupdate')->name('taruhan.list.update');
            Route::post('lottery/pasaran/create', 'TaruhanController@pasarancreate')->name('taruhan.list.create');
            Route::get('lottery/result', 'TaruhanController@result')->name('taruhan.result');
            Route::post('lottery/result/create', 'TaruhanController@create')->name('taruhan.create');
            Route::get('lottery/betting/active', 'TaruhanController@active')->name('taruhan.active');
            Route::get('lottery/betting/history', 'TaruhanController@history')->name('taruhan.history');
            Route::get('lottery/betting/settings', 'TaruhanController@settings')->name('taruhan.settings');
            Route::post('lottery/betting/settings/update', 'TaruhanController@settingsupdate')->name('taruhan.settings.update');
            Route::post('taruhan/approve', 'TaruhanController@approve')->name('taruhan.approve');
            Route::post('taruhan/reject', 'TaruhanController@reject')->name('taruhan.reject');
        });
    });

    Route::get('config-clear', function () {
        Artisan::call('optimize:clear');
        return back()->with('success','Cache clear successfully');
    });
});

Route::namespace('Frontend')->group(function () {
    Route::get('account/login', 'HomeController@login')->name('login.form')->middleware('guest');
    Route::get('account/register', 'HomeController@register')->name('login.register')->middleware('guest');
    Route::post('api/account/register', 'HomeController@registers')->name('api.register')->middleware('guest');
    Route::get('/', 'HomeController@index')->name('index');
    Route::get('news', 'HomeController@news')->name('news');
    Route::get('help', 'HomeController@help')->name('help');
    Route::get('server_ip', 'HomeController@testapi')->name('testapi');
    Route::get('contact', 'HomeController@contact')->name('contact');
    Route::get('/data', 'HomeController@getresult')->name('data');
    Route::get('promotion', 'HomeController@promotion')->name('promotion');
    Route::get('promotion/{slug}', 'HomeController@promotiondetail')->name('promotiond');
    Route::get('referral', 'HomeController@refferal')->name('refferal');


    Route::get('game/{slug}/3', 'GameController@game')->name('SL');
    Route::get('game/{slug}/4', 'GameController@fishing')->name('FH');
    Route::get('game/{slug}/{provider}', 'GameController@casino')->name('casino');

    //route checkuser
    Route::post('userCheck', 'HomeController@check')->name('user.check');
    Route::post('userphone', 'HomeController@phone')->name('user.phone');
    Route::post('usernorek', 'HomeController@norek')->name('user.norek');

    Route::get('backup', 'HomeController@backup')->name('backup');

    Route::middleware(['auth'])->group(function () {
        Route::get('account/profile', 'UserController@profile')->name('account.profile');
        Route::get('account/password', 'UserController@password')->name('account.password');
        Route::post('api/account/setPassword', 'UserController@update')->name('update.password')->withoutMiddleware([Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class]);
        Route::get('bank/deposit', 'TransactionController@transaction')->name('bank.deposit');
        Route::get('bank/account', 'TransactionController@account')->name('bank.account');
        Route::get('bank/withdraw', 'TransactionController@withdraws')->name('bank.withdraws');
        Route::get('bank/history', 'TransactionController@history')->name('bank.history');
        Route::post('bank/setAccount', 'TransactionController@setAccount')->name('bank.setAccount');
        Route::get('play', 'HomeController@launchGame')->name('launchgame');
        Route::get('plays', 'HomeController@launchGames')->name('launchgames');
        Route::get('member/Getbalance', 'HomeController@getBalance2')->name('api.balance');
        Route::post('api/bank/transactionHistory', 'TransactionController@transaction_history')->name('transaksi.transaction_history');
        Route::post('api/bank/setDeposit', 'TransactionController@posttrx')->name('transaksi.deposit');
        Route::post('api/bank/setWithdraw', 'TransactionController@withdraw')->name('transaksi.withdraw');
    });
});

Route::prefix('GamesLobby/lottery/4d')->namespace('Game')->group(function () {
    Route::get('app/cronsjob', 'TogelController@cronsjobs')->name('games.cronsjob');

    // Semua route langsung tanpa middleware
    Route::get('/', 'TogelController@index')->name('games.index');
    Route::get('invoices', 'TogelController@invoice')->name('games.invoice');
    Route::get('results/{slug}', 'TogelController@result')->name('games.result');
    Route::get('games/{slug}', 'TogelController@games')->name('games.games');
    Route::get('play/{slug}/digit', 'TogelController@play')->name('games.play');
    Route::get('play/{slug}/shio', 'TogelController@shio')->name('games.shio');
    Route::get('play/{slug}/dasar', 'TogelController@dasar')->name('games.dasar');
    Route::get('play/{slug}/tepi-tengah', 'TogelController@tepitengah')->name('games.tepitengah');
    Route::get('play/{slug}/mono-stereo', 'TogelController@monostereo')->name('games.monostereo');
    Route::get('play/{slug}/kembang-kempis', 'TogelController@kembangkempis')->name('games.kembangkempis');
    Route::get('play/{slug}/50-50', 'TogelController@limapuluh')->name('games.limapuluh');
    Route::get('play/{slug}/kombinasi', 'TogelController@kombinasi')->name('games.kombinasi');
    Route::get('play/{slug}/player-banker', 'TogelController@playerbanker')->name('games.playerbanker');
    Route::get('play/{slug}/tarung', 'TogelController@tarung')->name('games.tarung');
    Route::get('play/{slug}/2d-position', 'TogelController@twod')->name('games.2d');
    Route::get('play/{slug}/3d-position', 'TogelController@trod')->name('games.3d');
    Route::get('play/{slug}/bbfs', 'TogelController@bbfs')->name('games.bbfs');
    Route::get('play/{slug}/quick-2d', 'TogelController@k2d')->name('games.k2d');
    Route::get('play/{slug}/digit-set', 'TogelController@ds')->name('games.ds');
    Route::get('play/{slug}/colok-bebas', 'TogelController@cbs')->name('games.cbs');
    Route::get('play/{slug}/colok-macau', 'TogelController@cmc')->name('games.cmc');
    Route::get('play/{slug}/colok-naga', 'TogelController@cng')->name('games.cng');
    Route::get('play/{slug}/colok-jitu', 'TogelController@cjt')->name('games.cjt');
    Route::get('buku-mimpi', 'TogelController@mimpi')->name('games.mimpi');
    Route::get('howto', 'TogelController@howto')->name('games.howto');
    Route::post('bet-play', 'TogelController@taruhan')->name('games.taruhan');
});


Route::middleware(['auth'])->namespace('Api')->group(function () {
    
});

Route::namespace('Auth')->group(function () {
    Route::any('api/account/logout', 'LoginController@logout')->name('member.logout');
});

Route::get('/captcha/login/{any}', function () {
    return captcha('default');
});


Route::namespace('Frontend')->group(function () {
    Route::post('api/security/checkCaptcha','HomeController@checkCaptcha')->name('api.checkCaptcha')->withoutMiddleware([Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('v2/api/account/login','HomeController@v2_acc_login')->name('api.v2_acc_login')->withoutMiddleware([Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class]);
});



Auth::routes();
