<!doctype html>

<html lang="en" class="light-style layout-wide customizer-hide" dir="ltr" data-theme="theme-default"
    data-assets-path="../assets/office/" data-template="vertical-menu-template">

<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>CP-GAMING Backoffice</title>
    <meta name="description" content="" />
    <meta name="robots" content="noindex, nofollow">
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/fonts/materialdesignicons.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/fonts/flag-icons.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/libs/node-waves/node-waves.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/css/rtl/core.css')); ?>" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/css/rtl/theme-default.css')); ?>"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/css/demo.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/libs/typeahead-js/typeahead.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/libs/@form-validation/form-validation.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/office/vendor/css/pages/page-auth.css')); ?>" />
    <script src="<?php echo e(asset('assets/office/vendor/js/helpers.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/js/template-customizer.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/js/config.js')); ?>"></script>
    <link rel="stylesheet" href="https://marcelodolza.github.io/iziToast/css/iziToast.css?v=150">
    <style>
        .ip-address {
            font-weight: bold;
            color: #333;
        }
    </style>
</head>

<body>
    <!-- Content -->

    <div class="position-relative">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner py-4">
                <!-- Login -->
                <div class="card p-2">
                    <!-- Logo -->
                    <div class="app-brand justify-content-center mt-5">
                        <a class="app-brand-link gap-2">
                            <img src="<?php echo e(asset('assets/office/img/cropped-LOGO-PNG-1.png')); ?>" alt="" width="250">
                        </a>
                    </div>
                    <!-- /Logo -->

                    <div class="card-body mt-4">
                        <form class="mb-4" action="<?php echo e(route('admin.doLogin')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-floating form-floating-outline mb-4">
                                <input type="text" class="form-control" id="us" name="username"
                                    placeholder="Username" value="<?php echo e(old('username')); ?>" autofocus required />
                                <label for="us">Username</label>
                            </div>
                            <div class="mb-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" id="password" class="form-control" name="password"
                                        placeholder=".........." aria-describedby="password" required />
                                    <label for="password">Password</label>
                                </div>
                            </div>
                            <div class="mb-3">
                                <button class="btn btn-primary d-grid w-100" type="submit">Sign in</button>
                            </div>
                        </form>
                    </div>
                    <p class="text-center">
                        <span>Your IP : </span><span class="ip-address" id="ip-address">Loading...</span></p>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- / Content -->

    <!-- Core JS -->
    <!-- build:js assets/office/vendor/js/core.js -->
    <script src="<?php echo e(asset('assets/office/vendor/libs/jquery/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/popper/popper.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/js/bootstrap.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/node-waves/node-waves.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/hammer/hammer.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/i18n/i18n.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/typeahead-js/typeahead.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/js/menu.js')); ?>"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="<?php echo e(asset('assets/office/vendor/libs/@form-validation/popular.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/@form-validation/bootstrap5.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/office/vendor/libs/@form-validation/auto-focus.js')); ?>"></script>
    <script src="https://marcelodolza.github.io/iziToast/js/vendor/iziToast.js?v=150" type="text/javascript">
    </script>
    <?php if(session('error')): ?>
        <script>
            iziToast.error({
                title: 'Error',
                position: 'topRight',
                message: '<?php echo e(session('error')); ?>',
            });
        </script>
    <?php endif; ?>

    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <script>
            iziToast.error({
                title: 'Error',
                position: 'topRight',
                message: '<?php echo e($message); ?>',
            });
        </script>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <script>
            iziToast.error({
                title: 'Error',
                position: 'topRight',
                message: '<?php echo e($message); ?>',
            });
        </script>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

    <script>
        function fetchIpAddress() {
            fetch('https://api.ipify.org?format=json')
                .then(response => response.json())
                .then(data => {
                    document.getElementById('ip-address').textContent = data.ip;
                })
                .catch(error => {
                    console.error('Error fetching IP address:', error);
                    document.getElementById('ip-address').textContent = 'Error fetching IP address';
                });
        }
        window.onload = fetchIpAddress;
    </script>

    <!-- Main JS -->
    <script src="<?php echo e(asset('assets/office/js/main.js')); ?>"></script>

    <!-- Page JS -->
    <script src="<?php echo e(asset('assets/office/js/pages-auth.js')); ?>"></script>
</body>

</html>
<?php /**PATH /www/wwwroot/infiny-lara.demo-api.xyz/core/resources/views/backend/auth/login.blade.php ENDPATH**/ ?>